require([
    "confluence/api/event",
    "internal/browser-metrics",
    "ajs",
    "jquery"
], function (
    event,
    metrics,
    AJS,
    $
) {

    function measureQuickEdit(event) {
        if (!$(event.target).hasClass('full-load')) {
            var dataType = event.data.type;
            // We avoid triggering an event when shared drafts are enabled but we don't have Synchrony
            //   this is a limited mode for Confluence to run in as a last resort, and shouldn't affect Apdex scores.
            if (AJS.Meta.getBoolean('collaborative-content')) {
                var metricKey = "confluence." + dataType + ".edit.collaborative.quick-view";
                metrics.start({
                    key: metricKey
                });
                AJS.bind("rte-collab-ready", function() {
                    metrics.end({
                        key: metricKey
                    });
                    metrics.start({
                        key: metricKey + ".connected"
                    });
                });
                AJS.bind("synchrony.connected", function() {
                    metrics.end({
                        key: metricKey + ".connected"
                    });
                });
            } else if (!AJS.Meta.getBoolean('shared-drafts')) {
                metrics.start({
                    key: "confluence." + dataType + ".edit.quick-view",
                    ready: ".active-richtext"
                });
            }
        }
    }

    function measureFilePreview() {
        metrics.start({
            key: "confluence.file.preview.firstpage"
        });

        // The completed events is emitted in confluence-previews
        //  to mark the ending point of loading the first part of a file into file previewer
        event.bind("confluence-previews.fileviewer.completed", function() {
            metrics.end({
                key: "confluence.file.preview.firstpage"
            });
        });
    }

    function measure() {
        var contentType = AJS.Meta.get('content-type');

        var isReactDashboard = $('#confluence-ui.confluence-dashboard').length;
        var isFallbackMode = window.location.href.indexOf('/content-only/') > -1;

        if (contentType) {
            // React dashboard fires the event in the front end repo so we shouldn't fire here
            if (!isReactDashboard && !isFallbackMode) {
                metrics.start({
                    key: "confluence." + contentType + ".view",
                    ready: ".wiki-content",
                    isInitial: true
                });
            }

            $("#editPageLink").on('click', {type: contentType}, measureQuickEdit);
            $(".confluence-embedded-file-wrapper").on('click', measureFilePreview);
        }
    }

    AJS.toInit(measure);
});
