define("confluence-mentions", ["ajs","confluence/meta","jquery","confluence/legacy","confluence/templates","confluence-editor/tinymce3/plugins/autocomplete/autocomplete-manager","tinymce","confluence/storage-manager","confluence/dark-features","confluence/analytics-support","confluence-link-browser/link-object","confluence-editor/tinymce3/plugins/autocomplete/autocomplete-settings"], function(__WEBPACK_EXTERNAL_MODULE_0__, __WEBPACK_EXTERNAL_MODULE_2__, __WEBPACK_EXTERNAL_MODULE_3__, __WEBPACK_EXTERNAL_MODULE_12__, __WEBPACK_EXTERNAL_MODULE_15__, __WEBPACK_EXTERNAL_MODULE_18__, __WEBPACK_EXTERNAL_MODULE_19__, __WEBPACK_EXTERNAL_MODULE_36__, __WEBPACK_EXTERNAL_MODULE_44__, __WEBPACK_EXTERNAL_MODULE_50__, __WEBPACK_EXTERNAL_MODULE_51__, __WEBPACK_EXTERNAL_MODULE_52__) { return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 20);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_0__;

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports) {
    'use strict';

    exports.default = {
        CURRENT: 'current',
        RELATED: 'related',
        RECENT: 'recent',
        SERVER: 'server'
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 2 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_2__;

/***/ }),
/* 3 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_3__;

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(0), __webpack_require__(29), __webpack_require__(36), __webpack_require__(1)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _ajs, _lruCache, _storageManager, _userSupplierKeys) {
    'use strict';

    var AJS = _interopRequireDefault(_ajs).default;

    var LRU = _interopRequireDefault(_lruCache).default;

    var StorageManager = _interopRequireDefault(_storageManager).default;

    var UserSupplier = _interopRequireDefault(_userSupplierKeys).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    /**
     * Returns users from a localstorage-backed LRU (least-recently-used) cache, and adds entries to that cache.
     */
    var inMemoryCache = void 0;
    var persistentCache = void 0;

    var CACHE_PREFIX = 'mentions';
    var CACHE_ID = 'recently-mentioned-users';
    var CACHE_ITEMS_KEY = 'items';

    /**
     * The maximum number of recently-mentioned users to keep in the cache.
     * @type {number}
     */
    var RECENT_USER_LIMIT = 20;
    /**
     * WaterTightValidation means that any users at or past this expiry _must_ be refreshed before being displayed in the UI.
     * @type {{expireTimeMillis: number}}
     */
    var WATERTIGHT_VALIDATION = { expireTimeMillis: 29 * 24 * 60 * 60 * 1000 }; //29 days in millis
    /**
     * EarlyValidation means that any users at or past this expiry _should_ be refreshed after the UI is completed (so as to not block users)
     * @type {{expireTimeMillis: number}}
     */
    var EARLY_VALIDATION = { expireTimeMillis: 7 * 24 * 60 * 60 * 1000 }; //7 days in millis
    /**
     * stores the enums used for calls to {getStaleUsers()}.
     * @type {{WATERTIGHT_VALIDATION: {expireTimeMillis: number}, EARLY_VALIDATION: {expireTimeMillis: number}}}
     */
    var ValidationType = { WATERTIGHT_VALIDATION: WATERTIGHT_VALIDATION, EARLY_VALIDATION: EARLY_VALIDATION };

    // Lazy-initialise to avoid interacting with localStorage when it isn't required.
    function loadCache() {
        inMemoryCache = LRU(RECENT_USER_LIMIT);
        persistentCache = new StorageManager(CACHE_PREFIX, CACHE_ID);

        var recentUsersDump = persistentCache.getItem(CACHE_ITEMS_KEY);
        if (recentUsersDump) {
            var recentUsersJson = JSON.parse(recentUsersDump);
            inMemoryCache.load(recentUsersJson);
        }
    }

    function getUsers() {
        return new Promise(function (resolve) {
            inMemoryCache || loadCache();

            // Add users with order of most-recently-mentioned first
            var users = [];
            var index = 0;
            inMemoryCache.forEach(function (user) {
                user.supplier = UserSupplier.RECENT;
                user.role = null;
                user.sortIndex = index++;
                users.push(user);
            });
            AJS.debug('Found ' + users.length + ' recently-mentioned users');
            resolve(users);
        });
    }

    /**
     * Store a recently-mentioned User in the cache.
     * @param user
     * @param refreshed {Boolean} true if the user is from the server. This will update the timestamp of the last refresh to now().
     *                            Defaults to false if not passed in.
     */
    function store(user, refreshed) {
        inMemoryCache || loadCache();
        var oldUser = inMemoryCache.peek(user.username);
        var oldRefreshDate = oldUser ? oldUser.refreshedAt || 0 : 0;
        var refreshedAt = refreshed || !oldUser ? new Date().getTime() : oldRefreshDate;
        inMemoryCache.set(user.username, Object.assign({}, user.model ? user.model : user, { timestamp: user.timestamp, refreshedAt: refreshedAt }));
        persistentCache.setItemQuietly(CACHE_ITEMS_KEY, JSON.stringify(inMemoryCache.dump()));
    }

    function remove(username) {
        inMemoryCache || loadCache();
        inMemoryCache.del(username);
        persistentCache.setItemQuietly(CACHE_ITEMS_KEY, JSON.stringify(inMemoryCache.dump()));
    }

    /**
     * A stale user is one which has not been refreshed from the server for X days or more, X being calculated from the validation type.
     * @param validationType {{expireTimeMillis: number}} an enum to flag what kind of stale users to return. Use a value from ValidationType
     * @return {Array} a list of stale usersnames (NOTE: not the user objects - just the usernames)
     */
    function getStaleUsers(validationType) {
        inMemoryCache || loadCache();
        var stale = [];
        var now = new Date().getTime();
        //use a hack to iterate the keys to prevent the LRU from changing the ordering
        var existingKeys = inMemoryCache.keys();
        existingKeys.map(function (k) {
            return [inMemoryCache.peek(k), k];
        }).forEach(function (entry) {
            var val = entry[0];
            var key = entry[1];
            if (!val.refreshedAt || now - val.refreshedAt > validationType.expireTimeMillis) {
                stale.push(key);
            }
        });
        return stale;
    }

    function refresh(users) {
        inMemoryCache || loadCache();
        users.forEach(function (user) {
            if (inMemoryCache.has(user.username)) {
                var entry = inMemoryCache.peek(user.username);
                var timestamp = entry.timestamp || 0;
                //treat no timestamp as though it is stale, and refresh it
                if (!user.timestamp || !timestamp || user.timestamp > timestamp) {
                    store(user, true);
                }
            }
        });
    }

    // Used in tests
    function _clear() {
        loadCache();
    }

    exports.default = {
        getUsers: getUsers,
        store: store,
        remove: remove,
        getStaleUsers: getStaleUsers,
        refresh: refresh,
        _clear: _clear,
        RECENT_USER_LIMIT: RECENT_USER_LIMIT,
        ValidationType: ValidationType
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 5 */
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(0), __webpack_require__(7), __webpack_require__(14), __webpack_require__(41), __webpack_require__(48), __webpack_require__(17)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _ajs, _userSupplierManager, _userCache, _pipelines, _executor, _scoreBooster) {
    'use strict';

    var AJS = _interopRequireDefault(_ajs).default;

    var userSupplierManager = _interopRequireDefault(_userSupplierManager).default;

    var UserCache = _interopRequireDefault(_userCache).default;

    var Pipelines = _interopRequireDefault(_pipelines).default;

    var PipelineExecutor = _interopRequireDefault(_executor).default;

    var ScoreBooster = _interopRequireDefault(_scoreBooster).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    'use strict';

    /**
     * The maximum number of Users that will be displayed in the Mentions dropdown.
     */
    var DISPLAY_LIMIT = 5;
    var NON_BREAKING_SPACE = String.fromCharCode(160);

    // The last query to be triggered, used when server responses return out of order and we need to skip the render of
    // stale responses.
    var latestQuery = void 0;

    /**
     *
     * @param {string}   query              User's query
     * @param {function} renderCallback     Callback function to render the results
     * @param {function} selectedUser       (optional) the currently-selected user in the dropdown
     * @param {object} editor               the currently-active editor
     */
    function searchAndRender(query, renderCallback, selectedUser, editor) {
        // Trim the query but don't convert to lowercase just yet - the ranker should handle this. (i.e. upper case
        // letters could be weighted higher in matches).
        // Note that 160 is the non-breaking-space character and is not handled by trim().
        // It IS handled by $.trim(str) but noooooo, noooooo.
        query = query.replace(NON_BREAKING_SPACE, ' ').trim();
        latestQuery = query;

        var promises = userSupplierManager.search(query, editor);

        promises.client.then(function () {
            resolveClientUsers();
            // Guarantee that server results are handled after local ones - chain the promises!
            promises.server.then(resolveServerUsers, renderErrorOnReject);
        }, renderErrorOnReject);

        function resolveClientUsers() {
            renderPipeline(UserCache.getAll(), query, renderCallback, selectedUser, false);
        }

        function resolveServerUsers() {
            // We could in future wrap the renderCallback so that if the server render would have the same values as the
            // client render, we skip it and avoid a browser repaint.
            renderPipeline(UserCache.getAll(), query, renderCallback, selectedUser, true);
        }

        function renderErrorOnReject() {
            var iterator = new PipelineExecutor(Pipelines.error(renderCallback));
            iterator.execute([]);
        }
    }

    function renderPipeline(users, query, renderCallback, selectedUser, isServerCall) {
        var context = {
            query: query,
            latestQuery: latestQuery,
            selectedUser: selectedUser,
            isServerCall: isServerCall,
            DISPLAY_LIMIT: DISPLAY_LIMIT
        };

        var pipeline = void 0;
        if (!query) {
            pipeline = Pipelines.default(renderCallback);
        } else {
            pipeline = isServerCall ? Pipelines.server(renderCallback) : Pipelines.client(renderCallback);
        }

        var executor = new PipelineExecutor(pipeline, context);
        executor.execute(users);
    }

    // Called during testing to clear caches.
    function reset() {
        userSupplierManager.reset();
        UserCache._clear();
        ScoreBooster.reset();
    }

    exports.default = {
        searchAndRender: searchAndRender,
        prefetchSuppliers: userSupplierManager.prefetchSuppliers,
        reset: reset
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(8), __webpack_require__(4), __webpack_require__(11), __webpack_require__(40), __webpack_require__(14)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _relatedUsersSupplier, _recentUsersSupplier, _serverUsersSupplier, _currentUserSupplier, _userCache) {
    'use strict';

    var RelatedUsersSupplier = _interopRequireDefault(_relatedUsersSupplier).default;

    var RecentUsersSupplier = _interopRequireDefault(_recentUsersSupplier).default;

    var ServerUsersSupplier = _interopRequireDefault(_serverUsersSupplier).default;

    var CurrentUserSupplier = _interopRequireDefault(_currentUserSupplier).default;

    var UserCache = _interopRequireDefault(_userCache).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _slicedToArray = function () {
        function sliceIterator(arr, i) {
            var _arr = [];
            var _n = true;
            var _d = false;
            var _e = undefined;

            try {
                for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                    _arr.push(_s.value);

                    if (i && _arr.length === i) break;
                }
            } catch (err) {
                _d = true;
                _e = err;
            } finally {
                try {
                    if (!_n && _i["return"]) _i["return"]();
                } finally {
                    if (_d) throw _e;
                }
            }

            return _arr;
        }

        return function (arr, i) {
            if (Array.isArray(arr)) {
                return arr;
            } else if (Symbol.iterator in Object(arr)) {
                return sliceIterator(arr, i);
            } else {
                throw new TypeError("Invalid attempt to destructure non-iterable instance");
            }
        };
    }();

    'use strict';

    /**
     *
     * @param {string}   query              User's query
     * @param {object}   editor             the currently-active editor
     */
    function search(query, editor) {
        var serverUsersPromise = ServerUsersSupplier.getUsers(query);
        var relatedUsersPromise = RelatedUsersSupplier.getUsers(editor);
        var recentUsersPromise = RecentUsersSupplier.getUsers();
        var currentUserPromise = CurrentUserSupplier.getCurrentUser();

        var fastPromises = [relatedUsersPromise, recentUsersPromise, currentUserPromise];

        return {
            client: Promise.all(fastPromises).then(function (_ref) {
                var _ref2 = _slicedToArray(_ref, 3),
                    relatedUsers = _ref2[0],
                    recentUsers = _ref2[1],
                    currentUser = _ref2[2];

                UserCache.addAll(relatedUsers);
                UserCache.addAll(recentUsers, true);
                if (currentUser) {
                    // May be undefined if anonymous.
                    UserCache.add(currentUser, true);
                }
            }),
            server: serverUsersPromise.then(function (serverUsers) {
                UserCache.addAll(serverUsers);
                RecentUsersSupplier.refresh(serverUsers);
            })
        };
    }

    function prefetchSuppliers(editor) {
        var waterTightValidationCheck = RecentUsersSupplier.getStaleUsers(RecentUsersSupplier.ValidationType.WATERTIGHT_VALIDATION);
        if (waterTightValidationCheck.length > 0) {
            //found some users whose stale for longer than 30 days. Must revalidate and delete if needed, before showing in UI.
            deleteStaleUsers(waterTightValidationCheck, RecentUsersSupplier.ValidationType.WATERTIGHT_VALIDATION);
        }
        // This will load related users into the cache in 'service/content-users/users-related-to-content'.
        RelatedUsersSupplier.getUsers(editor);
    }

    function deleteStaleUsers(usersToCheck, validationType) {
        ServerUsersSupplier._searchWithUsernames(usersToCheck).then(function (resultUsers) {
            RecentUsersSupplier.refresh(resultUsers);
            //if users are still stale after a refresh, it means they've not been returned by the server
            //time to delete 'em
            var usersToDelete = RecentUsersSupplier.getStaleUsers(validationType);
            usersToDelete.forEach(function (u) {
                return RecentUsersSupplier.remove(u);
            });
        });
    }

    // Reset any of the suppliers that hold state. Used in testing.
    function reset() {
        RelatedUsersSupplier.reset();
        ServerUsersSupplier.reset();
        RecentUsersSupplier._clear();
    }

    exports.default = {
        search: search,
        prefetchSuppliers: prefetchSuppliers,
        deleteStaleUsers: deleteStaleUsers,
        reset: reset
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(24), __webpack_require__(25)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _draftContentSupplier, _usersRelatedToContent) {
    'use strict';

    var getDraft = _interopRequireDefault(_draftContentSupplier).default;

    var UsersRelatedToContent = _interopRequireDefault(_usersRelatedToContent).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    /**
     Returns users related to the Content currently in the Editor, optionally filtered by a search string.
    
     You can test this logic in your browser console against a running instance by running something like :
    
     `require('confluence-mentions').userSuppliers.contentRelated.getUsers().then((result) => { window.relatedUsers = result; });`
    
     and then viewing the `window.relatedUsers` value.
     */
    function getUsers(editor) {
        var content = getDraft(editor);
        return UsersRelatedToContent.getUsers(content);
    }

    /*
     We assume that all useful information is returned in the getUsersRelatedTo call.
     */
    function isExhausted() {
        return true;
    }

    // Clears the related user cache, used in testing.
    function reset() {
        UsersRelatedToContent.reset();
    }

    exports.default = {
        getUsers: getUsers,
        isExhausted: isExhausted,
        reset: reset
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(10)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _i18n) {
    'use strict';

    var I18n = _interopRequireDefault(_i18n).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var newRole = function newRole(role) {
        return {
            role: role,
            i18n: I18n('user.role.' + role)
        };
    }; /**
        A simple User Role bean that can provide its i18n'd display name.
        */
    exports.default = {
        CREATOR: newRole('creator'),
        CONTRIBUTOR: newRole('contributor'),
        COMMENTER: newRole('commenter'),
        ANCESTOR_COMMENTER: newRole('ancestorCommenter') // never shown, but available
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(0)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _ajs) {
    'use strict';

    var AJS = _interopRequireDefault(_ajs).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var i18nMap = {
        'user.role.creator': AJS.I18n.getText('user.role.creator'),
        'user.role.contributor': AJS.I18n.getText('user.role.contributor'),
        'user.role.commenter': AJS.I18n.getText('user.role.commenter'),
        'user.supplier.recent': AJS.I18n.getText('user.supplier.recent')
    }; /**
        A way to get the i18nTransformer away from all-the-JS, this module allows clients to get I18n text using
        dynamic keys. Normally the i18nTransformer would fail to handle this and the developer would be forced to add
       
        AJS.I18n.getText('foo100')
       
        entries for each case. By extracting those invocations of AJS.I18n.getText to a single place, we can plan for a future
        where the transformer is not necessary and we can serve one set of JS resources for all locales.
       
        A future improvement might be to generate an i18n.js file directly from a plugin's
        i18n.properties file at build time.
        */

    exports.default = function (key) {
        // TODO - could interpolate args, etc. dT
        return i18nMap[key];
    };

    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(0), __webpack_require__(12), __webpack_require__(2), __webpack_require__(3), __webpack_require__(13), __webpack_require__(38), __webpack_require__(1), __webpack_require__(39)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _ajs, _legacy, _meta, _jquery, _userRanker, _serverUserCache, _userSupplierKeys, _luceneQuery) {
    'use strict';

    var AJS = _interopRequireDefault(_ajs).default;

    var Confluence = _interopRequireDefault(_legacy).default;

    var Meta = _interopRequireDefault(_meta).default;

    var $ = _interopRequireDefault(_jquery).default;

    var UserRanker = _interopRequireDefault(_userRanker).default;

    var Cache = _interopRequireDefault(_serverUserCache).default;

    var UserSupplier = _interopRequireDefault(_userSupplierKeys).default;

    var LuceneQuery = _interopRequireDefault(_luceneQuery).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    /**
     * Wait this long after REST call triggers before actually doing a search - results in fewer HTTP requests.
     */
    var DEBOUNCE_WAIT_MS = 250;

    // 1 char query is now supported by CQL.
    var MIN_CHARS_TO_SEARCH = 1;

    var limit = 100;
    var cache = Cache(limit);

    /**
     * The id of the last timeout to be created for a REST call. We cancel this timeout if
     * a scheduled call becomes stale.
     */
    var lastTimeout = void 0;

    /**
     Returns users from the backend via a CQL search.
     */
    function getUsers(query) {
        return new Promise(function (resolve, reject) {
            if (!query || query.length < MIN_CHARS_TO_SEARCH) {
                // No query - no server results.
                return resolve([]);
            }

            AJS.debug('server-users-supplier: Looking in cache for ' + query);
            var cacheEntry = cache.getClosest(query);
            if (cacheEntry) {
                AJS.debug('server-users-supplier: Found cache entry with query ' + cacheEntry.query);
                if (cacheEntry.query === query) {
                    // Exact match - just serve these results.
                    return resolve(cacheEntry.users);
                }

                // Not an exact match. Might need a REST call, but we can show results based on what we have cached.
                var rankedUsers = UserRanker(cacheEntry.users, query);
                cache.add(query, rankedUsers);

                // TODO Always resolve with what we have from the cache - this is information that can be put in front of
                // the user immediately. We then decide whether to follow up the local results with remote ones.
                // However, we need the ability to 'resolve' multiple times - to call the render once with the cached
                // results and again (if not debounced, stale, etc, etc) with the server results.
                if (cacheEntry.isExhausted) {
                    return resolve(rankedUsers);
                }

                // Else we might be searching for "John" but "Joh" already has >={limit} users.
                // We need to hit the server!
                // TODO - can we resolve multiple times?
            }

            var contextPath = Meta.get('context-path');
            var escapedQuery = LuceneQuery.escape(query);
            var queryParameters = {
                cql: 'user ~ "' + Confluence.unescapeEntities(escapedQuery) + '"',
                start: 0,
                limit: limit
            };
            var url = contextPath + '/rest/api/search';
            var success = function success(response) {
                var results = response.results;
                var users = results.map(function (result) {
                    var user = result.user;
                    user.supplier = UserSupplier.SERVER;
                    user.timestamp = result.timestamp;
                    AJS.debug('server-users-supplier: Adding user to cache: ' + user.username);
                    return user;
                });
                cache.add(query, users);
                resolve(users);
            };

            // Debounce
            clearTimeout(lastTimeout);
            lastTimeout = setTimeout(function () {
                $.getJSON(url, queryParameters, success).fail(reject);
            }, DEBOUNCE_WAIT_MS);
        });
    }

    /**
     * Forces a search for exact usernames. Use this to ensure the cached entries in
     * other suppliers are not stale.
     * @param usernames {Array} Array of username strings
     * @returns {Promise} a promise which will resolve with an array of user objects from the search that matched any of the input usernames.
     * @private
     */
    function _searchWithUsernames(usernames) {
        return new Promise(function (resolve, reject) {
            if (!usernames || usernames.length === 0) {
                return resolve([]);
            }
            var contextPath = Meta.get('context-path');
            var queryParameters = {
                cql: 'user in (' + usernames.map(function (u) {
                    return '"' + u + '"';
                }).join(',') + ')',
                start: 0,
                limit: usernames.length
            };
            AJS.debug('querying with \'' + queryParameters.cql + '\'');
            var url = contextPath + '/rest/api/search';
            var success = function success(response) {
                var results = response.results;
                var users = results.map(function (result) {
                    var user = result.user;
                    user.supplier = UserSupplier.SERVER;
                    user.timestamp = result.timestamp;
                    return user;
                });
                resolve(users);
            };

            // Debounce
            clearTimeout(lastTimeout);
            lastTimeout = setTimeout(function () {
                $.getJSON(url, queryParameters, success).fail(reject);
            }, DEBOUNCE_WAIT_MS);
        });
    }

    /**
     If a given search returns less that the specified limit, we say that that query is exhausted - adding more
     characters to the query will return a subset of users from the shorter query.
     */
    function isExhausted(query) {
        return true;
    }

    // Flushes the cache between tests.
    function reset() {
        cache.reset();
        AJS.debug('server-users-supplier: Cache reset');
    }

    exports.default = {
        getUsers: getUsers,
        _searchWithUsernames: _searchWithUsernames,
        isExhausted: isExhausted,
        reset: reset,
        DEBOUNCE_WAIT_MS: DEBOUNCE_WAIT_MS
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 12 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_12__;

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(12), __webpack_require__(37)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _legacy, _fuse) {
    'use strict';

    var Confluence = _interopRequireDefault(_legacy).default;

    var Fuse = _interopRequireDefault(_fuse).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    /**
     * Details for these options are available at http://fusejs.io/, but the basic gist is:
     *
     * - tokenize is required so that first and last names are searched from their first character
     * - matchAllTokens so that tokenize will match all words in the query
     * - threshold close to 0 to avoid unhelpful results, but this can be tweaked because...
     * - shouldSort will put the best matches at the top of the result array.
     * - location means that matching should start at the beginning of words, which is usually
     *     what name searches will want
     */
    /**
     * Ranks users, given a query.
     */
    var options = {
        includeMatches: true,
        includeScore: true,
        tokenize: true,
        matchAllTokens: true,
        threshold: 0.1,
        location: 0,
        distance: 0,
        maxPatternLength: 16,
        minMatchCharLength: 1,
        keys: [{
            name: 'displayName',
            weight: 0.7
        }, {
            name: 'username',
            weight: 0.3
        }]
    };

    exports.default = function (users, query) {
        if (!query) {
            return users;
        }

        // TODO Depending on what kind of setup is done in the Fuse constructor, we might want to
        // optimise by keeping an instance around that has all of the users currently-known to the
        // frontend: including cached Server search results.
        var fuse = new Fuse(users, options);
        var results = fuse.search(Confluence.unescapeEntities(query));
        return results.map(function (result) {
            var item = result.item;
            item.fuseMatches = result.matches;
            item.fuseScore = result.score;
            return item;
        });
    };

    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports) {
    /**
     * Where all the aggregation and caching happens
     */
    'use strict';

    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                arr2[i] = arr[i];
            }

            return arr2;
        } else {
            return Array.from(arr);
        }
    }

    var userCache = new Map();

    /**
     * Updates the incoming User object to split "displayName" into "firstName" and "lastNames" to aid Fuse matching.
     * @param user
     * @private
     */
    function _splitNames(user) {
        if (!user || !user.displayName) {
            return;
        }

        // We store first and last names separately to enable search weightings in Fuse.
        // JS String.split doesn't quite do what we need so we just use a substring.
        var firstSpace = user.displayName.indexOf(' ');
        if (firstSpace > 0) {
            user.firstName = user.displayName.substring(0, firstSpace);
            user.lastNames = user.displayName.substring(firstSpace + 1);
        } else {
            // A user display name in a language without spaces. Setting the firstName should work in most cases.
            user.firstName = user.displayName;
            user.lastNames = '';
        }
    }

    function _isStaleEntry(user) {
        if (!userCache.has(user.username)) {
            return true;
        }
        var entry = userCache.get(user.username);
        var timestamp = entry.timestamp || 0;
        return user.timestamp > timestamp;
    }

    exports.default = {
        /**
         * Will add the user to the user cache, if it's not already present.
         * @param {user}    user     A single user in API format
         * @param {boolean} force    if true, any cached user with the same username will be replaced with this user
         */
        add: function add(user) {
            var force = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

            // Existing cache entries may have a different Supplier for a given user - don't overwrite.
            if (user && user.hasOwnProperty('username') && (force === true || _isStaleEntry(user))) {
                _splitNames(user);
                userCache.set(user.username, user);
            }
        },

        /**
         * Will add all the supplied users by individually calling add
         * @param users an array of users
         */
        addAll: function addAll(users, force) {
            var _this = this;

            users.forEach(function (user) {
                _this.add(user, force);
            });
        },

        /**
         * @returns an array of all the users in the cache
         */
        getAll: function getAll() {
            return [].concat(_toConsumableArray(userCache.values()));
        },

        /**
         * Used for testing
         * @private
         */
        _get: function _get(username) {
            return userCache.get(username);
        },

        /**
         * Used for testing
         * @private
         */
        _clear: function _clear() {
            userCache.clear();
        }
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 15 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_15__;

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports) {
    "use strict";

    exports.default = {
        resultWithHtml: function resultWithHtml(html) {
            return {
                html: html
            };
        }
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(1)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _userSupplierKeys) {
    'use strict';

    var UserSupplier = _interopRequireDefault(_userSupplierKeys).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var suggestedUsers = [];

    /**
     * When searching for a user you're likely to want a user you've recently mentioned, even if other Fuse matches have
     * slightly better (lower) scores. For now we boost all recent matches, but we could adjust this to only the recent match
     * with the best score.
     *
     * Also, contributors should bubble to the top in the search results, at least until the search token is compelling enough
     * to switch.
     */
    function boostScores(users, next, context) {
        var query = context && context.query || '';
        if (query.indexOf(' ') > 0) {
            // Don't boost on supplier once multiple names are being added - the user seems to know who they're after so
            // let Fuse do its job.
            return next(users);
        }

        // The pipeline could be ensuring that users passed down the pipe are immutable, but for now just clone. fuseScore
        // should NOT be making its way into the user cache.
        var boostedUsers = users.map(function (userIn) {
            var user = Object.assign({}, userIn);
            if (suggestedUsers.includes(user.username)) {
                user.fuseScore /= 1000; // keep ordering for multiple matched suggestions
            } else if (typeof user.fuseScore === 'number') {
                switch (user.supplier) {
                    case UserSupplier.RECENT:
                        user.fuseScore /= 5;
                        break;
                    case UserSupplier.RELATED:
                        user.fuseScore /= 10;
                        break;
                }
            }
            return user;
        });
        return next(boostedUsers);
    }

    function setSuggestedUsers(users, next) {
        suggestedUsers = users.map(function (user) {
            return user.username;
        });
        return next(users);
    }

    function reset() {
        suggestedUsers = [];
    }

    exports.default = {
        boostScores: boostScores,
        setSuggestedUsers: setSuggestedUsers,
        reset: reset
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 18 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_18__;

/***/ }),
/* 19 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_19__;

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(21);


/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(22), __webpack_require__(8), __webpack_require__(4), __webpack_require__(11), __webpack_require__(19)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _editorPluginInit, _relatedUsersSupplier, _recentUsersSupplier, _serverUsersSupplier, _tinymce) {
    'use strict';

    var editorPluginInit = _interopRequireDefault(_editorPluginInit).default;

    var RelatedUsersSupplier = _interopRequireDefault(_relatedUsersSupplier).default;

    var RecentUsersSupplier = _interopRequireDefault(_recentUsersSupplier).default;

    var ServerUsersSupplier = _interopRequireDefault(_serverUsersSupplier).default;

    var tinymce = _interopRequireDefault(_tinymce).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function init(_jqueryEvent, context) {
        var editor = context && context.editor; // in case the initCallback internal code breaks API
        // This function is called from BootstrapManager.addOnInitCallback, tinymce.activeEditor already exists so it's too late to register a new plugin anyway.
        // We start up mentions right away.
        editorPluginInit(editor);
        // Do this just so it shows in plugin manager but it isn't used in tinymce.init settings.
        tinymce.PluginManager.add('insertmentions', function () {
            return {
                getMetadata: function getMetadata() {
                    return {
                        longname: 'Insert Mentions',
                        author: 'Atlassian',
                        authorurl: 'http://www.atlassian.com'
                    };
                }
            };
        });
    }

    /**
     * This is the main export from the Mentions module set.
     */
    exports.default = {
        init: init,
        userSuppliers: {
            // Users from localstorage
            recent: RecentUsersSupplier,
            // Users from the server
            serverSearch: ServerUsersSupplier,
            // Users from the front-end cache of the Content in the editor
            contentRelated: RelatedUsersSupplier
        }
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(0), __webpack_require__(3), __webpack_require__(23), __webpack_require__(6), __webpack_require__(18), __webpack_require__(52)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _ajs, _jquery, _autocompleteAdapter, _Mentions, _autocompleteManager, _autocompleteSettings) {
    'use strict';

    var AJS = _interopRequireDefault(_ajs).default;

    var $ = _interopRequireDefault(_jquery).default;

    var Adapter = _interopRequireDefault(_autocompleteAdapter).default;

    var Mentions = _interopRequireDefault(_Mentions).default;

    var AutocompleteManager = _interopRequireDefault(_autocompleteManager).default;

    var AutocompleteSettings = _interopRequireDefault(_autocompleteSettings).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    'use strict';

    function activateMentions() {
        AJS.EventQueue.push({ name: 'confluencementioninsert' });
        AutocompleteManager.shortcutFired('@', undefined, true);
    }

    function onClickEvent(event) {
        event.stopPropagation();
        event.preventDefault();
        AJS.Rte.getEditor().focus();
        activateMentions();
    }

    function editorPluginInit(editor) {
        AJS.EventQueue = AJS.EventQueue || [];
        Mentions.prefetchSuppliers(editor);

        AutocompleteSettings.Settings['@'] = {
            ch: '@',
            cache: true,
            endChars: [],
            dropDownClassName: 'autocomplete-mentions fabric',
            autocompleteClassNames: 'fabric',
            dropDownDelay: 0, // No delay needed because there is no AJAX request involved
            selectFirstItem: true,
            minLengthForGetData: 1,
            displayHandler: function displayHandler(user) {
                // Use Jquery to encode the user name
                return $('<div/>').text(user.name).html();
            },

            getHeaderText: function getHeaderText() {
                return null; // HACK this could be an option in core, the header is currently being hidden with CSS.
            },

            getAdditionalLinks: function getAdditionalLinks(autoCompleteControl, value, callback) {
                var additionalLinks = [];
                if (callback) callback(value, additionalLinks);
                return additionalLinks;
            },

            /**
             *
             * @param autoCompleteControl
             * @param value     The user's input
             * @param {function} renderResults  function to run with the resulting users (from input-driven-dropdown in
             *                                  Core)
             */
            getDataAndRunCallback: function getDataAndRunCallback(autoCompleteControl, value, renderResults) {
                Adapter.search(autoCompleteControl, value, renderResults, editor);
            },

            /**
             * Overrides the confluence/highlighter used to highlight query term matches in results
             */
            // For now, this override is ignored: we're getting better results from the default highlighter than with the
            // highlighting based on Fuse.js output.
            // Highlighter,

            update: Adapter.insert
        };

        $('#insertmention-button').on('click', onClickEvent);

        if (AJS.Rte.Placeholder && AJS.Rte.Placeholder.addPlaceholderType) {
            AJS.Rte.Placeholder.addPlaceholderType({
                type: 'mention',
                label: AJS.I18n.getText('property.panel.textplaceholder.display.mention'),
                tooltip: AJS.I18n.getText('property.panel.textplaceholder.display.mention.tooltip')
            });
        }
    }

    exports.default = editorPluginInit;
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(0), __webpack_require__(6), __webpack_require__(4), __webpack_require__(7), __webpack_require__(49), __webpack_require__(2), __webpack_require__(51), __webpack_require__(19)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _ajs, _Mentions, _recentUsersSupplier, _userSupplierManager, _mentionAnalytics, _meta, _linkObject, _tinymce) {
    'use strict';

    var AJS = _interopRequireDefault(_ajs).default;

    var Mentions = _interopRequireDefault(_Mentions).default;

    var RecentUsers = _interopRequireDefault(_recentUsersSupplier).default;

    var UserSupplierManager = _interopRequireDefault(_userSupplierManager).default;

    var MentionsAnalytics = _interopRequireDefault(_mentionAnalytics).default;

    var Meta = _interopRequireDefault(_meta).default;

    var Link = _interopRequireDefault(_linkObject).default;

    var tinymce = _interopRequireDefault(_tinymce).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    'use strict';

    var BASE_URL = Meta.get('base-url');

    function search(autoCompleteControl, value, renderResults, editor) {
        MentionsAnalytics.updateSession(autoCompleteControl);

        // The && guard here can be removed once the core tinymce3/plugins/autocomplete/autocomplete-manager.js code is released.
        // Hacky try catch to work around CONFSRVDEV-3101 and CONFSRVDEV-3138
        var selectedUser = void 0;
        try {
            var selectedItem = autoCompleteControl.getCurrentItem && autoCompleteControl.getCurrentItem();
            selectedUser = selectedItem && selectedItem.model;
        } catch (ignored) {
            console.log('Error retrieving currently-selected autoComplete item');
            console.log(ignored);
        }

        // renderResults likes a 2D array, and the query tokens in an array for highlighting
        var tokens = value && value.split(' ') || [];
        var render = function render(results, next, context) {
            return renderResults([results], value, null, tokens, context);
        };
        Mentions.searchAndRender(value, render, selectedUser, editor);
    }

    function insert(autoCompleteControl, user) {
        MentionsAnalytics.publishEventForSelection(user, autoCompleteControl.analytics);

        // Add this user to the cache - it will be retrieved with the recent-users-supplier module.
        RecentUsers.store(user);

        var earlyValidationCheck = RecentUsers.getStaleUsers(RecentUsers.ValidationType.EARLY_VALIDATION);
        if (earlyValidationCheck.length > 0) {
            //asynchronously attempt to update the recently mentioned cache to remove any stale users, after the UI insert is completed
            setTimeout(function () {
                return UserSupplierManager.deleteStaleUsers(earlyValidationCheck, RecentUsers.ValidationType.EARLY_VALIDATION);
            }, 0);
        }

        var link = {
            attrs: {
                href: user.link,
                userkey: user.model.userKey, // required to unmarshall ResourceIdentifier
                'data-base-url': BASE_URL,
                'data-linked-resource-type': 'userinfo',
                'data-linked-resource-default-alias': user.name
            },
            body: {
                html: AJS.escapeHtml(user.name)
            },
            classes: ['confluence-link']
        };
        Link.fromData(link).insert();
        tinymce.activeEditor.selection.setContent(' ');
    }

    // Called during testing
    function reset() {
        Mentions.reset();
    }

    exports.default = {
        search: search,
        insert: insert,
        reset: reset
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(2), __webpack_require__(3)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _meta, _jquery) {
    'use strict';

    var Meta = _interopRequireDefault(_meta).default;

    var $ = _interopRequireDefault(_jquery).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    // Adapted from confluence-quick-edit/src/main/resources/jscripts/handlers/comment.js.
    /**
     Supplies the Content API model object associated with the current draft in the editor.
    
     This is basically a shim for something that the Editor JS API *should* provide but currently doesn't
     */
    function getParameter(url, paramName) {
        if (!url) {
            return '';
        }
        var regex = new RegExp('[?&]' + paramName + '=(\\d+)');
        var match = url.match(regex);
        return match && match.length > 1 ? match[1] : '';
    }

    function safeGetDraft(editor) {
        if (!editor) {
            return null;
        }

        try {
            return getDraft(editor);
        } catch (e) {
            // This might happen if the Editor is being initialised in a context we don't yet support.
            console.error(e.message);
            return null;
        }
    }

    function getDraft(editor) {
        var id = Meta.get('page-id');

        var form = editor.formElement;
        var action = form.action || '';

        if (action.indexOf('/doaddcomment.action') > -1 || action.indexOf('/doeditcomment.action') > -1 || $(form).closest('.ic-sidebar').length) {
            var commentId = getParameter(action, 'commentId') || '0';

            var content = {
                id: commentId,
                type: 'comment',
                status: 'draft',
                container: {
                    id: id
                }
            };

            var parentCommentId = getParameter(action, 'parentId');
            if (parentCommentId) {
                content.ancestors = [{
                    id: parentCommentId
                }];
            }

            return content;
        }

        var previewContainer = $(form).closest('.cp-container');
        if (previewContainer.length) {
            // This is a comment for a Preview. Until we have a proper API, scrape the DOM and shed a single tear.
            var previewTitle = previewContainer.find('.cp-file-title').text().replace(/"/g, '\\"');
            // CONFSRVDEV-11704 because the previewer can be triggered from like million places, and because we suck
            // and don't set the alias for attachment titles consistently , which means we need to look for them with spaces
            // a well as with + for space
            var alternateTitle = escape(previewTitle.replace(/\s/g, '+'));
            var $element = $('body').find('*[data-linked-resource-default-alias="' + previewTitle + '"], *[data-linked-resource-default-alias="' + alternateTitle + '"]');
            if ($element.length) {
                var attachmentId = $element.attr('data-linked-resource-id');
                // Again, until Previews exposes an API, and the Editor consumes it in a way that THIS code can consume,
                // we're limited in how Smart the suggestions here can be. For now, editing an existing comment or replying
                // to a comment are treated the same as creating a new comment.
                return {
                    id: 0,
                    type: 'comment',
                    status: 'draft',
                    container: {
                        id: attachmentId
                    }
                };
            }
        }

        var newPage = Meta.get('new-page');

        var type = Meta.get('content-type');
        return {
            id: newPage ? '0' : id,
            type: type,
            status: 'draft'
        };
    }

    exports.default = safeGetDraft;
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(2), __webpack_require__(3), __webpack_require__(26), __webpack_require__(27), __webpack_require__(28)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _meta, _jquery, _aggregateUsers, _restParameters, _relatedUserTransformer) {
    'use strict';

    var Meta = _interopRequireDefault(_meta).default;

    var $ = _interopRequireDefault(_jquery).default;

    var aggregateUsers = _interopRequireDefault(_aggregateUsers).default;

    var getRestParameters = _interopRequireDefault(_restParameters).default;

    var flattenUsers = _interopRequireDefault(_relatedUserTransformer).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    'use strict'; /**
                   Supplies Users that are related to a piece of Content, calculated from server data via the Content API.
                   */


    var cache = {};

    var getUsers = function getUsers(contentStub) {
        var restParams = getRestParameters(contentStub);
        if (!restParams) {
            // Will be null for new pages and blogposts: don't make a REST call, don't cache
            return Promise.resolve([]);
        }

        if (restParams.contentId in cache) {
            return cache[restParams.contentId];
        }

        var promise = new Promise(function (resolve, reject) {
            var contextPath = Meta.get('context-path');
            var url = contextPath + '/rest/api/content/' + restParams.contentId;
            var queryParameters = {
                expand: restParams.expand
            };

            $.getJSON(url, queryParameters, function (content) {
                resolve(flattenUsers(aggregateUsers(content)));
            }).fail(reject);
        });

        cache[restParams.contentId] = promise;
        return promise;
    };

    // Used in testing.
    function reset() {
        cache = {};
    }

    exports.default = {
        getUsers: getUsers,
        reset: reset,
        _cache: cache //exposed for testing
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(9), __webpack_require__(1)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _userRole, _userSupplierKeys) {
    'use strict';

    var UserRole = _interopRequireDefault(_userRole).default;

    var UserSupplier = _interopRequireDefault(_userSupplierKeys).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    exports.default = function (content) {
        var relatedUsers = {};

        // Used to track users that have already been added to relatedUsers
        var usernames = new Set();

        // Skip anonymous users, disabled/deleted users, and users already in the result
        function shouldAddUser(user) {
            if (user.type === 'anonymous') {
                return false;
            }

            if (typeof user.status === 'undefined') {
                console.error('User status is undefined. Not adding to relatedUsers aggregate.');
                return false;
            }
            return user.status === 'current' && !usernames.has(user.username);
        }

        function addUser(user, role) {
            user.role = role;
            user.supplier = UserSupplier.RELATED;
            var roleKey = role.role;
            relatedUsers[roleKey] = relatedUsers[roleKey] || [];
            relatedUsers[roleKey].push(user);
            usernames.add(user.username);
        }

        function addUserWithRole(user, role) {
            if (shouldAddUser(user)) {
                addUser(user, role);
            }
        }

        var page = content.type === 'comment' ? content.container : content;

        // Only do this for content that has history
        if ('history' in page) {
            addUserWithRole(page.history.createdBy, UserRole.CREATOR);

            // Contributors are reversed to descending chronological order - users are more likely to mention contributors who
            // edited the content more recently.
            page.history.contributors.publishers.users.reverse().forEach(function (contributor) {
                addUserWithRole(contributor, UserRole.CONTRIBUTOR);
            });
        }

        if (content.type === 'comment' && content.ancestors) {
            // A new or existing comment that is a reply to another comment. We catch ancestor commenters before other
            // commenters because they are more likely to be mentioned.
            // Ancestor order is not reversed because they are already ordered youngest to oldest.
            content.ancestors.forEach(function (ancestorComment) {
                addUserWithRole(ancestorComment.version.by, UserRole.ANCESTOR_COMMENTER);
            });
        }

        if ('children' in page) {
            // Page commenters are also listed in reverse order
            page.children.comment.results.reverse().forEach(function (comment) {
                addUserWithRole(comment.version.by, UserRole.COMMENTER);
            });
        }

        return relatedUsers;
    };

    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports) {
    'use strict';

    /**
     Calculations the content id and expansions that should be used in the REST API call when building the
     list of users related to a piece of Content in the editor.
     */

    var PAGE_REST_EXPANSIONS = 'history.createdBy.status,history.contributors.publishers.users.status,children.comment.version.by.status';
    var COMMENT_REST_EXPANSIONS = 'ancestors.version.by.status,container.history.createdBy.status,container.history.contributors.publishers.users.status,container.children.comment.version.by.status';

    function restParams(id, expansions) {
        return {
            contentId: id,
            expand: expansions
        };
    }

    function isBlankId(val) {
        return !val || val === '0';
    }

    exports.default = function (contentStub) {
        if (!contentStub) {
            return null;
        }

        if (contentStub.type === 'page' || contentStub.type === 'blogpost') {
            var pageId = contentStub.id;
            if (isBlankId(pageId)) {
                // A new page/blogpost has no related users.
                return null;
            }
            // Editing an existing page or blogpost
            return restParams(pageId, PAGE_REST_EXPANSIONS);
        }

        if (contentStub.type === 'comment') {
            var commentId = contentStub.id;
            if (!isBlankId(commentId)) {
                // Editing an existing comment
                return restParams(commentId, COMMENT_REST_EXPANSIONS);
            }

            // A new comment: the stub will include the id of the comment it is replying to, unless this is a top-level
            // comment. NOTE: if we end up with access to a Draft comment, we should be able to use its id as the
            // content id, and not use the parent-comment or page ids here.
            var parentCommentId = contentStub.ancestors && contentStub.ancestors[0] && contentStub.ancestors[0].id;
            if (!isBlankId(parentCommentId)) {
                // A new reply
                return restParams(parentCommentId, COMMENT_REST_EXPANSIONS);
            }

            // A new top-level comment
            var _pageId = contentStub.container.id;
            return restParams(_pageId, PAGE_REST_EXPANSIONS);
        }
    };

    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(9)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _userRole) {
    'use strict';

    var UserRole = _interopRequireDefault(_userRole).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    'use strict';

    /**
     * Converts the map of users by role into a list of users.
     */

    exports.default = function (usersMap) {
        var transformedList = [];

        function addUsersWithRoleToList(userRole) {
            var users = usersMap[userRole.role];
            if (users && users.length) {
                transformedList = transformedList.concat(users);
            }
        }

        addUsersWithRoleToList(UserRole.CREATOR);
        addUsersWithRoleToList(UserRole.CONTRIBUTOR);
        addUsersWithRoleToList(UserRole.COMMENTER);
        addUsersWithRoleToList(UserRole.ANCESTOR_COMMENTER);

        return transformedList;
    };

    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

module.exports = LRUCache

// This will be a proper iterable 'Map' in engines that support it,
// or a fakey-fake PseudoMap in older versions.
var Map = __webpack_require__(30)
var util = __webpack_require__(32)

// A linked list to keep track of recently-used-ness
var Yallist = __webpack_require__(35)

// use symbols if possible, otherwise just _props
var hasSymbol = typeof Symbol === 'function' && process.env._nodeLRUCacheForceNoSymbol !== '1'
var makeSymbol
if (hasSymbol) {
  makeSymbol = function (key) {
    return Symbol(key)
  }
} else {
  makeSymbol = function (key) {
    return '_' + key
  }
}

var MAX = makeSymbol('max')
var LENGTH = makeSymbol('length')
var LENGTH_CALCULATOR = makeSymbol('lengthCalculator')
var ALLOW_STALE = makeSymbol('allowStale')
var MAX_AGE = makeSymbol('maxAge')
var DISPOSE = makeSymbol('dispose')
var NO_DISPOSE_ON_SET = makeSymbol('noDisposeOnSet')
var LRU_LIST = makeSymbol('lruList')
var CACHE = makeSymbol('cache')

function naiveLength () { return 1 }

// lruList is a yallist where the head is the youngest
// item, and the tail is the oldest.  the list contains the Hit
// objects as the entries.
// Each Hit object has a reference to its Yallist.Node.  This
// never changes.
//
// cache is a Map (or PseudoMap) that matches the keys to
// the Yallist.Node object.
function LRUCache (options) {
  if (!(this instanceof LRUCache)) {
    return new LRUCache(options)
  }

  if (typeof options === 'number') {
    options = { max: options }
  }

  if (!options) {
    options = {}
  }

  var max = this[MAX] = options.max
  // Kind of weird to have a default max of Infinity, but oh well.
  if (!max ||
      !(typeof max === 'number') ||
      max <= 0) {
    this[MAX] = Infinity
  }

  var lc = options.length || naiveLength
  if (typeof lc !== 'function') {
    lc = naiveLength
  }
  this[LENGTH_CALCULATOR] = lc

  this[ALLOW_STALE] = options.stale || false
  this[MAX_AGE] = options.maxAge || 0
  this[DISPOSE] = options.dispose
  this[NO_DISPOSE_ON_SET] = options.noDisposeOnSet || false
  this.reset()
}

// resize the cache when the max changes.
Object.defineProperty(LRUCache.prototype, 'max', {
  set: function (mL) {
    if (!mL || !(typeof mL === 'number') || mL <= 0) {
      mL = Infinity
    }
    this[MAX] = mL
    trim(this)
  },
  get: function () {
    return this[MAX]
  },
  enumerable: true
})

Object.defineProperty(LRUCache.prototype, 'allowStale', {
  set: function (allowStale) {
    this[ALLOW_STALE] = !!allowStale
  },
  get: function () {
    return this[ALLOW_STALE]
  },
  enumerable: true
})

Object.defineProperty(LRUCache.prototype, 'maxAge', {
  set: function (mA) {
    if (!mA || !(typeof mA === 'number') || mA < 0) {
      mA = 0
    }
    this[MAX_AGE] = mA
    trim(this)
  },
  get: function () {
    return this[MAX_AGE]
  },
  enumerable: true
})

// resize the cache when the lengthCalculator changes.
Object.defineProperty(LRUCache.prototype, 'lengthCalculator', {
  set: function (lC) {
    if (typeof lC !== 'function') {
      lC = naiveLength
    }
    if (lC !== this[LENGTH_CALCULATOR]) {
      this[LENGTH_CALCULATOR] = lC
      this[LENGTH] = 0
      this[LRU_LIST].forEach(function (hit) {
        hit.length = this[LENGTH_CALCULATOR](hit.value, hit.key)
        this[LENGTH] += hit.length
      }, this)
    }
    trim(this)
  },
  get: function () { return this[LENGTH_CALCULATOR] },
  enumerable: true
})

Object.defineProperty(LRUCache.prototype, 'length', {
  get: function () { return this[LENGTH] },
  enumerable: true
})

Object.defineProperty(LRUCache.prototype, 'itemCount', {
  get: function () { return this[LRU_LIST].length },
  enumerable: true
})

LRUCache.prototype.rforEach = function (fn, thisp) {
  thisp = thisp || this
  for (var walker = this[LRU_LIST].tail; walker !== null;) {
    var prev = walker.prev
    forEachStep(this, fn, walker, thisp)
    walker = prev
  }
}

function forEachStep (self, fn, node, thisp) {
  var hit = node.value
  if (isStale(self, hit)) {
    del(self, node)
    if (!self[ALLOW_STALE]) {
      hit = undefined
    }
  }
  if (hit) {
    fn.call(thisp, hit.value, hit.key, self)
  }
}

LRUCache.prototype.forEach = function (fn, thisp) {
  thisp = thisp || this
  for (var walker = this[LRU_LIST].head; walker !== null;) {
    var next = walker.next
    forEachStep(this, fn, walker, thisp)
    walker = next
  }
}

LRUCache.prototype.keys = function () {
  return this[LRU_LIST].toArray().map(function (k) {
    return k.key
  }, this)
}

LRUCache.prototype.values = function () {
  return this[LRU_LIST].toArray().map(function (k) {
    return k.value
  }, this)
}

LRUCache.prototype.reset = function () {
  if (this[DISPOSE] &&
      this[LRU_LIST] &&
      this[LRU_LIST].length) {
    this[LRU_LIST].forEach(function (hit) {
      this[DISPOSE](hit.key, hit.value)
    }, this)
  }

  this[CACHE] = new Map() // hash of items by key
  this[LRU_LIST] = new Yallist() // list of items in order of use recency
  this[LENGTH] = 0 // length of items in the list
}

LRUCache.prototype.dump = function () {
  return this[LRU_LIST].map(function (hit) {
    if (!isStale(this, hit)) {
      return {
        k: hit.key,
        v: hit.value,
        e: hit.now + (hit.maxAge || 0)
      }
    }
  }, this).toArray().filter(function (h) {
    return h
  })
}

LRUCache.prototype.dumpLru = function () {
  return this[LRU_LIST]
}

/* istanbul ignore next */
LRUCache.prototype.inspect = function (n, opts) {
  var str = 'LRUCache {'
  var extras = false

  var as = this[ALLOW_STALE]
  if (as) {
    str += '\n  allowStale: true'
    extras = true
  }

  var max = this[MAX]
  if (max && max !== Infinity) {
    if (extras) {
      str += ','
    }
    str += '\n  max: ' + util.inspect(max, opts)
    extras = true
  }

  var maxAge = this[MAX_AGE]
  if (maxAge) {
    if (extras) {
      str += ','
    }
    str += '\n  maxAge: ' + util.inspect(maxAge, opts)
    extras = true
  }

  var lc = this[LENGTH_CALCULATOR]
  if (lc && lc !== naiveLength) {
    if (extras) {
      str += ','
    }
    str += '\n  length: ' + util.inspect(this[LENGTH], opts)
    extras = true
  }

  var didFirst = false
  this[LRU_LIST].forEach(function (item) {
    if (didFirst) {
      str += ',\n  '
    } else {
      if (extras) {
        str += ',\n'
      }
      didFirst = true
      str += '\n  '
    }
    var key = util.inspect(item.key).split('\n').join('\n  ')
    var val = { value: item.value }
    if (item.maxAge !== maxAge) {
      val.maxAge = item.maxAge
    }
    if (lc !== naiveLength) {
      val.length = item.length
    }
    if (isStale(this, item)) {
      val.stale = true
    }

    val = util.inspect(val, opts).split('\n').join('\n  ')
    str += key + ' => ' + val
  })

  if (didFirst || extras) {
    str += '\n'
  }
  str += '}'

  return str
}

LRUCache.prototype.set = function (key, value, maxAge) {
  maxAge = maxAge || this[MAX_AGE]

  var now = maxAge ? Date.now() : 0
  var len = this[LENGTH_CALCULATOR](value, key)

  if (this[CACHE].has(key)) {
    if (len > this[MAX]) {
      del(this, this[CACHE].get(key))
      return false
    }

    var node = this[CACHE].get(key)
    var item = node.value

    // dispose of the old one before overwriting
    // split out into 2 ifs for better coverage tracking
    if (this[DISPOSE]) {
      if (!this[NO_DISPOSE_ON_SET]) {
        this[DISPOSE](key, item.value)
      }
    }

    item.now = now
    item.maxAge = maxAge
    item.value = value
    this[LENGTH] += len - item.length
    item.length = len
    this.get(key)
    trim(this)
    return true
  }

  var hit = new Entry(key, value, len, now, maxAge)

  // oversized objects fall out of cache automatically.
  if (hit.length > this[MAX]) {
    if (this[DISPOSE]) {
      this[DISPOSE](key, value)
    }
    return false
  }

  this[LENGTH] += hit.length
  this[LRU_LIST].unshift(hit)
  this[CACHE].set(key, this[LRU_LIST].head)
  trim(this)
  return true
}

LRUCache.prototype.has = function (key) {
  if (!this[CACHE].has(key)) return false
  var hit = this[CACHE].get(key).value
  if (isStale(this, hit)) {
    return false
  }
  return true
}

LRUCache.prototype.get = function (key) {
  return get(this, key, true)
}

LRUCache.prototype.peek = function (key) {
  return get(this, key, false)
}

LRUCache.prototype.pop = function () {
  var node = this[LRU_LIST].tail
  if (!node) return null
  del(this, node)
  return node.value
}

LRUCache.prototype.del = function (key) {
  del(this, this[CACHE].get(key))
}

LRUCache.prototype.load = function (arr) {
  // reset the cache
  this.reset()

  var now = Date.now()
  // A previous serialized cache has the most recent items first
  for (var l = arr.length - 1; l >= 0; l--) {
    var hit = arr[l]
    var expiresAt = hit.e || 0
    if (expiresAt === 0) {
      // the item was created without expiration in a non aged cache
      this.set(hit.k, hit.v)
    } else {
      var maxAge = expiresAt - now
      // dont add already expired items
      if (maxAge > 0) {
        this.set(hit.k, hit.v, maxAge)
      }
    }
  }
}

LRUCache.prototype.prune = function () {
  var self = this
  this[CACHE].forEach(function (value, key) {
    get(self, key, false)
  })
}

function get (self, key, doUse) {
  var node = self[CACHE].get(key)
  if (node) {
    var hit = node.value
    if (isStale(self, hit)) {
      del(self, node)
      if (!self[ALLOW_STALE]) hit = undefined
    } else {
      if (doUse) {
        self[LRU_LIST].unshiftNode(node)
      }
    }
    if (hit) hit = hit.value
  }
  return hit
}

function isStale (self, hit) {
  if (!hit || (!hit.maxAge && !self[MAX_AGE])) {
    return false
  }
  var stale = false
  var diff = Date.now() - hit.now
  if (hit.maxAge) {
    stale = diff > hit.maxAge
  } else {
    stale = self[MAX_AGE] && (diff > self[MAX_AGE])
  }
  return stale
}

function trim (self) {
  if (self[LENGTH] > self[MAX]) {
    for (var walker = self[LRU_LIST].tail;
      self[LENGTH] > self[MAX] && walker !== null;) {
      // We know that we're about to delete this one, and also
      // what the next least recently used key will be, so just
      // go ahead and set it now.
      var prev = walker.prev
      del(self, walker)
      walker = prev
    }
  }
}

function del (self, node) {
  if (node) {
    var hit = node.value
    if (self[DISPOSE]) {
      self[DISPOSE](hit.key, hit.value)
    }
    self[LENGTH] -= hit.length
    self[CACHE].delete(hit.key)
    self[LRU_LIST].removeNode(node)
  }
}

// classy, since V8 prefers predictable objects.
function Entry (key, value, length, now, maxAge) {
  this.key = key
  this.value = value
  this.length = length
  this.now = now
  this.maxAge = maxAge || 0
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(5)))

/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(process) {if (process.env.npm_package_name === 'pseudomap' &&
    process.env.npm_lifecycle_script === 'test')
  process.env.TEST_PSEUDOMAP = 'true'

if (typeof Map === 'function' && !process.env.TEST_PSEUDOMAP) {
  module.exports = Map
} else {
  module.exports = __webpack_require__(31)
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(5)))

/***/ }),
/* 31 */
/***/ (function(module, exports) {

var hasOwnProperty = Object.prototype.hasOwnProperty

module.exports = PseudoMap

function PseudoMap (set) {
  if (!(this instanceof PseudoMap)) // whyyyyyyy
    throw new TypeError("Constructor PseudoMap requires 'new'")

  this.clear()

  if (set) {
    if ((set instanceof PseudoMap) ||
        (typeof Map === 'function' && set instanceof Map))
      set.forEach(function (value, key) {
        this.set(key, value)
      }, this)
    else if (Array.isArray(set))
      set.forEach(function (kv) {
        this.set(kv[0], kv[1])
      }, this)
    else
      throw new TypeError('invalid argument')
  }
}

PseudoMap.prototype.forEach = function (fn, thisp) {
  thisp = thisp || this
  Object.keys(this._data).forEach(function (k) {
    if (k !== 'size')
      fn.call(thisp, this._data[k].value, this._data[k].key)
  }, this)
}

PseudoMap.prototype.has = function (k) {
  return !!find(this._data, k)
}

PseudoMap.prototype.get = function (k) {
  var res = find(this._data, k)
  return res && res.value
}

PseudoMap.prototype.set = function (k, v) {
  set(this._data, k, v)
}

PseudoMap.prototype.delete = function (k) {
  var res = find(this._data, k)
  if (res) {
    delete this._data[res._index]
    this._data.size--
  }
}

PseudoMap.prototype.clear = function () {
  var data = Object.create(null)
  data.size = 0

  Object.defineProperty(this, '_data', {
    value: data,
    enumerable: false,
    configurable: true,
    writable: false
  })
}

Object.defineProperty(PseudoMap.prototype, 'size', {
  get: function () {
    return this._data.size
  },
  set: function (n) {},
  enumerable: true,
  configurable: true
})

PseudoMap.prototype.values =
PseudoMap.prototype.keys =
PseudoMap.prototype.entries = function () {
  throw new Error('iterators are not implemented in this version')
}

// Either identical, or both NaN
function same (a, b) {
  return a === b || a !== a && b !== b
}

function Entry (k, v, i) {
  this.key = k
  this.value = v
  this._index = i
}

function find (data, k) {
  for (var i = 0, s = '_' + k, key = s;
       hasOwnProperty.call(data, key);
       key = s + i++) {
    if (same(data[key].key, k))
      return data[key]
  }
}

function set (data, k, v) {
  for (var i = 0, s = '_' + k, key = s;
       hasOwnProperty.call(data, key);
       key = s + i++) {
    if (same(data[key].key, k)) {
      data[key].value = v
      return
    }
  }
  data.size++
  data[key] = new Entry(k, v, key)
}


/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(process) {// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

var getOwnPropertyDescriptors = Object.getOwnPropertyDescriptors ||
  function getOwnPropertyDescriptors(obj) {
    var keys = Object.keys(obj);
    var descriptors = {};
    for (var i = 0; i < keys.length; i++) {
      descriptors[keys[i]] = Object.getOwnPropertyDescriptor(obj, keys[i]);
    }
    return descriptors;
  };

var formatRegExp = /%[sdj%]/g;
exports.format = function(f) {
  if (!isString(f)) {
    var objects = [];
    for (var i = 0; i < arguments.length; i++) {
      objects.push(inspect(arguments[i]));
    }
    return objects.join(' ');
  }

  var i = 1;
  var args = arguments;
  var len = args.length;
  var str = String(f).replace(formatRegExp, function(x) {
    if (x === '%%') return '%';
    if (i >= len) return x;
    switch (x) {
      case '%s': return String(args[i++]);
      case '%d': return Number(args[i++]);
      case '%j':
        try {
          return JSON.stringify(args[i++]);
        } catch (_) {
          return '[Circular]';
        }
      default:
        return x;
    }
  });
  for (var x = args[i]; i < len; x = args[++i]) {
    if (isNull(x) || !isObject(x)) {
      str += ' ' + x;
    } else {
      str += ' ' + inspect(x);
    }
  }
  return str;
};


// Mark that a method should not be used.
// Returns a modified function which warns once by default.
// If --no-deprecation is set, then it is a no-op.
exports.deprecate = function(fn, msg) {
  if (typeof process !== 'undefined' && process.noDeprecation === true) {
    return fn;
  }

  // Allow for deprecating things in the process of starting up.
  if (typeof process === 'undefined') {
    return function() {
      return exports.deprecate(fn, msg).apply(this, arguments);
    };
  }

  var warned = false;
  function deprecated() {
    if (!warned) {
      if (process.throwDeprecation) {
        throw new Error(msg);
      } else if (process.traceDeprecation) {
        console.trace(msg);
      } else {
        console.error(msg);
      }
      warned = true;
    }
    return fn.apply(this, arguments);
  }

  return deprecated;
};


var debugs = {};
var debugEnviron;
exports.debuglog = function(set) {
  if (isUndefined(debugEnviron))
    debugEnviron = process.env.NODE_DEBUG || '';
  set = set.toUpperCase();
  if (!debugs[set]) {
    if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
      var pid = process.pid;
      debugs[set] = function() {
        var msg = exports.format.apply(exports, arguments);
        console.error('%s %d: %s', set, pid, msg);
      };
    } else {
      debugs[set] = function() {};
    }
  }
  return debugs[set];
};


/**
 * Echos the value of a value. Trys to print the value out
 * in the best way possible given the different types.
 *
 * @param {Object} obj The object to print out.
 * @param {Object} opts Optional options object that alters the output.
 */
/* legacy: obj, showHidden, depth, colors*/
function inspect(obj, opts) {
  // default options
  var ctx = {
    seen: [],
    stylize: stylizeNoColor
  };
  // legacy...
  if (arguments.length >= 3) ctx.depth = arguments[2];
  if (arguments.length >= 4) ctx.colors = arguments[3];
  if (isBoolean(opts)) {
    // legacy...
    ctx.showHidden = opts;
  } else if (opts) {
    // got an "options" object
    exports._extend(ctx, opts);
  }
  // set default options
  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
  if (isUndefined(ctx.depth)) ctx.depth = 2;
  if (isUndefined(ctx.colors)) ctx.colors = false;
  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
  if (ctx.colors) ctx.stylize = stylizeWithColor;
  return formatValue(ctx, obj, ctx.depth);
}
exports.inspect = inspect;


// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
inspect.colors = {
  'bold' : [1, 22],
  'italic' : [3, 23],
  'underline' : [4, 24],
  'inverse' : [7, 27],
  'white' : [37, 39],
  'grey' : [90, 39],
  'black' : [30, 39],
  'blue' : [34, 39],
  'cyan' : [36, 39],
  'green' : [32, 39],
  'magenta' : [35, 39],
  'red' : [31, 39],
  'yellow' : [33, 39]
};

// Don't use 'blue' not visible on cmd.exe
inspect.styles = {
  'special': 'cyan',
  'number': 'yellow',
  'boolean': 'yellow',
  'undefined': 'grey',
  'null': 'bold',
  'string': 'green',
  'date': 'magenta',
  // "name": intentionally not styling
  'regexp': 'red'
};


function stylizeWithColor(str, styleType) {
  var style = inspect.styles[styleType];

  if (style) {
    return '\u001b[' + inspect.colors[style][0] + 'm' + str +
           '\u001b[' + inspect.colors[style][1] + 'm';
  } else {
    return str;
  }
}


function stylizeNoColor(str, styleType) {
  return str;
}


function arrayToHash(array) {
  var hash = {};

  array.forEach(function(val, idx) {
    hash[val] = true;
  });

  return hash;
}


function formatValue(ctx, value, recurseTimes) {
  // Provide a hook for user-specified inspect functions.
  // Check that value is an object with an inspect function on it
  if (ctx.customInspect &&
      value &&
      isFunction(value.inspect) &&
      // Filter out the util module, it's inspect function is special
      value.inspect !== exports.inspect &&
      // Also filter out any prototype objects using the circular check.
      !(value.constructor && value.constructor.prototype === value)) {
    var ret = value.inspect(recurseTimes, ctx);
    if (!isString(ret)) {
      ret = formatValue(ctx, ret, recurseTimes);
    }
    return ret;
  }

  // Primitive types cannot have properties
  var primitive = formatPrimitive(ctx, value);
  if (primitive) {
    return primitive;
  }

  // Look up the keys of the object.
  var keys = Object.keys(value);
  var visibleKeys = arrayToHash(keys);

  if (ctx.showHidden) {
    keys = Object.getOwnPropertyNames(value);
  }

  // IE doesn't make error fields non-enumerable
  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
  if (isError(value)
      && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
    return formatError(value);
  }

  // Some type of object without properties can be shortcutted.
  if (keys.length === 0) {
    if (isFunction(value)) {
      var name = value.name ? ': ' + value.name : '';
      return ctx.stylize('[Function' + name + ']', 'special');
    }
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    }
    if (isDate(value)) {
      return ctx.stylize(Date.prototype.toString.call(value), 'date');
    }
    if (isError(value)) {
      return formatError(value);
    }
  }

  var base = '', array = false, braces = ['{', '}'];

  // Make Array say that they are Array
  if (isArray(value)) {
    array = true;
    braces = ['[', ']'];
  }

  // Make functions say that they are functions
  if (isFunction(value)) {
    var n = value.name ? ': ' + value.name : '';
    base = ' [Function' + n + ']';
  }

  // Make RegExps say that they are RegExps
  if (isRegExp(value)) {
    base = ' ' + RegExp.prototype.toString.call(value);
  }

  // Make dates with properties first say the date
  if (isDate(value)) {
    base = ' ' + Date.prototype.toUTCString.call(value);
  }

  // Make error with message first say the error
  if (isError(value)) {
    base = ' ' + formatError(value);
  }

  if (keys.length === 0 && (!array || value.length == 0)) {
    return braces[0] + base + braces[1];
  }

  if (recurseTimes < 0) {
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    } else {
      return ctx.stylize('[Object]', 'special');
    }
  }

  ctx.seen.push(value);

  var output;
  if (array) {
    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
  } else {
    output = keys.map(function(key) {
      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
    });
  }

  ctx.seen.pop();

  return reduceToSingleString(output, base, braces);
}


function formatPrimitive(ctx, value) {
  if (isUndefined(value))
    return ctx.stylize('undefined', 'undefined');
  if (isString(value)) {
    var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
                                             .replace(/'/g, "\\'")
                                             .replace(/\\"/g, '"') + '\'';
    return ctx.stylize(simple, 'string');
  }
  if (isNumber(value))
    return ctx.stylize('' + value, 'number');
  if (isBoolean(value))
    return ctx.stylize('' + value, 'boolean');
  // For some reason typeof null is "object", so special case here.
  if (isNull(value))
    return ctx.stylize('null', 'null');
}


function formatError(value) {
  return '[' + Error.prototype.toString.call(value) + ']';
}


function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
  var output = [];
  for (var i = 0, l = value.length; i < l; ++i) {
    if (hasOwnProperty(value, String(i))) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          String(i), true));
    } else {
      output.push('');
    }
  }
  keys.forEach(function(key) {
    if (!key.match(/^\d+$/)) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          key, true));
    }
  });
  return output;
}


function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
  var name, str, desc;
  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
  if (desc.get) {
    if (desc.set) {
      str = ctx.stylize('[Getter/Setter]', 'special');
    } else {
      str = ctx.stylize('[Getter]', 'special');
    }
  } else {
    if (desc.set) {
      str = ctx.stylize('[Setter]', 'special');
    }
  }
  if (!hasOwnProperty(visibleKeys, key)) {
    name = '[' + key + ']';
  }
  if (!str) {
    if (ctx.seen.indexOf(desc.value) < 0) {
      if (isNull(recurseTimes)) {
        str = formatValue(ctx, desc.value, null);
      } else {
        str = formatValue(ctx, desc.value, recurseTimes - 1);
      }
      if (str.indexOf('\n') > -1) {
        if (array) {
          str = str.split('\n').map(function(line) {
            return '  ' + line;
          }).join('\n').substr(2);
        } else {
          str = '\n' + str.split('\n').map(function(line) {
            return '   ' + line;
          }).join('\n');
        }
      }
    } else {
      str = ctx.stylize('[Circular]', 'special');
    }
  }
  if (isUndefined(name)) {
    if (array && key.match(/^\d+$/)) {
      return str;
    }
    name = JSON.stringify('' + key);
    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
      name = name.substr(1, name.length - 2);
      name = ctx.stylize(name, 'name');
    } else {
      name = name.replace(/'/g, "\\'")
                 .replace(/\\"/g, '"')
                 .replace(/(^"|"$)/g, "'");
      name = ctx.stylize(name, 'string');
    }
  }

  return name + ': ' + str;
}


function reduceToSingleString(output, base, braces) {
  var numLinesEst = 0;
  var length = output.reduce(function(prev, cur) {
    numLinesEst++;
    if (cur.indexOf('\n') >= 0) numLinesEst++;
    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
  }, 0);

  if (length > 60) {
    return braces[0] +
           (base === '' ? '' : base + '\n ') +
           ' ' +
           output.join(',\n  ') +
           ' ' +
           braces[1];
  }

  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
}


// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.
function isArray(ar) {
  return Array.isArray(ar);
}
exports.isArray = isArray;

function isBoolean(arg) {
  return typeof arg === 'boolean';
}
exports.isBoolean = isBoolean;

function isNull(arg) {
  return arg === null;
}
exports.isNull = isNull;

function isNullOrUndefined(arg) {
  return arg == null;
}
exports.isNullOrUndefined = isNullOrUndefined;

function isNumber(arg) {
  return typeof arg === 'number';
}
exports.isNumber = isNumber;

function isString(arg) {
  return typeof arg === 'string';
}
exports.isString = isString;

function isSymbol(arg) {
  return typeof arg === 'symbol';
}
exports.isSymbol = isSymbol;

function isUndefined(arg) {
  return arg === void 0;
}
exports.isUndefined = isUndefined;

function isRegExp(re) {
  return isObject(re) && objectToString(re) === '[object RegExp]';
}
exports.isRegExp = isRegExp;

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}
exports.isObject = isObject;

function isDate(d) {
  return isObject(d) && objectToString(d) === '[object Date]';
}
exports.isDate = isDate;

function isError(e) {
  return isObject(e) &&
      (objectToString(e) === '[object Error]' || e instanceof Error);
}
exports.isError = isError;

function isFunction(arg) {
  return typeof arg === 'function';
}
exports.isFunction = isFunction;

function isPrimitive(arg) {
  return arg === null ||
         typeof arg === 'boolean' ||
         typeof arg === 'number' ||
         typeof arg === 'string' ||
         typeof arg === 'symbol' ||  // ES6 symbol
         typeof arg === 'undefined';
}
exports.isPrimitive = isPrimitive;

exports.isBuffer = __webpack_require__(33);

function objectToString(o) {
  return Object.prototype.toString.call(o);
}


function pad(n) {
  return n < 10 ? '0' + n.toString(10) : n.toString(10);
}


var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
              'Oct', 'Nov', 'Dec'];

// 26 Feb 16:19:34
function timestamp() {
  var d = new Date();
  var time = [pad(d.getHours()),
              pad(d.getMinutes()),
              pad(d.getSeconds())].join(':');
  return [d.getDate(), months[d.getMonth()], time].join(' ');
}


// log is just a thin wrapper to console.log that prepends a timestamp
exports.log = function() {
  console.log('%s - %s', timestamp(), exports.format.apply(exports, arguments));
};


/**
 * Inherit the prototype methods from one constructor into another.
 *
 * The Function.prototype.inherits from lang.js rewritten as a standalone
 * function (not on Function.prototype). NOTE: If this file is to be loaded
 * during bootstrapping this function needs to be rewritten using some native
 * functions as prototype setup using normal JavaScript does not work as
 * expected during bootstrapping (see mirror.js in r114903).
 *
 * @param {function} ctor Constructor function which needs to inherit the
 *     prototype.
 * @param {function} superCtor Constructor function to inherit prototype from.
 */
exports.inherits = __webpack_require__(34);

exports._extend = function(origin, add) {
  // Don't do anything if add isn't an object
  if (!add || !isObject(add)) return origin;

  var keys = Object.keys(add);
  var i = keys.length;
  while (i--) {
    origin[keys[i]] = add[keys[i]];
  }
  return origin;
};

function hasOwnProperty(obj, prop) {
  return Object.prototype.hasOwnProperty.call(obj, prop);
}

var kCustomPromisifiedSymbol = typeof Symbol !== 'undefined' ? Symbol('util.promisify.custom') : undefined;

exports.promisify = function promisify(original) {
  if (typeof original !== 'function')
    throw new TypeError('The "original" argument must be of type Function');

  if (kCustomPromisifiedSymbol && original[kCustomPromisifiedSymbol]) {
    var fn = original[kCustomPromisifiedSymbol];
    if (typeof fn !== 'function') {
      throw new TypeError('The "util.promisify.custom" argument must be of type Function');
    }
    Object.defineProperty(fn, kCustomPromisifiedSymbol, {
      value: fn, enumerable: false, writable: false, configurable: true
    });
    return fn;
  }

  function fn() {
    var promiseResolve, promiseReject;
    var promise = new Promise(function (resolve, reject) {
      promiseResolve = resolve;
      promiseReject = reject;
    });

    var args = [];
    for (var i = 0; i < arguments.length; i++) {
      args.push(arguments[i]);
    }
    args.push(function (err, value) {
      if (err) {
        promiseReject(err);
      } else {
        promiseResolve(value);
      }
    });

    try {
      original.apply(this, args);
    } catch (err) {
      promiseReject(err);
    }

    return promise;
  }

  Object.setPrototypeOf(fn, Object.getPrototypeOf(original));

  if (kCustomPromisifiedSymbol) Object.defineProperty(fn, kCustomPromisifiedSymbol, {
    value: fn, enumerable: false, writable: false, configurable: true
  });
  return Object.defineProperties(
    fn,
    getOwnPropertyDescriptors(original)
  );
}

exports.promisify.custom = kCustomPromisifiedSymbol

function callbackifyOnRejected(reason, cb) {
  // `!reason` guard inspired by bluebird (Ref: https://goo.gl/t5IS6M).
  // Because `null` is a special error value in callbacks which means "no error
  // occurred", we error-wrap so the callback consumer can distinguish between
  // "the promise rejected with null" or "the promise fulfilled with undefined".
  if (!reason) {
    var newReason = new Error('Promise was rejected with a falsy value');
    newReason.reason = reason;
    reason = newReason;
  }
  return cb(reason);
}

function callbackify(original) {
  if (typeof original !== 'function') {
    throw new TypeError('The "original" argument must be of type Function');
  }

  // We DO NOT return the promise as it gives the user a false sense that
  // the promise is actually somehow related to the callback's execution
  // and that the callback throwing will reject the promise.
  function callbackified() {
    var args = [];
    for (var i = 0; i < arguments.length; i++) {
      args.push(arguments[i]);
    }

    var maybeCb = args.pop();
    if (typeof maybeCb !== 'function') {
      throw new TypeError('The last argument must be of type Function');
    }
    var self = this;
    var cb = function() {
      return maybeCb.apply(self, arguments);
    };
    // In true node style we process the callback on `nextTick` with all the
    // implications (stack, `uncaughtException`, `async_hooks`)
    original.apply(this, args)
      .then(function(ret) { process.nextTick(cb, null, ret) },
            function(rej) { process.nextTick(callbackifyOnRejected, rej, cb) });
  }

  Object.setPrototypeOf(callbackified, Object.getPrototypeOf(original));
  Object.defineProperties(callbackified,
                          getOwnPropertyDescriptors(original));
  return callbackified;
}
exports.callbackify = callbackify;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(5)))

/***/ }),
/* 33 */
/***/ (function(module, exports) {

module.exports = function isBuffer(arg) {
  return arg && typeof arg === 'object'
    && typeof arg.copy === 'function'
    && typeof arg.fill === 'function'
    && typeof arg.readUInt8 === 'function';
}

/***/ }),
/* 34 */
/***/ (function(module, exports) {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    var TempCtor = function () {}
    TempCtor.prototype = superCtor.prototype
    ctor.prototype = new TempCtor()
    ctor.prototype.constructor = ctor
  }
}


/***/ }),
/* 35 */
/***/ (function(module, exports) {

module.exports = Yallist

Yallist.Node = Node
Yallist.create = Yallist

function Yallist (list) {
  var self = this
  if (!(self instanceof Yallist)) {
    self = new Yallist()
  }

  self.tail = null
  self.head = null
  self.length = 0

  if (list && typeof list.forEach === 'function') {
    list.forEach(function (item) {
      self.push(item)
    })
  } else if (arguments.length > 0) {
    for (var i = 0, l = arguments.length; i < l; i++) {
      self.push(arguments[i])
    }
  }

  return self
}

Yallist.prototype.removeNode = function (node) {
  if (node.list !== this) {
    throw new Error('removing node which does not belong to this list')
  }

  var next = node.next
  var prev = node.prev

  if (next) {
    next.prev = prev
  }

  if (prev) {
    prev.next = next
  }

  if (node === this.head) {
    this.head = next
  }
  if (node === this.tail) {
    this.tail = prev
  }

  node.list.length--
  node.next = null
  node.prev = null
  node.list = null
}

Yallist.prototype.unshiftNode = function (node) {
  if (node === this.head) {
    return
  }

  if (node.list) {
    node.list.removeNode(node)
  }

  var head = this.head
  node.list = this
  node.next = head
  if (head) {
    head.prev = node
  }

  this.head = node
  if (!this.tail) {
    this.tail = node
  }
  this.length++
}

Yallist.prototype.pushNode = function (node) {
  if (node === this.tail) {
    return
  }

  if (node.list) {
    node.list.removeNode(node)
  }

  var tail = this.tail
  node.list = this
  node.prev = tail
  if (tail) {
    tail.next = node
  }

  this.tail = node
  if (!this.head) {
    this.head = node
  }
  this.length++
}

Yallist.prototype.push = function () {
  for (var i = 0, l = arguments.length; i < l; i++) {
    push(this, arguments[i])
  }
  return this.length
}

Yallist.prototype.unshift = function () {
  for (var i = 0, l = arguments.length; i < l; i++) {
    unshift(this, arguments[i])
  }
  return this.length
}

Yallist.prototype.pop = function () {
  if (!this.tail) {
    return undefined
  }

  var res = this.tail.value
  this.tail = this.tail.prev
  if (this.tail) {
    this.tail.next = null
  } else {
    this.head = null
  }
  this.length--
  return res
}

Yallist.prototype.shift = function () {
  if (!this.head) {
    return undefined
  }

  var res = this.head.value
  this.head = this.head.next
  if (this.head) {
    this.head.prev = null
  } else {
    this.tail = null
  }
  this.length--
  return res
}

Yallist.prototype.forEach = function (fn, thisp) {
  thisp = thisp || this
  for (var walker = this.head, i = 0; walker !== null; i++) {
    fn.call(thisp, walker.value, i, this)
    walker = walker.next
  }
}

Yallist.prototype.forEachReverse = function (fn, thisp) {
  thisp = thisp || this
  for (var walker = this.tail, i = this.length - 1; walker !== null; i--) {
    fn.call(thisp, walker.value, i, this)
    walker = walker.prev
  }
}

Yallist.prototype.get = function (n) {
  for (var i = 0, walker = this.head; walker !== null && i < n; i++) {
    // abort out of the list early if we hit a cycle
    walker = walker.next
  }
  if (i === n && walker !== null) {
    return walker.value
  }
}

Yallist.prototype.getReverse = function (n) {
  for (var i = 0, walker = this.tail; walker !== null && i < n; i++) {
    // abort out of the list early if we hit a cycle
    walker = walker.prev
  }
  if (i === n && walker !== null) {
    return walker.value
  }
}

Yallist.prototype.map = function (fn, thisp) {
  thisp = thisp || this
  var res = new Yallist()
  for (var walker = this.head; walker !== null;) {
    res.push(fn.call(thisp, walker.value, this))
    walker = walker.next
  }
  return res
}

Yallist.prototype.mapReverse = function (fn, thisp) {
  thisp = thisp || this
  var res = new Yallist()
  for (var walker = this.tail; walker !== null;) {
    res.push(fn.call(thisp, walker.value, this))
    walker = walker.prev
  }
  return res
}

Yallist.prototype.reduce = function (fn, initial) {
  var acc
  var walker = this.head
  if (arguments.length > 1) {
    acc = initial
  } else if (this.head) {
    walker = this.head.next
    acc = this.head.value
  } else {
    throw new TypeError('Reduce of empty list with no initial value')
  }

  for (var i = 0; walker !== null; i++) {
    acc = fn(acc, walker.value, i)
    walker = walker.next
  }

  return acc
}

Yallist.prototype.reduceReverse = function (fn, initial) {
  var acc
  var walker = this.tail
  if (arguments.length > 1) {
    acc = initial
  } else if (this.tail) {
    walker = this.tail.prev
    acc = this.tail.value
  } else {
    throw new TypeError('Reduce of empty list with no initial value')
  }

  for (var i = this.length - 1; walker !== null; i--) {
    acc = fn(acc, walker.value, i)
    walker = walker.prev
  }

  return acc
}

Yallist.prototype.toArray = function () {
  var arr = new Array(this.length)
  for (var i = 0, walker = this.head; walker !== null; i++) {
    arr[i] = walker.value
    walker = walker.next
  }
  return arr
}

Yallist.prototype.toArrayReverse = function () {
  var arr = new Array(this.length)
  for (var i = 0, walker = this.tail; walker !== null; i++) {
    arr[i] = walker.value
    walker = walker.prev
  }
  return arr
}

Yallist.prototype.slice = function (from, to) {
  to = to || this.length
  if (to < 0) {
    to += this.length
  }
  from = from || 0
  if (from < 0) {
    from += this.length
  }
  var ret = new Yallist()
  if (to < from || to < 0) {
    return ret
  }
  if (from < 0) {
    from = 0
  }
  if (to > this.length) {
    to = this.length
  }
  for (var i = 0, walker = this.head; walker !== null && i < from; i++) {
    walker = walker.next
  }
  for (; walker !== null && i < to; i++, walker = walker.next) {
    ret.push(walker.value)
  }
  return ret
}

Yallist.prototype.sliceReverse = function (from, to) {
  to = to || this.length
  if (to < 0) {
    to += this.length
  }
  from = from || 0
  if (from < 0) {
    from += this.length
  }
  var ret = new Yallist()
  if (to < from || to < 0) {
    return ret
  }
  if (from < 0) {
    from = 0
  }
  if (to > this.length) {
    to = this.length
  }
  for (var i = this.length, walker = this.tail; walker !== null && i > to; i--) {
    walker = walker.prev
  }
  for (; walker !== null && i > from; i--, walker = walker.prev) {
    ret.push(walker.value)
  }
  return ret
}

Yallist.prototype.reverse = function () {
  var head = this.head
  var tail = this.tail
  for (var walker = head; walker !== null; walker = walker.prev) {
    var p = walker.prev
    walker.prev = walker.next
    walker.next = p
  }
  this.head = tail
  this.tail = head
  return this
}

function push (self, item) {
  self.tail = new Node(item, self.tail, null, self)
  if (!self.head) {
    self.head = self.tail
  }
  self.length++
}

function unshift (self, item) {
  self.head = new Node(item, null, self.head, self)
  if (!self.tail) {
    self.tail = self.head
  }
  self.length++
}

function Node (value, prev, next, list) {
  if (!(this instanceof Node)) {
    return new Node(value, prev, next, list)
  }

  this.list = list
  this.value = value

  if (prev) {
    prev.next = this
    this.prev = prev
  } else {
    this.prev = null
  }

  if (next) {
    next.prev = this
    this.next = next
  } else {
    this.next = null
  }
}


/***/ }),
/* 36 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_36__;

/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

/*!
 * Fuse.js v3.6.1 - Lightweight fuzzy-search (http://fusejs.io)
 * 
 * Copyright (c) 2012-2017 Kirollos Risk (http://kiro.me)
 * All Rights Reserved. Apache Software License 2.0
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 */
!function(e,t){ true?module.exports=t():"function"==typeof define&&define.amd?define("Fuse",[],t):"object"==typeof exports?exports.Fuse=t():e.Fuse=t()}(this,function(){return function(e){var t={};function r(n){if(t[n])return t[n].exports;var o=t[n]={i:n,l:!1,exports:{}};return e[n].call(o.exports,o,o.exports,r),o.l=!0,o.exports}return r.m=e,r.c=t,r.d=function(e,t,n){r.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:n})},r.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},r.t=function(e,t){if(1&t&&(e=r(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var n=Object.create(null);if(r.r(n),Object.defineProperty(n,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var o in e)r.d(n,o,function(t){return e[t]}.bind(null,o));return n},r.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return r.d(t,"a",t),t},r.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},r.p="",r(r.s=0)}([function(e,t,r){function n(e){return(n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function o(e,t){for(var r=0;r<t.length;r++){var n=t[r];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var i=r(1),a=r(7),s=a.get,c=(a.deepValue,a.isArray),h=function(){function e(t,r){var n=r.location,o=void 0===n?0:n,i=r.distance,a=void 0===i?100:i,c=r.threshold,h=void 0===c?.6:c,l=r.maxPatternLength,u=void 0===l?32:l,f=r.caseSensitive,v=void 0!==f&&f,p=r.tokenSeparator,d=void 0===p?/ +/g:p,g=r.findAllMatches,y=void 0!==g&&g,m=r.minMatchCharLength,k=void 0===m?1:m,b=r.id,S=void 0===b?null:b,x=r.keys,M=void 0===x?[]:x,_=r.shouldSort,w=void 0===_||_,L=r.getFn,A=void 0===L?s:L,O=r.sortFn,C=void 0===O?function(e,t){return e.score-t.score}:O,j=r.tokenize,P=void 0!==j&&j,I=r.matchAllTokens,F=void 0!==I&&I,T=r.includeMatches,N=void 0!==T&&T,z=r.includeScore,E=void 0!==z&&z,W=r.verbose,K=void 0!==W&&W;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.options={location:o,distance:a,threshold:h,maxPatternLength:u,isCaseSensitive:v,tokenSeparator:d,findAllMatches:y,minMatchCharLength:k,id:S,keys:M,includeMatches:N,includeScore:E,shouldSort:w,getFn:A,sortFn:C,verbose:K,tokenize:P,matchAllTokens:F},this.setCollection(t),this._processKeys(M)}var t,r,a;return t=e,(r=[{key:"setCollection",value:function(e){return this.list=e,e}},{key:"_processKeys",value:function(e){if(this._keyWeights={},this._keyNames=[],e.length&&"string"==typeof e[0])for(var t=0,r=e.length;t<r;t+=1){var n=e[t];this._keyWeights[n]=1,this._keyNames.push(n)}else{for(var o=null,i=null,a=0,s=0,c=e.length;s<c;s+=1){var h=e[s];if(!h.hasOwnProperty("name"))throw new Error('Missing "name" property in key object');var l=h.name;if(this._keyNames.push(l),!h.hasOwnProperty("weight"))throw new Error('Missing "weight" property in key object');var u=h.weight;if(u<0||u>1)throw new Error('"weight" property in key must bein the range of [0, 1)');i=null==i?u:Math.max(i,u),o=null==o?u:Math.min(o,u),this._keyWeights[l]=u,a+=u}if(a>1)throw new Error("Total of weights cannot exceed 1")}}},{key:"search",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{limit:!1};this._log('---------\nSearch pattern: "'.concat(e,'"'));var r=this._prepareSearchers(e),n=r.tokenSearchers,o=r.fullSearcher,i=this._search(n,o);return this._computeScore(i),this.options.shouldSort&&this._sort(i),t.limit&&"number"==typeof t.limit&&(i=i.slice(0,t.limit)),this._format(i)}},{key:"_prepareSearchers",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",t=[];if(this.options.tokenize)for(var r=e.split(this.options.tokenSeparator),n=0,o=r.length;n<o;n+=1)t.push(new i(r[n],this.options));return{tokenSearchers:t,fullSearcher:new i(e,this.options)}}},{key:"_search",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],t=arguments.length>1?arguments[1]:void 0,r=this.list,n={},o=[];if("string"==typeof r[0]){for(var i=0,a=r.length;i<a;i+=1)this._analyze({key:"",value:r[i],record:i,index:i},{resultMap:n,results:o,tokenSearchers:e,fullSearcher:t});return o}for(var s=0,c=r.length;s<c;s+=1)for(var h=r[s],l=0,u=this._keyNames.length;l<u;l+=1){var f=this._keyNames[l];this._analyze({key:f,value:this.options.getFn(h,f),record:h,index:s},{resultMap:n,results:o,tokenSearchers:e,fullSearcher:t})}return o}},{key:"_analyze",value:function(e,t){var r=this,n=e.key,o=e.arrayIndex,i=void 0===o?-1:o,a=e.value,s=e.record,h=e.index,l=t.tokenSearchers,u=void 0===l?[]:l,f=t.fullSearcher,v=t.resultMap,p=void 0===v?{}:v,d=t.results,g=void 0===d?[]:d;!function e(t,o,i,a){if(null!=o)if("string"==typeof o){var s=!1,h=-1,l=0;r._log("\nKey: ".concat(""===n?"--":n));var v=f.search(o);if(r._log('Full text: "'.concat(o,'", score: ').concat(v.score)),r.options.tokenize){for(var d=o.split(r.options.tokenSeparator),y=d.length,m=[],k=0,b=u.length;k<b;k+=1){var S=u[k];r._log('\nPattern: "'.concat(S.pattern,'"'));for(var x=!1,M=0;M<y;M+=1){var _=d[M],w=S.search(_),L={};w.isMatch?(L[_]=w.score,s=!0,x=!0,m.push(w.score)):(L[_]=1,r.options.matchAllTokens||m.push(1)),r._log('Token: "'.concat(_,'", score: ').concat(L[_]))}x&&(l+=1)}h=m[0];for(var A=m.length,O=1;O<A;O+=1)h+=m[O];h/=A,r._log("Token score average:",h)}var C=v.score;h>-1&&(C=(C+h)/2),r._log("Score average:",C);var j=!r.options.tokenize||!r.options.matchAllTokens||l>=u.length;if(r._log("\nCheck Matches: ".concat(j)),(s||v.isMatch)&&j){var P={key:n,arrayIndex:t,value:o,score:C};r.options.includeMatches&&(P.matchedIndices=v.matchedIndices);var I=p[a];I?I.output.push(P):(p[a]={item:i,output:[P]},g.push(p[a]))}}else if(c(o))for(var F=0,T=o.length;F<T;F+=1)e(F,o[F],i,a)}(i,a,s,h)}},{key:"_computeScore",value:function(e){this._log("\n\nComputing score:\n");for(var t=this._keyWeights,r=!!Object.keys(t).length,n=0,o=e.length;n<o;n+=1){for(var i=e[n],a=i.output,s=a.length,c=1,h=0;h<s;h+=1){var l=a[h],u=l.key,f=r?t[u]:1,v=0===l.score&&t&&t[u]>0?Number.EPSILON:l.score;c*=Math.pow(v,f)}i.score=c,this._log(i)}}},{key:"_sort",value:function(e){this._log("\n\nSorting...."),e.sort(this.options.sortFn)}},{key:"_format",value:function(e){var t=[];if(this.options.verbose){var r=[];this._log("\n\nOutput:\n\n",JSON.stringify(e,function(e,t){if("object"===n(t)&&null!==t){if(-1!==r.indexOf(t))return;r.push(t)}return t},2)),r=null}var o=[];this.options.includeMatches&&o.push(function(e,t){var r=e.output;t.matches=[];for(var n=0,o=r.length;n<o;n+=1){var i=r[n];if(0!==i.matchedIndices.length){var a={indices:i.matchedIndices,value:i.value};i.key&&(a.key=i.key),i.hasOwnProperty("arrayIndex")&&i.arrayIndex>-1&&(a.arrayIndex=i.arrayIndex),t.matches.push(a)}}}),this.options.includeScore&&o.push(function(e,t){t.score=e.score});for(var i=0,a=e.length;i<a;i+=1){var s=e[i];if(this.options.id&&(s.item=this.options.getFn(s.item,this.options.id)[0]),o.length){for(var c={item:s.item},h=0,l=o.length;h<l;h+=1)o[h](s,c);t.push(c)}else t.push(s.item)}return t}},{key:"_log",value:function(){var e;this.options.verbose&&(e=console).log.apply(e,arguments)}}])&&o(t.prototype,r),a&&o(t,a),e}();e.exports=h},function(e,t,r){function n(e,t){for(var r=0;r<t.length;r++){var n=t[r];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var o=r(2),i=r(3),a=r(6),s=function(){function e(t,r){var n=r.location,o=void 0===n?0:n,i=r.distance,s=void 0===i?100:i,c=r.threshold,h=void 0===c?.6:c,l=r.maxPatternLength,u=void 0===l?32:l,f=r.isCaseSensitive,v=void 0!==f&&f,p=r.tokenSeparator,d=void 0===p?/ +/g:p,g=r.findAllMatches,y=void 0!==g&&g,m=r.minMatchCharLength,k=void 0===m?1:m,b=r.includeMatches,S=void 0!==b&&b;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.options={location:o,distance:s,threshold:h,maxPatternLength:u,isCaseSensitive:v,tokenSeparator:d,findAllMatches:y,includeMatches:S,minMatchCharLength:k},this.pattern=v?t:t.toLowerCase(),this.pattern.length<=u&&(this.patternAlphabet=a(this.pattern))}var t,r,s;return t=e,(r=[{key:"search",value:function(e){var t=this.options,r=t.isCaseSensitive,n=t.includeMatches;if(r||(e=e.toLowerCase()),this.pattern===e){var a={isMatch:!0,score:0};return n&&(a.matchedIndices=[[0,e.length-1]]),a}var s=this.options,c=s.maxPatternLength,h=s.tokenSeparator;if(this.pattern.length>c)return o(e,this.pattern,h);var l=this.options,u=l.location,f=l.distance,v=l.threshold,p=l.findAllMatches,d=l.minMatchCharLength;return i(e,this.pattern,this.patternAlphabet,{location:u,distance:f,threshold:v,findAllMatches:p,minMatchCharLength:d,includeMatches:n})}}])&&n(t.prototype,r),s&&n(t,s),e}();e.exports=s},function(e,t){var r=/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g;e.exports=function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:/ +/g,o=new RegExp(t.replace(r,"\\$&").replace(n,"|")),i=e.match(o),a=!!i,s=[];if(a)for(var c=0,h=i.length;c<h;c+=1){var l=i[c];s.push([e.indexOf(l),l.length-1])}return{score:a?.5:1,isMatch:a,matchedIndices:s}}},function(e,t,r){var n=r(4),o=r(5);e.exports=function(e,t,r,i){for(var a=i.location,s=void 0===a?0:a,c=i.distance,h=void 0===c?100:c,l=i.threshold,u=void 0===l?.6:l,f=i.findAllMatches,v=void 0!==f&&f,p=i.minMatchCharLength,d=void 0===p?1:p,g=i.includeMatches,y=void 0!==g&&g,m=s,k=e.length,b=u,S=e.indexOf(t,m),x=t.length,M=[],_=0;_<k;_+=1)M[_]=0;if(-1!==S){var w=n(t,{errors:0,currentLocation:S,expectedLocation:m,distance:h});if(b=Math.min(w,b),-1!==(S=e.lastIndexOf(t,m+x))){var L=n(t,{errors:0,currentLocation:S,expectedLocation:m,distance:h});b=Math.min(L,b)}}S=-1;for(var A=[],O=1,C=x+k,j=1<<(x<=31?x-1:30),P=0;P<x;P+=1){for(var I=0,F=C;I<F;){n(t,{errors:P,currentLocation:m+F,expectedLocation:m,distance:h})<=b?I=F:C=F,F=Math.floor((C-I)/2+I)}C=F;var T=Math.max(1,m-F+1),N=v?k:Math.min(m+F,k)+x,z=Array(N+2);z[N+1]=(1<<P)-1;for(var E=N;E>=T;E-=1){var W=E-1,K=r[e.charAt(W)];if(K&&(M[W]=1),z[E]=(z[E+1]<<1|1)&K,0!==P&&(z[E]|=(A[E+1]|A[E])<<1|1|A[E+1]),z[E]&j&&(O=n(t,{errors:P,currentLocation:W,expectedLocation:m,distance:h}))<=b){if(b=O,(S=W)<=m)break;T=Math.max(1,2*m-S)}}if(n(t,{errors:P+1,currentLocation:m,expectedLocation:m,distance:h})>b)break;A=z}var $={isMatch:S>=0,score:0===O?.001:O};return y&&($.matchedIndices=o(M,d)),$}},function(e,t){e.exports=function(e,t){var r=t.errors,n=void 0===r?0:r,o=t.currentLocation,i=void 0===o?0:o,a=t.expectedLocation,s=void 0===a?0:a,c=t.distance,h=void 0===c?100:c,l=n/e.length,u=Math.abs(s-i);return h?l+u/h:u?1:l}},function(e,t){e.exports=function(){for(var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,r=[],n=-1,o=-1,i=0,a=e.length;i<a;i+=1){var s=e[i];s&&-1===n?n=i:s||-1===n||((o=i-1)-n+1>=t&&r.push([n,o]),n=-1)}return e[i-1]&&i-n>=t&&r.push([n,i-1]),r}},function(e,t){e.exports=function(e){for(var t={},r=e.length,n=0;n<r;n+=1)t[e.charAt(n)]=0;for(var o=0;o<r;o+=1)t[e.charAt(o)]|=1<<r-o-1;return t}},function(e,t){var r=function(e){return Array.isArray?Array.isArray(e):"[object Array]"===Object.prototype.toString.call(e)},n=function(e){return null==e?"":function(e){if("string"==typeof e)return e;var t=e+"";return"0"==t&&1/e==-1/0?"-0":t}(e)},o=function(e){return"string"==typeof e},i=function(e){return"number"==typeof e};e.exports={get:function(e,t){var a=[];return function e(t,s){if(s){var c=s.indexOf("."),h=s,l=null;-1!==c&&(h=s.slice(0,c),l=s.slice(c+1));var u=t[h];if(null!=u)if(l||!o(u)&&!i(u))if(r(u))for(var f=0,v=u.length;f<v;f+=1)e(u[f],l);else l&&e(u,l);else a.push(n(u))}else a.push(t)}(e,t),a},isArray:r,isString:o,isNum:i,toString:n}}])});

/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports) {
    "use strict";

    /**
     * Stores user search results for the server-users-supplier
     */
    // TODO CONFSRVDEV-2015 - shouldn't store the same User object more than once. Should only store lists of keys in the query map,
    // and then have a separate cross-supplier Map of User objects by key. dT
    var cache = {};
    var queries = [];

    exports.default = function (limit) {
        return {
            add: function add(query, users) {
                cache[query] = {
                    query: query,
                    users: users,
                    isExhausted: users.length < limit
                };

                // Queries list is alph sorted descending so that longer queries are above the shorter queries that
                // they contain.
                queries.push(query);
                queries.sort();
                queries.reverse();
            },

            /**
             * Look in the cache for this query or a shorter one.
             */
            getClosest: function getClosest(query) {
                if (cache[query]) {
                    return cache[query];
                }

                // Else find the longest matching substring of the query.
                // The query list is sorted, so the first item found should be the longest one.
                var queryMatch = queries.find(function (subquery) {
                    return query.indexOf(subquery) === 0;
                });
                if (queryMatch) {
                    return cache[queryMatch];
                }

                return null; // just to make this obvious...
            },

            // Used in tests.
            reset: function reset() {
                cache = {};
                queries = [];
            }
        };
    };

    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports) {
    'use strict';

    function escape(query) {
        return [].map.call(query, function escapeSpecialCharacter(char) {
            if (char === '+' || char === '-' || char === '&' || char === '|' || char === '!' || char === '(' || char === ')' || char === '{' || char === '}' || char === '[' || char === ']' || char === '^' || char === '"' || char === '~' || char === '*' || char === '?' || char === ':' || char === '\\') return '\\' + char;
            return char;
        }).join('');
    }

    exports.default = {
        escape: escape
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(2), __webpack_require__(1)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _meta, _userSupplierKeys) {
    'use strict';

    var Meta = _interopRequireDefault(_meta).default;

    var UserSupplier = _interopRequireDefault(_userSupplierKeys).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    'use strict';

    function getCurrentUser() {
        return new Promise(function (resolve) {
            var username = Meta.get('remote-user');
            if (!username) {
                // Anonymous user.
                return resolve();
            }

            var userKey = Meta.get('remote-user-key');
            var displayName = Meta.get('current-user-fullname');
            var path = Meta.get('current-user-avatar-uri-reference');

            resolve({
                type: 'known',
                username: username,
                userKey: userKey,
                profilePicture: {
                    path: path,
                    width: 48,
                    height: 48
                },
                displayName: displayName,
                supplier: UserSupplier.CURRENT
            });
        });
    }

    exports.default = {
        getCurrentUser: getCurrentUser
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(15), __webpack_require__(42), __webpack_require__(13), __webpack_require__(43), __webpack_require__(16), __webpack_require__(45), __webpack_require__(46), __webpack_require__(47), __webpack_require__(17)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _templates, _resultPlaceholder, _userRanker, _userConverter, _utils, _defaultOrdering, _scoreLogger, _defaultFiltering, _scoreBooster) {
    'use strict';

    var Templates = _interopRequireDefault(_templates).default;

    var ResultPlaceholder = _interopRequireDefault(_resultPlaceholder).default;

    var SearchUsers = _interopRequireDefault(_userRanker).default;

    var ConvertUsers = _interopRequireDefault(_userConverter).default;

    var RenderUtils = _interopRequireDefault(_utils).default;

    var ensureDefaultOrder = _interopRequireDefault(_defaultOrdering).default;

    var scoreLogger = _interopRequireDefault(_scoreLogger).default;

    var filterServerResults = _interopRequireDefault(_defaultFiltering).default;

    var ScoreBooster = _interopRequireDefault(_scoreBooster).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    'use strict'; /**
                   * The contents of the UserCache is passed through the user pipeline which filters, ranks and modifies
                   * the list until we arrive at the final 5 elements to display.
                   *
                   * Want To add another function to the user pipeline? Easy...
                   *
                   * Define a function like the following and add it to a pipeline. Ordering is very important.
                   *
                   * @param results   The results array as supplied by the previous function
                   * @param next      Call this function and pass some results to trigger the next stage of the pipeline
                   * @param context   Some context about the current rendering request. See Mentions.js
                   *
                   * function pipelineTransformation(results, next, context) {
                   *      //Do some things on results
                   *      results.forEach((results) => transform(result))
                   *
                   *      //Remember to call next
                   *      next(results);
                   * }
                   */

    function filterUsingQuery(results, next, context) {
        next(SearchUsers(results, context.query));
    }

    function moveSelectedUserToTop(oldUsers, next, context) {
        if (!context.selectedUser) {
            return next(oldUsers);
        }

        var index = oldUsers.findIndex(function (user) {
            return user.username === context.selectedUser.username;
        });
        // Note that > -1 means that the user IS in the array. If index is 0, the user is already in the correct position
        // at the start of the array and there is nothing to do.
        if (index <= 0) {
            return next(oldUsers);
        }

        // Put this user at the start of the array.
        var user = oldUsers[index];
        var newUsers = oldUsers.slice(0); // clone the array to avoid modifying the original
        newUsers.splice(index, 1);
        newUsers.unshift(user);

        return next(newUsers);
    }

    /**
     * fuseScore is available on all user results for a query-term search, so we can sort at any point in the pipeline.
     */
    function sortOnScore(users, next) {
        if (users.length && typeof users[0].fuseScore === 'number') {
            // If the first result has a fuseScore they all will.
            users.sort(function (user1, user2) {
                return user1.fuseScore - user2.fuseScore;
            });
        }
        next(users);
    }

    function limit(array, next, context) {
        next(array.slice(0, context.DISPLAY_LIMIT));
    }

    // Called in the Server pipeline when there are no results.
    function userNotFound(results, next) {
        if (!results.length) {
            var notFoundResult = RenderUtils.resultWithHtml(Templates.Mentions.userNotFoundResult());
            results = [notFoundResult];
        }

        next(results);
    }

    function empty(results, next) {
        if (!results.length) {
            next([RenderUtils.resultWithHtml(Templates.Mentions.loadingPlaceholder())]);
        } else {
            next(results);
        }
    }

    function addErrorResult(results, next) {
        var failureResult = RenderUtils.resultWithHtml(Templates.Mentions.searchFailureResult());
        next([failureResult]);
    }

    /**
     * This function convert Users from API format to something that the Dropdown can display.
     *
     * All elements in the results array should be Users in API format.
     * If you want to add other elements to the results array, do this *after* convertUsers in the pipeline
     *
     * @param results
     * @param next
     */
    function convertUsers(results, next) {
        next(ConvertUsers(results));
    }

    // Don't continue the render if the query is stale.
    function staleServerResponseFilter(results, next, context) {
        if (context.latestQuery === context.query) {
            next(results);
        }
    }

    exports.default = {
        default: function _default(renderCallback) {
            return [ResultPlaceholder.cancelTimeout, filterServerResults, ensureDefaultOrder, limit, ScoreBooster.setSuggestedUsers, convertUsers, renderCallback];
        },

        client: function client(renderCallback) {
            return [ResultPlaceholder.cancelTimeout, filterUsingQuery, ScoreBooster.boostScores, sortOnScore, limit, moveSelectedUserToTop, convertUsers, ResultPlaceholder.startTimeout, empty, renderCallback];
        },
        server: function server(renderCallback) {
            return [ResultPlaceholder.cancelTimeout, staleServerResponseFilter, filterUsingQuery, ScoreBooster.boostScores, sortOnScore, limit, moveSelectedUserToTop, scoreLogger, convertUsers, userNotFound, renderCallback];
        },

        error: function error(renderCallback) {
            return [ResultPlaceholder.cancelTimeout, addErrorResult, renderCallback];
        },

        _functions: {
            moveSelectedUserToTop: moveSelectedUserToTop,
            sortOnScore: sortOnScore
        }
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(16), __webpack_require__(15)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _utils, _templates) {
    'use strict';

    var RenderUtils = _interopRequireDefault(_utils).default;

    var Templates = _interopRequireDefault(_templates).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var displayTimeout = void 0;

    function _padResults(results, context) {
        var additionalElements = context.DISPLAY_LIMIT - results.length;
        if (additionalElements > 0) {
            var placeholder = RenderUtils.resultWithHtml(Templates.Mentions.loadingPlaceholder());
            for (var index = 0; index < additionalElements; index++) {
                results.push(placeholder);
            }
        }
        return results;
    }

    function startTimeout(results, next, context) {
        displayTimeout = setTimeout(function () {
            results = _padResults(results, context);
            next(results);
        }, window.skeletonPlaceholder || 3000); // CONFSRVDEV-3833 Remove once an appropriate value has been found.
        next(results);
    }

    function cancelTimeout(results, next) {
        clearTimeout(displayTimeout);
        next(results);
    }

    exports.default = {
        startTimeout: startTimeout,
        cancelTimeout: cancelTimeout
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(2), __webpack_require__(10), __webpack_require__(1), __webpack_require__(44)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _meta, _i18n, _userSupplierKeys, _darkFeatures) {
    'use strict';

    var Meta = _interopRequireDefault(_meta).default;

    var I18n = _interopRequireDefault(_i18n).default;

    var UserSupplier = _interopRequireDefault(_userSupplierKeys).default;

    var DarkFeatures = _interopRequireDefault(_darkFeatures).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    /**
     * Converts Users from API format to something that the Dropdown can display.
     */
    var contextPath = Meta.get('context-path');

    function getProfilePicture(user) {
        if (user && user.profilePicture && Meta.get('can-view-profile')) {
            // HACK - work around CONFSRVDEV-2936 by removing the dud context-path from the path.
            return user.profilePicture.path.replace('/_' + contextPath, '/_');
        }
        return contextPath + '/images/icons/profilepics/anonymous.svg';
    }

    var converter = function converter(users) {
        var addRecentLozenge = DarkFeatures.isEnabled('smart.mentions.recent.lozenge');
        var linkBase = Meta.get('base-url') + '/display/~';

        return users.map(function (user) {
            var link = linkBase + user.username;

            var lozenge = user.supplier === UserSupplier.RELATED && user.role && user.role.i18n;

            if (!lozenge && addRecentLozenge) {
                // Including a lozenge for Recent helps us see why an item is promoted, but make it opt-in.
                lozenge = user.supplier === UserSupplier.RECENT && I18n('user.supplier.recent');
            }
            // Uncomment this line to see why the results are in the order they are.
            // const lozenge = "" + user.fuseScore;

            return {
                className: 'insert-mentions-dropdown-option',
                name: user.displayName,
                username: user.username,
                href: link, // only used if the user tries to middle-click/open-in-new-tab the dropdown item
                icon: getProfilePicture(user),
                lozenge: lozenge,
                link: link,
                model: user,
                fuseMatches: user.fuseMatches
            };
        });
    };

    // Available for unit testing.
    converter._getProfilePicture = getProfilePicture;

    exports.default = converter;
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 44 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_44__;

/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(4)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _recentUsersSupplier) {
    'use strict';

    var RecentUsers = _interopRequireDefault(_recentUsersSupplier).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
        return typeof obj;
    } : function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };

    var supplierToScoreMap = {
        current: 1,
        recent: 2,
        related: {
            creator: 3,
            contributor: 4,
            commenter: 5
        },
        server: 6
    };

    var MAX_SCORE = 100;

    function scoreUser(user) {
        var potentialScore = supplierToScoreMap[user.supplier];

        if (typeof potentialScore === 'number') {
            if (typeof user.sortIndex === 'number') {
                // This allows us to sort recent users coming out of the cache. The highest calculated score will be just < 3.
                potentialScore += user.sortIndex / (RecentUsers.RECENT_USER_LIMIT + 1);
            }
            return potentialScore;
        }

        // Not a number, probably another object, index into it with role
        // Otherwise, it might have been undefined
        return (typeof potentialScore === 'undefined' ? 'undefined' : _typeof(potentialScore)) === 'object' ? potentialScore[user.role.role] : MAX_SCORE;
    }

    function ensureDefaultOrder(results, next) {
        var sorted = results.sort(function (user1, user2) {
            return scoreUser(user1) - scoreUser(user2);
        });
        next(sorted);
    }

    exports.default = ensureDefaultOrder;
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(0)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _ajs) {
    'use strict';

    exports.default = logScores;

    var AJS = _interopRequireDefault(_ajs).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    'use strict';

    /**
     * Just used during development, logs result score information to help us figure out reasons for result order.
     */
    function logScores(results, next, context) {
        if (context.query) {
            AJS.debug('*** Mentions *** user-pipeline/logger: Logging search results for ' + context.query);

            results.forEach(function (user) {
                AJS.debug('*** Mentions *** user-pipeline/logger: ' + user.displayName + ' has a score of ' + user.fuseScore);
            });
        }

        next(results);
    }
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(1)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _userSupplierKeys) {
    'use strict';

    var DEFAULT_SUPPLIERS = [_userSupplierKeys.RECENT, _userSupplierKeys.CURRENT, _userSupplierKeys.RELATED];

    function filterServerResults(results, next) {
        var filteredUsers = results.filter(function (user) {
            return DEFAULT_SUPPLIERS.indexOf(user.supplier) !== -1;
        });
        next(filteredUsers);
    }

    exports.default = filterServerResults;
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports) {
    'use strict';

    function PipelineExecutor(pipeline, context) {
        this.pipeline = pipeline;
        this.context = context;
    }

    PipelineExecutor.prototype.execute = function (input) {
        this._next(0, input);
    };

    PipelineExecutor.prototype._next = function (index, results) {
        this.pipeline[index](results, this._next.bind(this, index + 1), this.context);
    };

    exports.default = PipelineExecutor;
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports, __webpack_require__(0), __webpack_require__(50), __webpack_require__(18)], __WEBPACK_AMD_DEFINE_RESULT__ = (function (module, exports, _ajs, _analyticsSupport, _autocompleteManager) {
    'use strict';

    var AJS = _interopRequireDefault(_ajs).default;

    var Analytics = _interopRequireDefault(_analyticsSupport).default;

    var AutocompleteManager = _interopRequireDefault(_autocompleteManager).default;

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    'use strict';

    function publishEventForSelection(user) {
        var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        var idd = typeof AutocompleteManager.getInputDrivenDropdown === 'function' && AutocompleteManager.getInputDrivenDropdown();
        if (!idd || !user) {
            AJS.debug("Cannot publish 'confluence.mention.selection' analytics with missing dropdown, user or context.");
            return;
        }

        var query = idd._value || '';
        var dd = idd.dd;
        var index = dd && typeof dd.getFocusIndex === 'function' && dd.getFocusIndex();

        var analyticsData = {
            source: user.model.supplier,
            queryLength: query.length,
            queryWords: query.split(' ').length,
            index: index,
            numberOfSearches: context.numGetDataAndRunCallbackCalls
        };

        // By publishing the supplier source of the selected User, we can determine whether users are finding
        // the users they need from the Smart mentions or whether they still have to wait for the Dumb (server)
        // ones.
        Analytics.publish('confluence.mention.selection', analyticsData);
        AJS.debug("Published 'confluence.mention.selection' event with supplier: " + user.model.supplier);
    }

    /**
     * Updates the state of the current Mention interaction.
     * @param autoCompleteControl
     */
    function updateSession(autoCompleteControl) {
        autoCompleteControl.analytics = Object.assign({
            numGetDataAndRunCallbackCalls: 0
        }, autoCompleteControl.analytics);

        autoCompleteControl.analytics.numGetDataAndRunCallbackCalls += 1;
    }

    exports.default = {
        updateSession: updateSession,
        publishEventForSelection: publishEventForSelection
    };
    module.exports = exports['default'];
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),
/* 50 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_50__;

/***/ }),
/* 51 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_51__;

/***/ }),
/* 52 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_52__;

/***/ })
/******/ ])});;