(function ($) {
    var contextPath =
        typeof AJS.contextPath === "function" ? AJS.contextPath() : "";

    var sendRedrawMessage = function () {
        // Using common AUI message close event to broadcast that the screen should be redrawn
        AJS.$(document).trigger("aui-message-close");
    };

    var positionBanner = function ($message, config) {
        switch (config.insert) {
            case 'prepend': {
                $message.prependTo(config.position);
                break;
            }
            case 'append' :
                // fall through because this was AUI default
            case 'before': {
                $message.insertBefore(config.position);
                break;
            }
            case 'after': {
                $message.insertAfter(config.position);
                break;
            }
            default:
                $message.appendTo(config.position);
        }
    };

    AJS.toInit(function ($) {
        var $appNameMeta = $("meta[name='application-name']");
        var appName = $appNameMeta.attr("content");

        var performRedraw = true;

        if (!appName) {
            appName = "Confluence";
        }

        var displayName = appName;
        var bannerLocation = {
            insert: "prepend"
        };

        if (appName === "JIRA") {
            bannerLocation.position = "#content";
            // In Jira Agile single-page views, we have CSS flex based layout for content hence require different setting
            if($(document.body).hasClass('ghx-rapid-views')) {
                bannerLocation.position = "#page #header";
                bannerLocation.insert = "after";
            }

        } else if (appName == "Stash") {
            bannerLocation.position = "#content .aui-page-panel-content";
        } else if (appName === "Bitbucket") {
            bannerLocation.position = "#content .aui-page-panel-content";
        } else if (appName === "fecru") {
            bannerLocation.position = "#content";
            displayName = $appNameMeta.attr("display-name");
        } else if (appName === "Bamboo") {
            bannerLocation.position = "#content";
            performRedraw = false;
        } else if (appName === "Crowd") {
            bannerLocation.position = "#content .aui-page-panel-content";
            performRedraw = false;
        } else if (appName === "Confluence") {
            bannerLocation.position = "#content";
        } else {
            bannerLocation.position = "#main";
        }

        var privacyPolicyDocsLink = "<a href=\"http://www.atlassian.com/company/privacy?utm_source=" + displayName + "&utm_medium=privacy-policy-banner&utm_campaign=privacy-policy\" target=\"_blank\">";

        var $message = AJS.messages.warning(document.createDocumentFragment(), {
            title: AJS.I18n.getText("analytics.privacy.policy.change.title"),
            body: "<p>" +
                        AJS.I18n.getText("analytics.privacy.policy.change.description", displayName) +
                  "</p>" +
                  "<p><ul>" +
                    "<li>" +
                        AJS.I18n.getText("analytics.privacy.policy.example", "<a href=\"" + contextPath +  "/plugins/servlet/analytics/sample\">", "</a>") +
                    "</li>" +
                    "<li>" +
                        AJS.I18n.getText("analytics.privacy.policy.change.settings.link", "<a href=\"" + contextPath + "/plugins/servlet/analytics/configuration\">", "</a>") +
                    "</li>" +
                  "</ul></p>" +
                  "<p>" +
                        AJS.I18n.getText("analytics.privacy.policy.review", privacyPolicyDocsLink, "</a>") +
                  "</p>" +
                  "<p><button id=\"policy-update-acknowledge\" class=\"aui-button aui-button-primary\">" + AJS.I18n.getText("analytics.privacy.policy.acknowledge.button") + "</button></p>",
            id: "policy-update-message",
            closeable: false,
            shadowed: true
        });

        positionBanner($message, bannerLocation);

        if (performRedraw) {
            sendRedrawMessage();
        }

        $("#policy-update-acknowledge").on("click", function() {
            fetch(contextPath + "/rest/analytics/1.0/config/acknowledge", {
                method: "PUT",
                body: "policyAcknowledged=true",
                cache: "no-cache",
                credentials: "same-origin",
            }).then(() => {
                AJS.trigger('analytics-policy-acknowledged');
                $("#policy-update-message").fadeOut(500, function() {
                    $("#policy-update-message").remove();
                    if (performRedraw) {
                        sendRedrawMessage();
                    }
                });
            }, () => {
                AJS.messages.error("#policy-update-message", {
                    body: AJS.I18n.getText("analytics.privacy.policy.update.fail"),
                    id: "config-update-failed",
                    insert: "append",
                    closeable: false,
                    shadowed: true
                });
                $(".aui-message#config-update-failed").delay(2000).fadeOut(500, function () {
                    $("#config-update-failed").remove();
                    if (performRedraw) {
                        sendRedrawMessage();
                    }
                });
            });
        });
    });
})(AJS.$);
