<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

    <xsl:output method="xml"/>

    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="table[contains(@class, 'diff-macro')]">
        <xsl:variable name="oldClass" select="@class"/>
        <xsl:variable name="title" select="thead//th//*[contains(@class,'diff-html')]"/>
        <table>
            <xsl:copy-of select="@*"/>
            <xsl:if test="contains($title/@class, 'diff-html')">
                <xsl:attribute name="class">
                    <xsl:value-of select="$oldClass"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="$title/@class"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates select="node()"/>
        </table>
    </xsl:template>

    <!-- Replace <inline-tasl-list-ul> and <inline-task-list-li>  with <ul> and <li>.
         They already have the right 'class' attributes. -->
    <xsl:template match="//inline-task-list-ul">
        <ul>
            <xsl:attribute name="class">inline-task-list</xsl:attribute>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates/>
        </ul>
    </xsl:template>
    <xsl:template match="//inline-task-list-li">
        <xsl:choose>
            <xsl:when test="parent::inline-task-list-ul">
                <li>
                    <xsl:copy-of select="@*"/>
                    <xsl:apply-templates/>
                </li>
            </xsl:when>
            <xsl:otherwise>
                <!-- DaisyDiff sometimes messes up with lists, for example when a paragraph was inserted before a list and the first LI was
                     removed. This will ensure inline tasks always have a parent. -->
                <ul>
                    <xsl:attribute name="class">inline-task-list diff-inline-task-list</xsl:attribute>
                    <li>
                        <xsl:copy-of select="@*"/>
                        <xsl:apply-templates/>
                    </li>
                </ul>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Replace {@literal <inline-task-check-marker class="inline-task checked"><span class="diff-html-removed">&nbsp;</span></inline-task-check-marker>}
         with    {@literal <span class="diff-inline-task-overlay diff-html-removed"><span class="inline-task checked">&nbsp;</span></span>}
         and similar with diff-html-changed and diff-html-added -->
    <xsl:template match="//inline-task-check-marker">
        <xsl:choose>
            <xsl:when test="contains(@class, 'inline-task') and contains(span/@class, 'diff-html')">
                <xsl:variable name="tickClass" select="@class"/>
                <xsl:variable name="diffHtmlClass" select="span/@class"/>
                <span>
                    <!-- Note that we don't copy the other attributes, which only relate to DaisyDiff metadata. -->
                    <xsl:attribute name="class">
                        <xsl:text>diff-inline-task-overlay </xsl:text>
                        <xsl:value-of select="$diffHtmlClass"/>
                    </xsl:attribute>
                    <span>
                        <xsl:attribute name="class">
                            <xsl:value-of select="$tickClass"/>
                        </xsl:attribute>
                        <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
                    </span>
                </span>
            </xsl:when>
            <xsl:otherwise>
                <!-- Just copy other tick marks as-is -->
                <span>
                    <xsl:copy-of select="@*"/>
                    <xsl:apply-templates/>
                </span>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>