<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:variable name="diffAddedBackgroundColor">#ddfade</xsl:variable>
    <xsl:variable name="diffAddedBorderColor">#93c49f</xsl:variable>
    <xsl:variable name="diffRemovedBackgroundColor">#ffe7e7</xsl:variable>
    <xsl:variable name="diffRemovedBorderColor">#df9898</xsl:variable>
    <xsl:variable name="diffChangedBackgroundColor">#d6f0ff</xsl:variable>
    <xsl:variable name="diffChangedBorderColor">#9eb6d4</xsl:variable>

    <xsl:variable name="diffMacroPanelBackgroundColor">#f0f0f0</xsl:variable>
    <xsl:variable name="diffMacroPanelLightBackgroundColor">#fafafa</xsl:variable>
    <xsl:variable name="diffMacroPanelBorderColor">#dddddd</xsl:variable>

    <xsl:variable name="diffImageOverlayColor">#535353</xsl:variable>

    <xsl:output method="html"/>

    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>

    <!-- Styles for Inline Tasks -->
    <xsl:template match="//ul[contains(@class, 'inline-task-list')]/li">
        <!-- In a normal rendering an inline task has the following format <ul class="inline-task-list"><li data-inline-task-id="1" class="checked">
             In a diff rendering an inline task can have the following formats:
                 <ul class="inline-task-list"><li><span class="inline-task checked"></span>
                 <ul class="inline-task-list"><li><span class="diff-inline-task-overlay"><span class="inline-task checked"></span>
             In the examples above, the "checked" class is toggled depending on if the task is completed. As you can tell, XSL conversion of
             this sort is very brittle, almost impossible to debug. This XSL should be replaced by a notification-aware renderer for inline tasks
             and mentions that can do this conversion in a reliable manner. End rant. But seriously.
         -->
        <xsl:variable name="contains-unchecked-inline-task" select="(./@data-inline-task-id and not(contains(@class, 'checked'))) or (./span[contains(@class, 'inline-task') and not(contains(@class, 'checked'))] or ./span[contains(@class, 'diff-inline-task-overlay')]/span[contains(@class, 'inline-task') and not(contains(@class, 'checked'))])" />
        <xsl:variable name="contains-checked-inline-task" select="(./@data-inline-task-id and contains(@class, 'checked')) or ((./span[contains(@class, 'diff-inline-task-overlay')]/span[contains(@class, 'inline-task') and contains(@class, 'checked')]) or ./span[contains(@class, 'inline-task') and contains(@class, 'checked')])" />
        <xsl:variable name="indent-level-contains-inline-task" select="./@data-inline-task-id or (./span[contains(@class, 'inline-task')] or ./span[contains(@class, 'diff-inline-task-overlay')]/span[contains(@class, 'inline-task')])" />
        <tr>
            <td>
                <table>
                    <xsl:attribute name="cellspacing">0</xsl:attribute>
                    <xsl:attribute name="cellpadding">0</xsl:attribute>
                    <xsl:attribute name="border">0</xsl:attribute>
                    <xsl:attribute name="width">100%</xsl:attribute>
                    <xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute>
                    <tr>
                        <xsl:choose>
                            <xsl:when test="$indent-level-contains-inline-task">
                                <td>
                                    <xsl:attribute name="class">inline-task-image-container-cell</xsl:attribute>
                                    <xsl:attribute name="valign">top</xsl:attribute>
                                    <img>
                                        <!-- These icons are appended to the email using com/atlassian/confluence/content/render/xhtml/storage/InlineTasksUtils.java -->
                                        <xsl:if test="$contains-unchecked-inline-task">
                                            <xsl:attribute name="src">cid:inline-task-unchecked-icon</xsl:attribute>
                                            <xsl:attribute name="alt">&#9744;</xsl:attribute>
                                        </xsl:if>
                                        <xsl:if test="$contains-checked-inline-task">
                                            <xsl:attribute name="src">cid:inline-task-checked-icon</xsl:attribute>
                                            <xsl:attribute name="alt">&#9745;</xsl:attribute>
                                        </xsl:if>
                                        <xsl:attribute name="width">16</xsl:attribute>
                                        <xsl:attribute name="height">16</xsl:attribute>
                                        <xsl:attribute name="border">0</xsl:attribute>
                                        <xsl:attribute name="style">vertical-align: top; display:block;</xsl:attribute>
                                    </img>
                                    <xsl:attribute name="width">16</xsl:attribute>
                                </td>
                                <td>
                                    <xsl:copy-of select="@*"/>
                                    <xsl:if test="$contains-unchecked-inline-task">
                                        <xsl:attribute name="class">inline-task-text-container mobile-resize-text</xsl:attribute>
                                    </xsl:if>
                                    <xsl:if test="$contains-checked-inline-task">
                                        <xsl:attribute name="class">inline-task-text-container mobile-resize-text checked</xsl:attribute>
                                    </xsl:if>
                                    <xsl:attribute name="width">100%</xsl:attribute>
                                    <xsl:attribute name="valign">top</xsl:attribute>
                                    <xsl:apply-templates select="node()"/>
                                </td>
                            </xsl:when>
                            <xsl:otherwise>
                                <td>
                                    <xsl:copy-of select="@*"/>
                                    <xsl:attribute name="class">inline-task-indent-container</xsl:attribute>
                                    <xsl:attribute name="width">100%</xsl:attribute>
                                    <xsl:attribute name="valign">top</xsl:attribute>
                                    <xsl:attribute name="colspan">2</xsl:attribute>
                                    <xsl:apply-templates select="node()"/>
                                </td>
                            </xsl:otherwise>
                        </xsl:choose>
                    </tr>
                </table>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="//ul[contains(@class, 'inline-task-list')]">
        <table>
            <xsl:attribute name="cellspacing">0</xsl:attribute>
            <xsl:attribute name="cellpadding">0</xsl:attribute>
            <xsl:attribute name="border">0</xsl:attribute>
            <xsl:attribute name="width">100%</xsl:attribute>
            <xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="node()"/>
        </table>
    </xsl:template>

    <!-- Due date styles: Need to convert time element to span elements because <time> is not supported by many email clients -->
    <xsl:template match="//time">
        <span>
            <xsl:attribute name="class"><xsl:value-of select="concat(@class,' date-time-lozenge')"/></xsl:attribute>
            <span>
                <img>
                    <xsl:attribute name="src">cid:inline-task-calendar-icon</xsl:attribute>
                    <xsl:attribute name="class">inline-task-calendar-icon</xsl:attribute>
                    <xsl:attribute name="width">16</xsl:attribute>
                    <xsl:attribute name="height">16</xsl:attribute>
                    <xsl:attribute name="alt">calendar icon</xsl:attribute>
                </img>
            </span>
            <xsl:apply-templates select="node()"/>
        </span>
    </xsl:template>

    <xsl:template match="//a[contains(@class,'user-mention')]">
        <span>
            <xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute>
            <span><xsl:attribute name="style">color: #999; font-size: 12px; line-height: 16px; mso-line-height-rule: exactly; padding-right:2px; vertical-align:top; mso-text-raise:3px;</xsl:attribute>@</span>
            <a>
                <xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute>
                <xsl:value-of select="."/>
            </a>
        </span>
    </xsl:template>

<!-- table styles for wiki content -->
    <xsl:template match="//table[contains(@class,'confluenceTable')]">
        <table>
            <xsl:copy-of select="@*"/>
            <xsl:attribute name="style">border-collapse: collapse; border: 1px solid #ddd;</xsl:attribute>
            <xsl:apply-templates select="node()"/>
        </table>
    </xsl:template>

    <xsl:template match="//td[contains(@class,'confluenceTd')]">
        <td>
            <xsl:copy-of select="@*"/>
            <xsl:attribute name="style">
                <xsl:value-of select="concat('border: 1px solid #DDD; padding: 5px 7px; min-width: 0.6em; text-align: left; vertical-align: top;', @style)"/>
                <xsl:if test="contains(@class,'highlight')">
                    <xsl:text>background-color: #F0F0F0; font-weight: bold;</xsl:text>
                </xsl:if>
            </xsl:attribute>
            <xsl:apply-templates select="node()"/>
        </td>
    </xsl:template>

    <xsl:template match="th[contains(@class,'confluenceTh')]">
        <th>
            <xsl:copy-of select="@*"/>
            <xsl:attribute name="style">
                <xsl:value-of select="concat('border: 1px solid #DDD; padding: 5px 7px; min-width: 0.6em; text-align: left; vertical-align: top;', @style)"/>
                <xsl:text>background-color: #F0F0F0; font-weight: bold;</xsl:text>
            </xsl:attribute>
            <xsl:apply-templates select="node()"/>
        </th>
    </xsl:template>


<!-- Inline the styles for textual diffs -->
    <xsl:template match="span[contains(@class, 'diff-html-changed')]">
    <span>
      <xsl:copy-of select="@*"/>
      <xsl:attribute name="style">background-color: <xsl:value-of select="$diffChangedBackgroundColor"/>;</xsl:attribute>
      <xsl:apply-templates select="node()"/>
    </span>
    </xsl:template>

    <xsl:template match="span[contains(@class, 'diff-html-added')]">
    <span>
      <xsl:copy-of select="@*"/>
      <xsl:attribute name="style">font-size: 100%; background-color: <xsl:value-of select="$diffAddedBackgroundColor"/>;</xsl:attribute>
      <xsl:apply-templates select="node()"/>
    </span>
    </xsl:template>

    <xsl:template match="span[contains(@class, 'diff-html-removed')]">
    <span>
      <xsl:copy-of select="@*"/>
      <xsl:attribute name="style">font-size: 100%; background-color: <xsl:value-of select="$diffRemovedBackgroundColor"/>; text-decoration: line-through;</xsl:attribute>
      <xsl:apply-templates select="node()"/>
    </span>
    </xsl:template>


<!-- Inline the styles for diff macro tables -->
    <xsl:template match="table[contains(@class, 'diff-macro')]">
        <table>
            <xsl:copy-of select="@*"/>
            <xsl:attribute name="style">
                <xsl:value-of select="@style"/>
                <xsl:text>background-color: </xsl:text><xsl:value-of select="$diffMacroPanelBackgroundColor"/><xsl:text>;</xsl:text>
                <xsl:text>border: 1px solid </xsl:text><xsl:value-of select="$diffMacroPanelBorderColor"/><xsl:text>;</xsl:text>
                <xsl:text>margin: 10px 1px;</xsl:text>
                <xsl:text>padding: 0 2px 2px;</xsl:text>
                <xsl:text>width: 100%;</xsl:text>
                <xsl:if test="contains(@class, 'bodyless')">
                    <xsl:text>margin: 5px 0; padding: 0; width: auto;</xsl:text>
                </xsl:if>
                <xsl:if test="contains(@class, 'diff-html-added')">
                    <xsl:text>background-color: </xsl:text><xsl:value-of select="$diffAddedBackgroundColor"/><xsl:text>;</xsl:text>
                    <xsl:text>border-color: </xsl:text><xsl:value-of select="$diffAddedBorderColor"/><xsl:text>;</xsl:text>
                </xsl:if>
                <xsl:if test="contains(@class, 'diff-html-removed')">
                    <xsl:text>background-color: </xsl:text><xsl:value-of select="$diffRemovedBackgroundColor"/><xsl:text>;</xsl:text>
                    <xsl:text>border-color: </xsl:text><xsl:value-of select="$diffRemovedBorderColor"/><xsl:text>;</xsl:text>
                </xsl:if>
            </xsl:attribute>
            <xsl:apply-templates select="node()"/>
        </table>
    </xsl:template>

    <xsl:template match="table[contains(@class, 'diff-macro')]//th">
        <th>
            <xsl:copy-of select="@*"/>
            <xsl:attribute name="style">
                <xsl:value-of select="@style"/>
                <xsl:text>background-color: transparent; text-align: left; font-weight: normal;</xsl:text>
                <xsl:if test="contains(@class, 'diff-macro-title')">
                    <xsl:text>padding: 5px;</xsl:text>
                    <xsl:if test="contains(@class, 'macro-placeholder-icon')">
                        <xsl:text>margin-right: 0.5em; width: 20px;</xsl:text>
                    </xsl:if>
                </xsl:if>
            </xsl:attribute>
            <xsl:apply-templates select="node()"/>
        </th>
    </xsl:template>

    <xsl:template match="table//span[contains(@class, 'macro-placeholder-icon')]">
        <xsl:variable name="oldStyle" select="@style"/>
        <xsl:variable name="imageUrlStart" select="substring-after($oldStyle, 'background-image: url(')"/>
        <xsl:variable name="imageUrl" select="substring-before($imageUrlStart,');')"/>

        <span>
            <xsl:copy-of select="@*"/>
            <xsl:attribute name='style'>
                <xsl:text>background-color: </xsl:text>
                <xsl:if test="contains(@class, 'diff-html-added')"><xsl:value-of select="$diffAddedBackgroundColor"/></xsl:if>
                <xsl:if test="contains(@class, 'diff-html-removed')"><xsl:value-of select="$diffRemovedBackgroundColor"/></xsl:if>
                <xsl:if test="contains(@class, 'diff-html-changed')"><xsl:value-of select="$diffChangedBackgroundColor"/></xsl:if>
                <xsl:text>;</xsl:text>

                <xsl:text>line-height: 20px;</xsl:text>
            </xsl:attribute>
            <img>
                <xsl:attribute name="src"><xsl:value-of select="$imageUrl"/></xsl:attribute>
                <xsl:attribute name='style'>padding-right: 5px; vertical-align: text-bottom;</xsl:attribute>
            </img>
            <xsl:apply-templates select="node()"/>
        </span>
    </xsl:template>


    <xsl:template match="td[contains(@class, 'diff-macro-body')]">
        <td>
            <xsl:copy-of select="@*"/>
            <xsl:attribute name="style">background-color: #fff;border: 1px solid <xsl:value-of select="$diffMacroPanelBorderColor"/>;padding: 10px;</xsl:attribute>
            <xsl:apply-templates select="node()"/>
        </td>
    </xsl:template>

    <!-- selects all table cell elements (th or td) that are children of a td that has the diff-macro-properties class. -->
    <xsl:template match="td[ancestor-or-self::td[contains(@class, 'diff-macro-properties')]]|th[ancestor-or-self::td[contains(@class, 'diff-macro-properties')]]">
        <xsl:variable name="wrapper-css">padding: 0; border: 1px solid <xsl:value-of select="$diffMacroPanelBorderColor"/>;</xsl:variable>
        <td>
            <xsl:copy-of select="@*"/>
            <xsl:attribute name="style">background-color: <xsl:value-of select="$diffMacroPanelLightBackgroundColor"/>; padding: 0 0 0 5px; font-size: 12px; text-align: left;<xsl:if test="contains(@class, 'diff-macro-properties')"><xsl:value-of select="$wrapper-css"/></xsl:if></xsl:attribute>
            <xsl:apply-templates select="node()"/>
        </td>
    </xsl:template>


<!-- Image diff styles -->
    <xsl:template match="span[contains(@class, 'diff-html-image-container')]">
        <span>
            <xsl:copy-of select="@*"/>
            <xsl:attribute name="style">
                <xsl:text>background-color: </xsl:text>
                <xsl:if test="contains(@class, 'diff-html-added')"><xsl:value-of select="$diffAddedBackgroundColor"/></xsl:if>
                <xsl:if test="contains(@class, 'diff-html-removed')"><xsl:value-of select="$diffRemovedBackgroundColor"/></xsl:if>
                <xsl:if test="contains(@class, 'diff-html-changed')"><xsl:value-of select="$diffChangedBackgroundColor"/></xsl:if>
                <xsl:text>;</xsl:text>
                <xsl:text>display: inline-block;</xsl:text>
                <xsl:text>position: relative;</xsl:text>
                <xsl:text>text-align: center;</xsl:text>
            </xsl:attribute>
            <xsl:apply-templates select="node()"/>
        </span>
    </xsl:template>

    <xsl:template match="span[contains(@class, 'diff-image-overlay')]">
        <span>
            <xsl:copy-of select="@*"/>
            <xsl:attribute name="style">
                <xsl:value-of select="@style"/>
                <xsl:text>color: </xsl:text><xsl:value-of select="$diffImageOverlayColor"/><xsl:text>;</xsl:text>
                <xsl:text>display: block;</xsl:text>
                <xsl:text>padding: 4px 4px 8px 4px;</xsl:text>
                <xsl:text>text-decoration: none;</xsl:text>
            </xsl:attribute>
            <xsl:apply-templates select="node()"/>
        </span>
    </xsl:template>

    <xsl:template match="div[contains(@class, 'columnLayout')]">
        <table width="100%">
            <tr>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="node()" />
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="div[contains(@class, 'cell')]">
        <td valign="top">
            <xsl:if test="contains(@class, 'aside')">
                <xsl:attribute name="width">
                    <xsl:text>30%</xsl:text>
                </xsl:attribute>
            </xsl:if>
            <xsl:if test="contains(@class, 'sidebars')">
                <xsl:attribute name="width">
                    <xsl:text>20%</xsl:text>
                </xsl:attribute>
            </xsl:if>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="node()" />
        </td>
    </xsl:template>
</xsl:stylesheet>
