require(['ajs', 'jquery', 'wrm/require'], function (AJS, $, WrmRequire) {
    'use strict';

    function load() {
        WrmRequire(['wrc!com.atlassian.confluence.plugins.drag-and-drop:editor-drop-handler']).then(function () {
            require(['confluence-drag-and-drop/editor-drop-handler'], function (dnd) {
                // We initialise the feature right away in order to provide drag&drop AND make
                // the `Confluence.Uploader` available for the editor paste handler.
                // Although this is no longer the case, I am retaining the bellow comment because it worries me:
                // We actually need to initialise lazily. Otherwise, there's some kind of awkward event clobbering
                // going on that actually stops this handler's events from ever getting called :(
                dnd.initialiseOverlay();
                dnd.initialise();
            });
        });
    }

    // Wait until other more important things happen, then "preload" the dnd behaviour.
    AJS.Rte.BootstrapManager.addOnInitCallback(load);
});
