/* global Promise */
require(['ajs', 'jquery', 'window', 'wrm/require'], function (AJS, $, window, WrmRequire) {
    'use strict';

    function getDragAndDrop() {
        return new Promise(function (resolve, reject) {
            WrmRequire('wrc!com.atlassian.confluence.plugins.drag-and-drop:default-drop-handler').then(function () {
                resolve(require('confluence-drag-and-drop/default-drop-handler'));
            }, reject);
        });
    }

    function loadAndInitDropZoneStylingBehaviour() {
        getDragAndDrop().then(function (dnd) {
            var $extensionContainer = $('#extension-container');
            if ($extensionContainer.length) {
                var $dropZone = $(AJS.DragAndDrop.Templates.dropZone());
                $extensionContainer.append($dropZone);

                AJS.DragAndDropUtils.bindDragEnter($dropZone[0], function () {
                    $dropZone.addClass('drop-zone-on-hover');
                });
                AJS.DragAndDropUtils.bindDragOver($dropZone[0], function () {
                    $dropZone.addClass('drop-zone-on-hover');
                });
                AJS.DragAndDropUtils.bindDragLeave($dropZone[0], function () {
                    $dropZone.removeClass('drop-zone-on-hover');
                });
            }

            dnd.initialise();
        });
    }

    // Wait until other more important things happen.
    $(window).one('load', loadAndInitDropZoneStylingBehaviour);
});
