/* global Promise */
/**
 * Initialises the drag and drop behaviour for viewpage.
 *
 * We lazy-load the actual implementation since drag and drop support isn't on the critical render path.
 *
 * Initialisation of the module will happen on dragenter to defer the cost until it is needed.
 *
 * @link https://jira.atlassian.com/browse/CONFDEV-33316
 * @link https://ecosystem.atlassian.net/browse/SPFE-182
 */
require(['jquery', 'window', 'wrm/require'], function ($, window, WrmRequire) {
    'use strict';

    function getDragAndDrop() {
        return new Promise(function (resolve, reject) {
            WrmRequire('wrc!com.atlassian.confluence.plugins.drag-and-drop:default-drop-handler').then(function () {
                resolve(require('confluence-drag-and-drop/default-drop-handler'));
            }, reject);
        });
    }

    function initFunction() {
        getDragAndDrop().then(function (dnd) {
            dnd.initialise();
        });
    }

    // Initialise behaviours just-in-time.
    $(document).one('dragenter', initFunction);
    // Wait until other more important things happen, then "preload" the dnd behaviour.
    $(window).one('load', getDragAndDrop);
});
