/**
 * @module confluence-macro-browser/macro-browser-cql
 */
define('confluence-macro-browser/macro-browser-cql',
    [
        'ajs',
        'underscore',
        'confluence/templates',
        'confluence-ui-components/js/cql/cql-component',
        'jquery'
    ],
    /**
 * Defines the behaviour of the common CQL Component in the Macro Browser.
 *
 * This module is a stub, created to facilitate moving the CQL-specific code out of macro-browser-editor, and for
 * writing unit tests.
 */
    function(
        AJS,
        _,
        Templates,
        CQLComponent,
        $
    ) {
        'use strict';

        // Builds a new cql-component instance from macro-browser-specfic options.
        function _makeCqlComponentOptions(options) {
            var cqlParam = options.param;

            return $.extend({}, options, cqlParam.options, {
            // TODO post-CRA-657 cqlParam.options.defaultValue is currently only used in ui-components and masterdetails
            // plugins. Those plugins have been updated to use cqlParam.defaultValue, so once they've both been released
            // and bumped, the || clause here can be safely deleted. dT
                defaultValue: cqlParam.defaultValue || cqlParam.options.defaultValue,
                select2CustomOptions: options.cqlSelect2CustomOptions
            });
        }

        function buildCqlComponent(options) {
            var cqlOptions = _makeCqlComponentOptions(options);

            return CQLComponent.build(cqlOptions);
        }

        function _renderCqlSections(options) {
            var hasRenderParameters = options.renderParams.length > 0;
            return $(Templates.MacroBrowser.CQL.sections({
                hasRenderParameters: hasRenderParameters
            }));
        }

        /**
     * Returns a CQL Component wrapped for use in the Macro Browser and embedded in the passed container.
     *
     * @param options containing:
     *            - cqlParam: the configuration of the CQL parameter itself, determines behaviour of the CQL component
     *            - renderParams: the non-CQL parameters for this macro, used to determine form layout
     *            - container: the element that the CQL macro form sections will be appended to
     *            - cqlValue: the value of the CQL parameter in an existing macro
     *            - flagRequiredParam: a dirty hack to avoid having to make this function public in a common module.
     *            - paramChanged: required for change callbacks
     */
        function build(options) {
            // WARNING: This function could still use some cleanup but has been moved from macro-browser-editor
            // pretty-much "as is" to simplify that module.

            var cqlSections = _renderCqlSections(options);
            var container = options.container;
            container.append(cqlSections);

            // Make CQL fields look like Macro Browser fields - these bindings run as new fields are added.
            container.bind('cql-field-adding', function(e, fieldComponent) {
                fieldComponent.element.addClass('macro-param-div');
                fieldComponent.element.find('.cql-field-input').addClass('macro-param-input');
            });

            // Flag the param form as loading so that previews will abort.
            container.addClass('loading');

            // Expand/collapse Display Options section
            cqlSections.filter('.cql-render-heading').find('button').click(function() {
                var $this = $(this);
                var $section = $this.closest('.cql-render-heading').next();
                var wasVisible = $section.is(':visible');

                if (wasVisible) {
                    $section.slideUp(300);
                } else {
                    $section.removeClass('hidden').show(); // we start with a hidden class, but slideUp/show work with display style.
                    var headingTop = $('.cql-render-heading').position().top;
                    $('.macro-input-fields').animate({ scrollTop: headingTop }, 300);
                }

                var buttonText = wasVisible ? AJS.I18n.getText('macro.browser.editor.cql.section.options.show')
                    : AJS.I18n.getText('macro.browser.editor.cql.section.options.hide');
                $this.text(buttonText);
            });

            var cqlComponent = buildCqlComponent({
                param: options.cqlParam,
                value: options.cqlValue,
                container: cqlSections.filter('.cql-filter-fields'),
                cqlSelect2CustomOptions: options.cqlSelect2CustomOptions
            });

            // Store a ref to the component for use when retrieving the CQL value.
            container.data('cqlComponent', cqlComponent);

            var loading = $.Deferred();

            cqlComponent.loading.done(function() {
            /*
             Required fields are ones that must be filled for the component to work in its context; they are not able
             to be removed as other search filters are.

             e.g. in content-by-label macro
             <option key="requiredFields" value="labels"/>
             */
                var requiredFieldsStr = options.cqlParam.options.requiredFields;
                if (requiredFieldsStr) {
                    var requiredFieldNames = requiredFieldsStr.split(',');
                    var fieldRegistry = cqlComponent.fieldRegistry || cqlComponent.fieldArrays;
                    _.each(fieldRegistry, function(fieldArr) {
                        var fieldAlreadyFlagged = false;
                        _.each(fieldArr, function(field) {
                            if (fieldAlreadyFlagged || !_.contains(requiredFieldNames, field.fieldName)) {
                                return;
                            }

                            options.flagRequiredParam(field.element);

                            // Only flag the first instance of a param field as required - any further ones must be
                            // user-added and must be user-removable.
                            fieldAlreadyFlagged = true;

                            // The UI component code knows when it changes - we may need to differentiate between keypresses
                            // and focus-based changes.
                            field.onChange(options.paramChanged);
                        });
                    });
                }
                container.removeClass('loading');
                loading.resolve();
            });

            return {
                elements: cqlSections,
                loading: loading
            };
        }

        return {

            build: build,

            // Exposed for unit-testing
            _makeCqlComponentOptions: _makeCqlComponentOptions,
            _renderCqlSections: _renderCqlSections
        };
    });
