/**
 * @module confluence-macro-browser/macro-browser-preload
 */
define('confluence-macro-browser/macro-browser-preload', [
    'jquery',
    'ajs',
    'window'
],
function(
    $,
    AJS,
    window
) {
    'use strict';

    return {
        macroBrowserPreload: function() {
            // bind the function to be run when the macro browser preview frame is loaded
            $(window).bind('render-content-loaded', function(e, body) {
                var iframe = $('#macro-preview-iframe');
                if (iframe.contents().find('body')[0] == body) {
                    AJS.MacroBrowser.previewOnload(body);
                }
            });

            AJS.MacroBrowser.preLoadMacro();
        }
    };
});

require('confluence/module-exporter').safeRequire('confluence-macro-browser/macro-browser-preload', function(MacroBrowserPreload) {
    'use strict';

    var AJS = require('ajs');

    AJS.toInit(MacroBrowserPreload.macroBrowserPreload);
});
