// This module depends on the "com.atlassian.auiplugin:aui-select2" but this web-resource doesn't provide the AMD module
define('jira-integration-plugin/label-picker', [], function () {
    var templates = window.jiraIntegration.templates;

    var build = function ($labelsField, getDataFunction) {
        $labelsField.auiSelect2({
            tags: true,
            multiple: true,
            tokenSeparators: [',', ' '],
            createSearchChoice: function (term) {
                if (!term) {
                    return null;
                }
                return {
                    id: term,
                    text: term,
                    isNew: true,
                };
            },
            query: function (query) {
                var onGetDataSuccess = function (datas) {
                    query.callback({results: datas});
                };
                getDataFunction(query.term).done(onGetDataSuccess);
            },
            formatResult: function (result) {
                return templates.fields.labelFieldResult({
                    label: {
                        labelName: result.text,
                        isNew: result.isNew,
                    },
                });
            },
            initSelection: function (elem, callback) {
                var labels = $labelsField.auiSelect2('val').map(function (value) {
                    return {
                        id: value,
                        text: value,
                    };
                });
                callback(labels);
            },
        });
    };

    return {
        build: build,
    };
});
