document.addEventListener('DOMContentLoaded', function () {
    var customRadio = document.getElementById('configure-password-policy-preset-CUSTOM');
    var presetRadio = document.getElementById('preset-radio');
    var customForm = document.getElementById('custom-policy-form');
    const passwordPolicyForm = document.getElementById('configure-password-policy');

    presetRadio.addEventListener('change', function () {
        if (customRadio.checked) {
            customForm.style.display = 'block';
        } else {
            customForm.style.display = 'none';
        }
    });

    if (customRadio.checked) {
        customForm.style.display = 'block';
    } else {
        customForm.style.display = 'none';
    }

    if (passwordPolicyForm) {
        passwordPolicyForm.addEventListener('submit', function (event) {
            if (!validateForm()) {
                event.preventDefault(); // Prevents the form submission
            }
        })
    }
});

function validateForm() {
    var customRadio = document.getElementById('configure-password-policy-preset-CUSTOM');

    if (!customRadio.checked) {
        return true;
    }

    var integerInputAndErrorFields = new Map();

    integerInputAndErrorFields.set(document.getElementById('configure-password-policy-minimumLength'),
        document.getElementById('configure-password-policy-minimumLength-error'));
    integerInputAndErrorFields.set(document.getElementById('configure-password-policy-minimumLowercase'),
        document.getElementById('configure-password-policy-minimumLowercase-error'));
    integerInputAndErrorFields.set(document.getElementById('configure-password-policy-minimumUppercase'),
        document.getElementById('configure-password-policy-minimumUppercase-error'));
    integerInputAndErrorFields.set(document.getElementById('configure-password-policy-minimumDigits'),
        document.getElementById('configure-password-policy-minimumDigits-error'));
    integerInputAndErrorFields.set(document.getElementById('configure-password-policy-minimumSpecialCharacters'),
        document.getElementById('configure-password-policy-minimumSpecialCharacters-error'));

    var submitFlag = true;
    var ruleCount = 0;

    integerInputAndErrorFields.forEach(function (errorField, inputField) {
        var inputValue = inputField.value;
        if (inputValue.trim() === '') {
            errorField.style.display = 'none';
        } else if (!isNumericStringLargerThanZero(inputValue)) {
            errorField.style.display = 'block';
            submitFlag = false;
        } else {
            errorField.style.display = 'none';
            if (inputField !== document.getElementById('configure-password-policy-minimumLength')) {
                ruleCount++;
            }
        }
    });

    var minimumRulesMatchedInputField = document.getElementById('configure-password-policy-minimumRulesMatched');
    var minimumRulesMatchedErrorField = document.getElementById('configure-password-policy-minimumRulesMatched-error');

    if (parseInt(minimumRulesMatchedInputField.value) > ruleCount) {
        submitFlag = false;
        minimumRulesMatchedErrorField.style.display = 'block';
    } else {
        minimumRulesMatchedErrorField.style.display = 'none';
    }

    return submitFlag;
}

function isNumericStringLargerThanZero(str) {
    return /^[0-9]+$/.test(str) && parseInt(str) > 0;
}
