/* Custom scripts for User sync preview */
AJS.$(function () {
    var $ = require('jquery');
    var auiDialog2 = require('aui/dialog2');

    var $dialog = $('#users-sync-preview-dialog');
    var dialogSectionIsPresent = $dialog.length;

    if(!dialogSectionIsPresent) {
        return;
    }

    var dialog = auiDialog2($dialog);
    var $usersPreviewFilter = $("#usersPreviewFilter");
    var $filterBtn = $("#user-sync-preview-filter-btn");
    var elements = {
        result: $("#preview-result"),
        pages: $("#pages"),
        error: $("#preview-error"),
        progress: $("#progress")
    };

    var totalUsersCount;

    function loadUsers(filter, pageNumber) {
        showOnlyElements(elements.progress);
        var requestBody = composeRequestBody(filter, pageNumber);
        $.ajax({
            type: "POST",
            url: $("#user-sync-preview-url").val(),
            contentType:"application/json; charset=utf-8",
            dataType:"json",
            data: JSON.stringify(requestBody),
            timeout: 60000
        }).
        done(function (response) {
            totalUsersCount = response.totalUsersCount;
            renderUserCountSubtitle(response.usersCountSubtitle);
            renderUserList(response.users);
            renderPageLinks(response.pageLinks);
            showOnlyElements(elements.result, elements.pages);
        }).
        fail(function (error) {
            totalUsersCount = undefined;
            renderError(error);
            showOnlyElements(elements.error);
        });
    }

    function showOnlyElements() {
        elements.result.hide();
        elements.pages.hide();
        elements.error.hide();
        elements.progress.hide();
        $.each(arguments, function (i, element) {
            element.show();
        });
    }

    function composeRequestBody(filter, pageNumber) {
        var formId = $("#user-sync-preview-form-id").val();
        var formArray = $(formId).serializeArray();
        var directoryConfiguration = {};
        $.each(formArray, function(i, field) {
            directoryConfiguration[field.name] = field.value;
        });
        var requestBody = {'directoryConfiguration':directoryConfiguration};
        if(filter) {
            requestBody.filter = filter;
        }
        if(pageNumber) {
            requestBody.pageNumber = pageNumber;
        }
        if(totalUsersCount) {
            requestBody.totalUsersCount  = totalUsersCount;
        }

        return requestBody;
    }

    function renderUserCountSubtitle(subtitle) {
        $("#user-count-text").html(subtitle);
    }

    function renderUserList(userList) {
        var template = Crowd.Templates.Soy.userListTable({'userList':userList});
        $("#user-preview-table tbody").empty().append(template);
    }

    function renderPageLinks(pageLinkList) {
        var template = Crowd.Templates.Soy.pageLinks({'pageLinkList':pageLinkList});
        console.log("render pages");
        elements.pages.empty().append(template);
    }

    function renderError(error) {
        var template = Crowd.Templates.Soy.previewError({'error':error});
        $("#users-sync-preview-error-message").html(template);
    }

    $('#user-sync-preview-open-dialog').click(
        function(event) {
            event.preventDefault();
            dialog.show();
        }
    );
    dialog.on("show",
        function() {
            loadUsers();
        }
    );
    dialog.on("hide",
        function() {
            $usersPreviewFilter.val("");
            $(".aui-message.aui-message-success").hide();
        }
    );
    $usersPreviewFilter.change(function () {
        totalUsersCount = undefined;
    });
    $filterBtn.click(
        function (event) {
            event.preventDefault();
            var filter = $usersPreviewFilter.val();
            loadUsers(filter);
        }
    );
    elements.pages.on("click", "a.page-link",
        function(event) {
            event.preventDefault();
            var filter = $usersPreviewFilter.val();
            var pageNumber = $(this).attr('data-pagenumber');
            loadUsers(filter, pageNumber);
        }
    );

});