/**
 * @module define('office-connector/edit-in-office-plugin'
 */
define('confluence-email-gateway/admin-email-gateway', [
    'jquery'
], function(
    $
) {
    'use strict';

    return function() {
        var $allowToCreatePageByEmail = $('#allowToCreatePageByEmail');
        var $allowToCreateCommentByEmail = $('#allowToCreateCommentByEmail');
        var $saveButton = $('#email-gateway-save-button');
        var $cancelButton = $('#email-gateway-cancel-button');

        function activeForm() {
            $saveButton.enable();
            $cancelButton.show();
        }

        $allowToCreatePageByEmail.click(function() {
            activeForm();
        });

        $allowToCreateCommentByEmail.click(function() {
            activeForm();
        });

        $('input[name="selectedMailServerId"]').change(function() {
            activeForm();
        });
    };
});

require('confluence/module-exporter').safeRequire('confluence-email-gateway/admin-email-gateway', function(AdminEmailGateway) {
    'use strict';

    var AJS = require('ajs');

    AJS.toInit(AdminEmailGateway);
});
