/* eslint-disable valid-jsdoc */
/**
 * Utility functions for working with the Documentation Theme
 * TO DO: This needs to live somewhere else, maybe the Confluence Core JS library
 */

function getDocThemeContentElement() {
    return $('#splitter-content');
}

function isDocTheme() {
    return !!getDocThemeContentElement().length;
}

function appendAbsolutePositionedElement(node) {
    const $node = $(node);
    $(node).appendTo(isDocTheme() ? getDocThemeContentElement() : $('body'));
    return $node;
}

function getMainContentScrollTop() {
    return isDocTheme() ? getDocThemeContentElement().scrollTop() : $(document).scrollTop();
}

function getMainContentScrollLeft() {
    return isDocTheme() ? getDocThemeContentElement().scrollLeft() : $(document).scrollLeft();
}

Confluence.DocThemeUtils = {
    isDocTheme,
    appendAbsolutePositionedElement,
    getMainContentScrollTop,
    getMainContentScrollLeft,
    getDocThemeContentElement,
};
