/* eslint-disable no-unused-expressions */
/* eslint-disable func-names */
/*
 * Object for registering actions in the highlighted text property panel
 */

// dictionary of all event handlers registered
const handlers = {};
let $mainContent;

// Provide Three default behavior, this will be assign to shouldDisplay method
// which will be call to validate when will the button of plugin will be shown/hidden
const WORKING_AREA = {
    MAINCONTENT_AND_COMMENT(selectionRange) {
        return Confluence.HighlightAction.RangeHelper.isSelectionInsideContent($('.wiki-content'), selectionRange);
    },

    MAINCONTENT_ONLY(selectionRange) {
        // Since the main content is static we do not need to perform the jquery selection again. This is unlike comments which
        // can be loaded via AJAX
        $mainContent = $mainContent || $('.wiki-content').first();
        return Confluence.HighlightAction.RangeHelper.isSelectionInsideContent($mainContent, selectionRange);
    },

    COMMENT_ONLY(selectionRange) {
        return Confluence.HighlightAction.RangeHelper.isSelectionInsideContent($('.comment-content'), selectionRange);
    },
};

/*
 * Get last fetch time of current page.
 * */
function getLastFetchTime() {
    return $("meta[name='confluence-request-time']").attr('content');
}

function createBaseBean(searchText) {
    const insertionBean = {};
    insertionBean.pageId = searchText.pageId;
    insertionBean.selectedText = searchText.selectedText;
    insertionBean.index = searchText.index;
    insertionBean.numMatches = searchText.numMatches;
    insertionBean.lastFetchTime = getLastFetchTime();
    return insertionBean;
}

/*
 * PUBLIC Registers a callback for a specific plugin key
 *
 * @param key plugin specific key to register a callback with (eg. com.atlassian.confluence.plugins.confluence-highlight-actions:quote-comment)
 * @param config option object {onClick} register with the associated key
 */
function registerButtonHandler(key, option) {
    const defaultOption = {
        onClick() {},

        // Return FALSE to prevent this plugin's button show on Action Panel
        // if plugin doesn't provide shouldDisplay method, as default it will able to work on Main Content and Comment Area
        shouldDisplay: WORKING_AREA.MAINCONTENT_AND_COMMENT,
    };
    handlers[key] = $.extend(defaultOption, option);
}

/*
 * PUBLIC Retrieves handler associated with specific plugin key
 *
 * @param key the key for the handler
 * @return the callback associated with the key
 */
function getButtonHandler(key) {
    let callback = handlers[key];
    if (!callback) {
        callback = function () {
            AJS.logError(`The button with key ${key} doesn't have a registered handler`);
        };
    }
    return callback;
}

/*
 * PUBLIC Inserts an XML fragment at the end of the current selection
 *
 * @param searchTextObject metadata about the text selection and its position in the page
 * @param insertion the XML fragment to insert in the text
 * @return ajax function
 */
function insertContentAtSelectionEnd(insertionBean) {
    const restUrl = `${Confluence.getContextPath()}/rest/highlighting/1.0/insert-storage-fragment`;
    return $.ajax({
        type: 'POST',
        contentType: 'application/json',
        url: restUrl,
        data: JSON.stringify(insertionBean),
    });
}

/*
 * PUBLIC Inserts XML fragments at the end of the table's cells
 *
 * @param tableInsertionBean metadata about:
 *                  the text selection: pageId, numMatches, index, selectedText
 *                  tableColumnIndex: the column index need update in the table
 *                  cellXmlInsertionBeans: list of xml fragment with rowIndex using for update cells
 * @return ajax function
 */
function insertContentsInTableColumnCells(tableInsertionBean) {
    const restUrl = `${Confluence.getContextPath()}/rest/highlighting/1.0/insert-storage-column-table`;
    return $.ajax({
        type: 'POST',
        contentType: 'application/json',
        url: restUrl,
        data: JSON.stringify(tableInsertionBean),
    });
}

/*
 * PUBLIC Create tableInsertionBean object use for call
 * insert XML fragments the end of the table's cells
 *
 * @param cellXmlInsertions list of xml fragment with rowIndex using for update cells
 * @param tableColumnIndex the column index need update in the table
 * @param searchText the text selection object received from select text with:
 *                                      pageId, numMatches, index, selectedText
 */
function createTableInsertionBean(cellXmlInsertions, tableColumnIndex, searchText) {
    const tableInsertionBean = createBaseBean(searchText);
    tableInsertionBean.tableColumnIndex = tableColumnIndex;
    tableInsertionBean.cellModifications = cellXmlInsertions;
    return tableInsertionBean;
}

/*
 * DEPRECATED use createXMLModificationBean
 *
 * PUBLIC Create insertionBean object use for call
 * insert XML fragments the end of the table's cells
 *
 * @param xmlModification xml fragment
 * @param searchText the text selection object received from select text with:
 *                                      pageId, numMatches, index, selectedText
 */
function createInsertionBean(cellXmlInsertions, searchText) {
    const insertionBean = createBaseBean(searchText);
    insertionBean.xmlModification = cellXmlInsertions[0].xmlInsertion;
    return insertionBean;
}

/*
 * PUBLIC Create insertionBean object use for call
 * insert XML fragments the end of the table's cells
 *
 * @param xmlModification xml fragment
 * @param searchText the text selection object received from select text with:
 *                                      pageId, numMatches, index, selectedText
 */
function createXMLModificationBean(xml, searchText) {
    const insertionBean = createBaseBean(searchText);
    insertionBean.xmlModification = xml;
    return insertionBean;
}

/*
 * PUBLIC Removes the current mouse highlight from the page
 */
function clearTextSelection() {
    window.getSelection().removeAllRanges();
}

Confluence.HighlightAction = {
    registerButtonHandler,
    getButtonHandler,
    insertContentAtSelectionEnd,
    insertContentsInTableColumnCells,
    createTableInsertionBean,
    createInsertionBean,
    createXMLModificationBean,
    clearTextSelection,
    WORKING_AREA,
};
