/* eslint-disable valid-jsdoc */
/* eslint-disable eqeqeq */
/* eslint-disable func-names */
AJS.toInit(($) => {
    const ACTION_PANEL_CLASS_NAME = 'selection-action-panel';

    // Usable area for the plugin. #main-content was another candidate, but does not appear on all pages
    // We only support on main content
    const $wikiContent = $('.wiki-content').first();

    // pushpin object to mark locations where property panel should open
    const $actionDialogTarget = $('<div>').attr('id', 'action-dialog-target');

    // inline dialog containing highlight action buttons
    let actionPanel;

    let selectionRange;

    let curRects;

    /*
     * Provides event handlers that close the dialog on an external click if no text is selected on the page
     */
    function getPanelEventHandlers() {
        // Be defensive and make sure that we haven't already bound the event
        let hasBoundOnExternalClick = false;
        const externalClickNamespace = `${ACTION_PANEL_CLASS_NAME}.inline-dialog-check`;

        /**
         * Catch click events on the body to see if the click target occurs outside of this popup
         * If it does, the popup will be hidden
         */
        const bindHideOnExternalClick = function () {
            if (!hasBoundOnExternalClick) {
                $('body').bind(`click.${externalClickNamespace}`, (e) => {
                    const $target = $(e.target);
                    // hide the popup if the target of the event is not in the dialog
                    if ($target.closest(`#inline-dialog-${ACTION_PANEL_CLASS_NAME} .contents`).length === 0) {
                        if (!selectionRange) {
                            actionPanel.hide();
                        }
                    }
                });
                hasBoundOnExternalClick = true;
            }
        };

        const unbindHideOnExternalClick = function () {
            if (hasBoundOnExternalClick) {
                $('body').unbind(`click.${externalClickNamespace}`);
            }
            hasBoundOnExternalClick = false;
        };

        const onKeydown = function (e) {
            if (e.key === 'Escape') {
                actionPanel.hide();
            }
        };

        const bindHideOnEscPressed = function () {
            $(document).on('keydown', onKeydown);
        };

        const unbindHideOnEscPressed = function () {
            $(document).off('keydown', onKeydown);
        };

        const bindHideEvents = function () {
            bindHideOnExternalClick();
            bindHideOnEscPressed();
        };

        const unbindHideEvents = function () {
            unbindHideOnExternalClick();
            unbindHideOnEscPressed();
        };

        return {
            bindHideEvents,
            unbindHideEvents,
        };
    }

    function setPanelUnselectable($panelContent) {
        // prevent dragging event
        $panelContent.children().on('selectstart', false);
    }

    /*
     * Renders the property panel
     *
     * @param data JSON representation of registered highlight actions
     */
    function createPropertyPanel(data) {
        const ICON_BUTTON_WIDTH = 29;
        const dialogEventHandlers = getPanelEventHandlers();
        // width of each button in the property panel
        // CONFDEV-19613: On new version, they add one more pixel as margin-right, increase this variable one more pixel to fix icon wrapped problem, we need to get this dynamic in the future
        const panelContentWidth = data.length * ICON_BUTTON_WIDTH;

        const panelHTML = Confluence.HighlightPanel.Templates.panelContent({
            webItems: data,
        });
        let panelExists = false;

        const generateDialogContent = function (content, trigger, showPopup) {
            if (!panelExists) {
                content.append(panelHTML);
                // apply chunky tooltips for buttons
                content.find('.aui-button').tooltip({ gravity: 's' });
                setPanelUnselectable(content.parent());
                // popup property panel button handler, gathers information about the selection and triggers
                // the registered callback of the button preseed
                content.find('button').click(function () {
                    const key = $(this).attr('data-key');
                    const pluginOption = Confluence.HighlightAction.getButtonHandler(key);
                    actionPanel.hide();
                    const argument = Confluence.HighlightAction.RangeHelper.getRangeOption(selectionRange);
                    if ($.trim(argument.text) !== '') {
                        argument.searchText = Confluence.HighlightAction.RangeHelper.computeSearchTextObject(
                            $wikiContent,
                            selectionRange,
                        );
                    }
                    pluginOption.onClick(argument);
                });
            }
            showPopup();
            panelExists = true;
            return content;
        };

        // This function will be call before an icon button is show up on Action Dialog,
        // it will involve shouldDisplay method of each plugin. if this function return false, icon button will be hidden.
        const onBeforeShow = function (popup) {
            let shouldShowPopup = false;
            popup.find('button').each(function () {
                const $button = $(this);
                const key = $button.attr('data-key');
                const pluginOption = Confluence.HighlightAction.getButtonHandler(key);
                const visible = pluginOption.shouldDisplay(selectionRange);
                $button.css('display', visible ? 'inline-block' : 'none');

                // this buttonVisible variable to determine if there is one button is visible
                shouldShowPopup = shouldShowPopup || visible;
            });
            // what happen if there isn't any button is visible? let hide the dialog
            if (!shouldShowPopup) {
                actionPanel.hide();
            } else {
                // Make sure that the width of dialog is always perfect after show/hide icons
                popup.find('.contents').width('auto');
            }
        };

        const initCallback = function () {
            // Send analytics when highlight popup appears
            Confluence.HighlightAction.Analytics.sendAnalyticsForOpeningHighlightOptionPanel();
            // Some plugins is limit working scope, check to hide before them are shown
            onBeforeShow(this.popup);
            dialogEventHandlers.bindHideEvents();
            $actionDialogTarget.show();
        };

        const hideCallback = function () {
            dialogEventHandlers.unbindHideEvents();
            $actionDialogTarget.hide();
        };

        const dialogOptions = {
            centerOnHighlight: true,
            onTop: true,
            fadeTime: 0,
            width: panelContentWidth,
            persistent: true,

            // Keep the property panel open unless text is deselected or a panel button is clicked
            // return value of true closes the dialog, return value of false stops the dialog from closing
            initCallback,
            hideCallback,
        };

        // eslint-disable-next-line global-require
        let inlineDialog = require('confluence/inline-dialog');
        inlineDialog = inlineDialog.inlineDialog || inlineDialog;
        actionPanel = inlineDialog($actionDialogTarget, ACTION_PANEL_CLASS_NAME, generateDialogContent, dialogOptions);
    }

    /*
     * Positions the dialog target relative to the selection
     *
     * @param the rects defining the selection area
     * @return boolean value indicating whether the selection position has changed
     */
    function positionDialogTarget(selectionRects) {
        Confluence.DocThemeUtils.appendAbsolutePositionedElement($actionDialogTarget);
        let posChanged = false;
        if (
            !curRects ||
            selectionRects.first.top != curRects.first.top ||
            selectionRects.first.height != curRects.first.height ||
            selectionRects.first.left != curRects.first.left ||
            selectionRects.first.width != curRects.first.width
        ) {
            $actionDialogTarget.css({
                top: selectionRects.first.top,
                height: selectionRects.first.height,
                left: selectionRects.first.left,
                width: selectionRects.first.width,
            });
            curRects = selectionRects;
            posChanged = true;
        }
        return posChanged;
    }

    function displayPropertyPanel() {
        selectionRange = Confluence.HighlightAction.RangeHelper.getUserSelectionRange();

        const isSelectionContainsText = function (_selectionRange) {
            return $.trim(_selectionRange.toString()) !== '';
        };

        if (!selectionRange || !isSelectionContainsText(selectionRange)) {
            actionPanel.hide();
            return;
        }
        const selectionRects = Confluence.HighlightAction.RangeHelper.getSelectionRects(selectionRange);
        if (!selectionRects) {
            return;
        }

        const isInNewPosition = positionDialogTarget(selectionRects);
        if (isInNewPosition || !$(actionPanel[0]).is(':visible')) {
            $(actionPanel[0]).hide();
            actionPanel.show();
        }
    }

    /*
     * Bind mouse handlers for highlight actions
     */
    function bindHandlers(actionsPromise) {
        let panelTimeoutId;
        const NO_DELAY = 0;
        const DELAY_1_SECOND = 1000;

        $(document).on('mouseup', (e) => {
            // Only fire the callback once we have fetched the highlight panels actions using ajax
            actionsPromise.done((data) => {
                // Panel won't exist if user can't perform any actions on the page
                if (!(data && data.length > 0)) {
                    return;
                }

                const $target = $(e.target);
                // We need to ignore mouseup events that occur in the inline dialogs
                if ($target.closest('.aui-inline-dialog').length !== 0) {
                    return;
                }
                // The following code is wrapped in a setTimeout of 0 because when a user clicks to dismiss highlighted text
                // in Chrome, the mouseup event will fire before the selection is cleared, causing the property panel to
                // remain visible even though the selection is dismissed. The setTimeout gives the browser the needed time
                // to clear selected text before executing the mouseup handler
                setTimeout(() => {
                    clearTimeout(panelTimeoutId);

                    let panelDisplayDelay = DELAY_1_SECOND;
                    if ($(actionPanel[0]).is(':visible')) {
                        panelDisplayDelay = NO_DELAY;
                    }
                    panelTimeoutId = setTimeout(() => {
                        // actions dialog appearing for first time, delay then show
                        displayPropertyPanel();
                    }, panelDisplayDelay);
                }, NO_DELAY);
            });
        });

        actionsPromise.done(() => {
            // hide the property panel when invoking quick edit
            AJS.bind('quickedit.success', () => {
                actionPanel.hide();
            });
        });
    }

    function init() {
        // endpoint for retrieving available highlight actions
        let restUrl = `${Confluence.getContextPath()}/rest/highlighting/1.0/panel-items`;
        const pageId = AJS.Meta.get('page-id');
        if (pageId != undefined) {
            restUrl = `${restUrl}?pageId=${pageId}`;
        }

        const actionsPromise = $.get(restUrl, (data) => {
            if (data.length) {
                createPropertyPanel(data);
            }
        });

        bindHandlers(actionsPromise);
    }

    init();
});
