/* eslint-disable no-param-reassign */
/* eslint-disable eqeqeq */
/* eslint-disable valid-jsdoc */
/* eslint-disable func-names */
/**
 * Provide a useful method to interact with Range
 */

/**
 * Convert all non-break spaces <code>u00a0</code> to normal spaces <code>u0020</code>
 * @param {string} str string to be converted
 * @returns {string} result string
 */
function convertSpaces(str) {
    return str.replace(/\u00a0/g, '\u0020');
}

/*
 * Return the text contained within the range object
 *
 * @param W3C text range object
 * @return highlighted text stripped of DOM elements
 */
function getSelectionText(selectionRange) {
    /*
       The selection should always return the textContent as we will be comparing the selectionText to the text content
       of the page (for example, findOccurences uses text content).
       */
    const selectionText = selectionRange.cloneContents().textContent;
    /*
       CONF-36789: on IE, selectionRange.toString() always convert all &nbsp; to normal space
       on other browsers, it does not. So we must convert manually to made consistency across all browsers
       */
    return convertSpaces(selectionText);
}

/**
 * Return the HTML string contained within the range object
 * @param selectionRange: W3C text range object
 */
function getSelectionHTML(selectionRange) {
    return $('<div>').append(selectionRange.cloneContents()).html();
}

/*
 * Find deepest common ancestor container of a selection ranges boundary-points
 *
 * @param selectionRange current text selection on the page
 * @return deepest DOM element encompassing the entire selection
 */
function getContainingElement(selectionRange) {
    const selectRangeElement = selectionRange.commonAncestorContainer;
    if (selectRangeElement.nodeType === 3) {
        // Is TextNode
        return selectRangeElement.parentNode;
    }
    return selectRangeElement;
}

/*
 * Given a selectionRange object and clientRects representing the highlighted text, return the first and last
 * clientRect containing text accounting for browser incompatibilities
 *
 * @param selectionRange selected text range object
 * @param clientRects browser clientRects representing the highlighted text
 * @return an object containing the first and last clientRect of the highlighted text
 */
function getFirstAndLastSelectionRect(selectionRange, clientRects) {
    // In Chrome triple clicking text will cause all the text in an element to be selected. When calling
    // getClientRects after a triple click, the array will contain rects for each line of highlighted text
    // in the highlighted element and also a clientRects for the adjacent sibling element even though no text
    // is highlighted inside it. If the endOffset is zero, we ignore this final clientRect because no text
    // is highlighted inside of it.
    //
    // Also, in Chrome, Safari and Firefox, get client rects return a clientRects representing each inline element
    // including rectangles for all nested elements. IE8 return many less rects, maybe just one for the ancestor
    // element containing the highlight or a clientRects for each line of highlight without individual rects for each
    // inline element
    const rects = {};
    // eslint-disable-next-line prefer-destructuring
    rects.first = clientRects[0];
    rects.last = clientRects[clientRects.length - 1];
    if (selectionRange.endOffset !== 'undefined') {
        // In IE, if we highlight on resolved inline comment, we will length of clientRects is 1
        if (selectionRange.endOffset == 0 && clientRects.length > 1) {
            rects.last = clientRects[clientRects.length - 2];
        }
    }
    return rects;
}

/*
 * Returns an object representing a rectangle. the rectangle coordinates are as follows
 * left: start of the text highlight
 * right: either the end of the highlight of the first line or the end of the highlight of the last line, whichever is greater
 * top: top of highlighted text
 * bottom: bottom of highlighted text
 *
 * @param selectionRange range object representing the selected text
 * @return rect object or false if error occurs
 */
function getSelectionRects(selectionRange) {
    // if using documentation theme, get scrolltop of documentation theme content which is fixed size
    // certain browsers give the scrollTop on html element, some give it on the body element. this works in both.
    const scrollTop = Confluence.DocThemeUtils.getMainContentScrollTop();
    const scrollLeft = Confluence.DocThemeUtils.getMainContentScrollLeft();

    const clientRects = selectionRange.getClientRects();
    const rects = getFirstAndLastSelectionRect(selectionRange, clientRects);

    /*
     * Calculates Create Issue dialog target area
     */
    const getOverlap = function (firstRect, lastRect) {
        const overlap = {};
        overlap.top = firstRect.top;
        overlap.left = firstRect.left + scrollLeft;
        overlap.bottom = lastRect.bottom;

        if (firstRect.left >= lastRect.right) {
            overlap.right = firstRect.right;
        } else {
            overlap.right = lastRect.right;
        }
        overlap.right += scrollLeft;
        // adjust top for doc theme
        overlap.top += scrollTop;
        overlap.bottom += scrollTop;
        // set width and height
        overlap.width = overlap.right - overlap.left;
        overlap.height = overlap.bottom - overlap.top;

        return overlap;
    };

    /*
     * Calculates the action panel target area
     */
    const getHighlightStart = function (rect) {
        return {
            width: rect.right - rect.left,
            height: rect.bottom - rect.top,
            left: rect.left + scrollLeft,
            right: rect.right + scrollLeft,
            top: rect.top + scrollTop,
            bottom: rect.bottom + scrollTop,
        };
    };

    /*
     * Adjusts coordinates if using documentation theme to be relative to documentation theme scrolling content
     * container, otherwise coordinates are relative to the viewport
     */
    const adjustRectForDocTheme = function (rect) {
        // if using documentation theme, calculate position relative to docThemeContainer not window
        if (Confluence.DocThemeUtils.isDocTheme()) {
            const docContainerOffset = Confluence.DocThemeUtils.getDocThemeContentElement().offset();
            rect.left -= docContainerOffset.left;
            rect.right -= docContainerOffset.left;
            rect.top -= docContainerOffset.top;
            rect.bottom -= docContainerOffset.top;
        }
        return rect;
    };

    const averageRect = adjustRectForDocTheme(getOverlap(rects.first, rects.last));
    const firstRect = adjustRectForDocTheme(getHighlightStart(rects.first));

    // Some Debugging output. Turn on by typing Confluence.HighlightAction.debug = true in console after page loads
    if (Confluence.HighlightAction.debug) {
        const $highlightDebug = $('<div>').attr('id', 'highlight-actions-debug-helper');
        Confluence.DocThemeUtils.appendAbsolutePositionedElement($highlightDebug).css(
            $.extend({ position: 'absolute', outline: '1px solid red' }, averageRect),
        );
    }

    return {
        first: firstRect,
        average: averageRect,
    };
}

/**
 * Return an Object which provide all available variable for plugins
 * @param selectionRange
 * @returns {{area: *, text: *, html: *, containingElement: *, range: *}}
 */
function getRangeOption(selectionRange) {
    return {
        area: getSelectionRects(selectionRange),
        text: getSelectionText(selectionRange),
        html: getSelectionHTML(selectionRange),
        containingElement: getContainingElement(selectionRange),
        range: selectionRange,
    };
}

/**
 * Check if selectionRange is valid inside the Content or not
 * @param $content
 * @param selectionRange
 * @returns True if selectionRange is Content or child of Content.
 */
function isSelectionInsideContent($content, selectionRange) {
    const selectionContainer = getContainingElement(selectionRange);
    const isContent = function () {
        let isValid = false;
        // eslint-disable-next-line consistent-return
        $.each($content, (_index, element) => {
            // may be $element is container
            // or if $element is contained inside $content
            if (element === selectionContainer || $.contains(element, selectionContainer)) {
                isValid = true;
                return false; // return false to cancel the loop
            }
        });
        return isValid;
    };

    return isContent();
}

/*
 * Return valid W3C range object for the current selection the content, otherwise return false
 *
 * @param content the content element within which a selection must be contained
 * @return W3C range object for the current selection on the page or false if not defined
 */
function getUserSelectionRange() {
    // no selection made webkit
    if (window.getSelection && window.getSelection().isCollapsed) {
        return false;
    }

    // Firefox support multi range, we should get the last range to support Selenium test
    const range = window.getSelection();
    const selectionRange = range.getRangeAt(range.rangeCount - 1);

    // don't show the highlight panel if the selection is all whitespaces
    if (/^\s*$/.test(getSelectionText(selectionRange))) {
        const html = getSelectionHTML(selectionRange);
        if (!html) {
            return false;
        }
        // we support to quote image, need to check before return false
        const hasImage = html.toLowerCase().indexOf('<img ') != -1;
        // case not show return false
        if (!hasImage) {
            return false;
        }
    }

    // verify that selection is inside wiki-content
    if (!isSelectionInsideContent($('.wiki-content'), selectionRange)) {
        return false;
    }
    return selectionRange;
}

/*
 * Creates a range containing all text up to the selection text
 *
 * @param $root jQuery element, container of content which can be selected
 * @param selected range object representing the current selection
 * @return range object encompassing all text inside $root up to selected
 */
function extendRangeToStart($root, selected) {
    const range = document.createRange();
    range.setStart($root.get(0), 0);
    range.setEnd(selected.endContainer, selected.endOffset);
    return range;
}

/*
 * Return the text content of an element and all descendants
 *
 * @param $root jQuery element whose text content we're interested in
 * @return text content of the passed element
 */
function getTextContent($root) {
    return $root.text();
}

// Replace all texts in macro same with highlight text by space
function updatePageContent(selectedText, $root, pageContent) {
    let $macros = $root.find(
        '.user-mention, a[href^="/"], a[href^="#"], thead:hidden.tableFloatingHeader, div[data-macro-name="panel"] .panelHeader, [data-macro-name] .conf-macro-render', // .conf-macro-render is used for elements that are not statically in Source Editor
    );

    $root.find('.conf-macro[data-hasbody="false"], .jira-issue, .jira-issues').each(function () {
        if ($(this).text().indexOf(selectedText) > -1) {
            $macros = $macros.add(this);
        }
    });

    if ($macros.length > 0) {
        // string of spaces the same length as the original selectedText
        const replacedText = selectedText.replace(/\S/g, ' ');

        // create regular expression from selected text where all special characters are escaped with "\"
        const re = new RegExp(
            // eslint-disable-next-line no-useless-escape
            selectedText.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'),
            'g',
        );

        $macros.each(function () {
            // replace occurrences of selectedText within the macro with string of spaces (replacedText), so we don't
            // find these occurrences of selectedText
            const originalText = $(this).text();
            $(this).text(originalText.replace(re, replacedText));
        });

        return getTextContent($root);
    }

    return pageContent;
}

/*
 * Finds all occurrences of a substring inside a string
 *
 * @param src the string to search
 * @param sub the substring to find
 * @return array of indexes where the substring occurs
 */
function findOccurrences(selectedText, $root) {
    let pageContent = getTextContent($root);
    pageContent = updatePageContent(selectedText, $root.clone(), pageContent);

    // CONF-36789: convert &nbsp; to normal space, so compare selectedText with pageContent correctly
    pageContent = convertSpaces(pageContent);

    let start = 0;
    let found = -1;
    const indexes = [];
    // eslint-disable-next-line no-cond-assign
    while ((found = pageContent.indexOf(selectedText, start)) > -1) {
        indexes.push(found);
        start = found + 1;
    }
    return indexes;
}

/*
 * Generates javascript object containing the context of the selected text to help locate in storage format
 *
 * @param $root jQuery element, container of content which can be selected
 * @param selected range object representing the current selection
 * @return object containing metadata about the location of the selected text
 */
function computeSearchTextObject($root, selected) {
    let fromStart = getSelectionText(extendRangeToStart($root, selected));
    const selectedText = getSelectionText(selected).trim();
    const occurrences = findOccurrences(selectedText, $root);

    /*
      CONF-36789: b/c we trim selectedText, fromStart may contains spaces at the end
      we must remove these spaces to make sure fromStart.length is correct
       */
    fromStart = fromStart.replace(/\s*$/, '');

    return {
        pageId: AJS.Meta.get('page-id'),
        selectedText,
        index: $.inArray(fromStart.length - selectedText.length, occurrences),
        numMatches: occurrences.length,
    };
}

if (!Confluence.HighlightAction) Confluence.HighlightAction = {};

Confluence.HighlightAction.RangeHelper = {
    getRangeOption,
    getUserSelectionRange,
    getSelectionRects,
    getSelectionText,
    getSelectionHTML,
    getContainingElement,
    getFirstAndLastSelectionRect,
    isSelectionInsideContent,
    computeSearchTextObject,
};
