/* eslint-disable no-unused-expressions */
/* eslint-disable valid-jsdoc */
/* eslint-disable func-names */
AJS.toInit(($) => {
    const IS_NEW_COMMENT = true;
    const PLUGIN_KEY = 'com.atlassian.confluence.plugins.confluence-highlight-actions:quote-comment';

    /**
     * Active the correct editor if commentEl is passed. If not, active editor as new comment
     * @param commentEl
     */
    function activeEditor($commentEl) {
        if (!$commentEl.length > 0) {
            // Active new Editor as new comment
            $('.quick-comment-prompt').click();
        } else {
            // Active editor as reply according to commentEl
            $commentEl.find('.comment-actions .action-reply-comment').click();
        }
    }

    function scrollWindowToEditor() {
        const MARGIN_ABOVE_COMMENT_EDITOR = 40;
        if (Confluence.DocThemeUtils.isDocTheme()) {
            const $docThemeContainer = Confluence.DocThemeUtils.getDocThemeContentElement();
            const commentEditorTop =
                $docThemeContainer.scrollTop() - $('#header').height() + $('#rte-toolbar').offset().top;
            $docThemeContainer.scrollTop(commentEditorTop - MARGIN_ABOVE_COMMENT_EDITOR);
        } else {
            const commentEditorTop = $('#rte-toolbar').offset().top;
            $(document).scrollTop(commentEditorTop - MARGIN_ABOVE_COMMENT_EDITOR);
        }
    }

    function pasteQuote(editor, selectionObject) {
        const paragraphContent = '<p><br/></p>'; // default behavior of TinyMCE when user insert new paragraph in browsers other than IE
        const insertContent = `<blockquote><p>${selectionObject.html}</p></blockquote>${paragraphContent}`;
        editor.execCommand('mceInsertContent', false, insertContent);
    }

    /**
     * Return the comment element which contains the text is quoting
     * @param selectionObject
     * @returns {*|jQuery}
     */
    function quoteInsideComment(containingElement) {
        return $(containingElement).closest('div.comment');
    }

    function actionCallback(selectionObject) {
        Confluence.HighlightAction.clearTextSelection();

        // Need to place this in a timeout so that the panel actions have a chance to fade out before the
        // window scrolls, otherwise scrolling will break the fadeout behavior
        setTimeout(() => {
            const commentEditor = AJS && AJS.Rte && AJS.Rte.getEditor && AJS.Rte.getEditor();
            if (commentEditor) {
                Confluence.HighlightAction.Analytics.sendAnalyticsForQuoteInComment();
                // If comment editor is already loaded, need to scroll the window to the comment editor when user quotes
                scrollWindowToEditor();
                pasteQuote(commentEditor, selectionObject);
            } else {
                Confluence.HighlightAction.Analytics.sendAnalyticsForQuoteInComment(IS_NEW_COMMENT);
                // Need to trigger quick edit and paste the text when
                // the quick edit form visible and "quickedit.visible" event fires
                const handler = function () {
                    pasteQuote(AJS.Rte.getEditor(), selectionObject);
                    AJS.unbind('quickedit.visible', handler);
                };
                AJS.bind('quickedit.visible', handler);

                activeEditor(quoteInsideComment(selectionObject.containingElement));
            }
        }, 0);
    }

    Confluence &&
        Confluence.HighlightAction &&
        Confluence.HighlightAction.registerButtonHandler(PLUGIN_KEY, {
            onClick: actionCallback,
            shouldDisplay: Confluence.HighlightAction.WORKING_AREA.MAINCONTENT_AND_COMMENT,
        });
});
