/**
 * @module confluence-editor/unknown-attachment/property-panel
 */
define('confluence-editor/unknown-attachment/property-panel', [
    'wrm/context-path',
    'ajs'
], function(
    contextPath,
    AJS
) {
    if (AJS && AJS.Rte && AJS.Rte.BootstrapManager) {
        AJS.Rte.BootstrapManager.addOnInitCallback(function() {
            const ed = AJS.Rte.getEditor();
            if (ed) {
                ed.on('Click', function(e) {
                    const n = e.target;
                    const placeholderPath = '/plugins/servlet/confluence/placeholder/unknown-attachment';
                    if (n.nodeName === 'IMG' && n.hasAttribute('src') &&
                        n.getAttribute('src').indexOf(contextPath() + placeholderPath) >= 0 ) {
                        ed.execCommand("mceConfimage");
                    }
                });
            } else {
                AJS.log('Could not get Editor from adapter');
            }
        });
    } else {
        AJS.log('Could not initialize property panel onclick handler on Confluence.Editor');
    }

});

require('confluence-editor/unknown-attachment/property-panel');
