Confluence.Blueprints.Restrospectives = (function ($) {
    var retroForm;

    var removeError = function (element) {
        element.siblings(".error").empty();
    };

    var showError = function (element, message) {
        element.focus().siblings(".error").text(message);
    };

    var isPageTitleValid = function () {
        if (retroForm.title.val() === "") {
            return true;
        }

        if (!Confluence.Blueprint.canCreatePage(retroForm.spaceKey, retroForm.title.val())) {
            showError(retroForm.title, AJS.I18n.getText('retrospectives.blueprint.form.validation.title.exits'));
            return false;
        }
        removeError(retroForm.title);
        return true;
    };

    var convertToUserKeys = function ($container, pageData, dataKey) {
        var usersList = $container.find("#" + dataKey).select2('data');
        var usersByUserKey = usersList.map(function (user) {
            return user.userKey;
        }).join(',');

        pageData[dataKey] = usersByUserKey;
    }

    var bindRetroFormElementsEvent = function () {
        retroForm.title.change(isPageTitleValid);
    };

    var generatePageTitle = function () {
        var requestTime = $("meta[name=confluence-request-time]").attr("content");
        var date = new Date(parseFloat(requestTime));
        var dateString = `${date.getFullYear()}-${(date.getMonth() + 1).toString().padStart(2, 0)}-${date.getDate().toString().padStart(2, 0)}`;

        retroForm.title.val(dateString + ' ' + AJS.I18n.getText('retrospectives.blueprint.dialog.title.value'));
    };

    return {
        init: function (state) {
            retroForm = {
                title: state.$container.find('#retro-title'),
                participants: state.$container.find('#retro-participants'),
                spaceKey: state.wizardData.spaceKey
            };

            bindRetroFormElementsEvent();
            generatePageTitle();
        },

        validateRetroForm: function (state) {
            convertToUserKeys(state.$container, state.pageData, 'retro-participants');
            return isPageTitleValid();
        }

    };
})(AJS.$);
