/**
 * @module confluence-dashboard-macros/popular
 * @tainted Masonry
 */
define('confluence-dashboard-macros/popular', [
    'jquery',
    'confluence/meta',
    'confluence/api/event',
    'confluence/templates',
    'confluence/legacy',
    'ajs'
],
function(
    $,
    Meta,
    event,
    Templates,
    Confluence,
    AJS
) {
    'use strict';

    var POPULAR_STREAM_URL = Meta.get('context-path') + '/rest/popular/1/stream/content';

    function get(url, $container, append, options) {
        options = options || {};

        var ajaxData = {
            days: 7,
            pageSize: 20
        };

        ajaxData = $.extend(ajaxData, options);

        $.ajax({
            type: 'GET',
            url: url,
            data: ajaxData,
            contentType: 'application/json; charset=utf-8',
            dataType: 'json'
        }).success(function(data) {
            if (data.streamItems && data.streamItems.length === 0) {
                // This event is listened for in confluence-getting-started plugin which displays the welcome video
                event.trigger('dashboard-recentupdates-popular.no-updates', { container: $container });
                $('.loading-text').html(AJS.I18n.getText('confluence.macros.dashboard.popular.no.content'));
                return false;
            }

            var $streamItems;
            if (append) {
                $streamItems = $(Templates.Dashboard.streamItemsContents(data));
                var $streamItemsEl = $container.find('#stream-items');
                $streamItemsEl.append($streamItems);

                var $moreLink = $container.find('.more-trigger');
                $('.stream-items-loading').hide();
                if (data.nextPageOffset) {
                    $moreLink.show();
                    $moreLink.attr('data-next-page-offset', data.nextPageOffset);
                } else {
                    $moreLink.remove();
                }
            } else {
                $streamItems = $(Templates.Dashboard.streamItems(data));
                $container.html($streamItems);

                $container.find('.more-trigger').click(function() {
                    $('.stream-items-loading').show();
                    $(this).hide();

                    get(POPULAR_STREAM_URL, $container, true, {
                        nextPageOffset: $(this).attr('data-next-page-offset')
                    });

                    // CONFDEV-33536 - Confluence simplify journeys
                    event.trigger('analytics', { name: 'confluence.dashboard.popular-stream.show-more' });

                    return false;
                });
            }
        });
    }

    function showSpinner(container) {
        $(container).html(Confluence.Templates.Dashboard.Updates.streamLoading());
        $(container).find('.loading-text').spin('large');
    }

    function loadPopularStream(options) {
        var $container = $('#recent-updates .tabs-pane.active-pane');
        showSpinner($container);
        get(POPULAR_STREAM_URL, $container, false, options);
    }

    return {
        reloadPopularStream: function(options) {
            if ($('#recent-updates .menu-item.popular').hasClass('active-tab')) {
                loadPopularStream(options);
            }
        },
        showSpinner: showSpinner
    };
});

require('confluence/module-exporter').exportModuleAsGlobal('confluence-dashboard-macros/popular', 'Confluence.Dashboard', function(Dashboard) {
    'use strict';

    require('ajs').toInit(function() {
        Dashboard.reloadPopularStream();
    });
});
