(function () {

    define("MediaViewer", MediaViewerFactory);
    define("FileViewer", MediaViewerFactory);
    define("core/template-store-singleton", function() {
        var properties = /^[a-zA-Z0-9.]+$/;
        return {
            get: function(name) {
                return properties.test(name) ? eval('FileViewer.Templates.' + name) : null;
            }
        };
    });
    define("confluence-previews/is-ignored-keypress-event", function() {
        // If a keyboard key is pressed, return true if it is NOT <Space> or <Enter>
        return function(ev) {
            return ev.key && ev.key !== ' ' && ev.key !== 'Enter';
        }
    });

    function MediaViewerFactory() {
        AJS.I18n.keys['cp.footer.expand.minimode'] = AJS.I18n.getText('cp.footer.expand.minimode');
        AJS.I18n.keys['cp.footer.close.minimode'] = AJS.I18n.getText('cp.footer.close.minimode');
        AJS.I18n.keys['cp.thumbnail.description'] = AJS.I18n.getText('cp.thumbnail.description');
        AJS.I18n.keys['cp.expand.thumbnail.minimode'] = AJS.I18n.getText('cp.expand.thumbnail.minimode');
        AJS.I18n.keys['cp.close.thumbnail.minimode'] = AJS.I18n.getText('cp.close.thumbnail.minimode');
        AJS.I18n.keys['cp.go.to.prev'] = AJS.I18n.getText('cp.go.to.prev');
        AJS.I18n.keys['cp.go.to.next'] = AJS.I18n.getText('cp.go.to.next');
        AJS.I18n.keys['cp.go.to.prev.page'] = AJS.I18n.getText('cp.go.to.prev.page');
        AJS.I18n.keys['cp.go.to.next.page'] = AJS.I18n.getText('cp.go.to.next.page');
        AJS.I18n.keys['cp.close'] = AJS.I18n.getText('cp.close');
        AJS.I18n.keys['cp.download.original'] = AJS.I18n.getText('cp.download.original');
        AJS.I18n.keys['cp.fit.to.page'] = AJS.I18n.getText('cp.fit.to.page');
        AJS.I18n.keys['cp.zoom.in'] = AJS.I18n.getText('cp.zoom.in');
        AJS.I18n.keys['cp.zoom.out'] = AJS.I18n.getText('cp.zoom.out');
        AJS.I18n.keys['cp.enter.presentation.mode'] = AJS.I18n.getText('cp.enter.presentation.mode');
        AJS.I18n.keys['cp.exit.presentation.mode'] = AJS.I18n.getText('cp.exit.presentation.mode');
        AJS.I18n.keys['cp.image.load.fail.header'] = AJS.I18n.getText('cp.image.load.fail.header');
        AJS.I18n.keys['cp.image.load.fail'] = AJS.I18n.getText('cp.image.load.fail');
        AJS.I18n.keys['cp.show.more'] = AJS.I18n.getText('cp.show.more');
        AJS.I18n.keys['cp.edit.file'] = AJS.I18n.getText('cp.edit.file');
        AJS.I18n.keys['cp.print.file'] = AJS.I18n.getText('cp.print.file');
        AJS.I18n.keys['cp.delete.file'] = AJS.I18n.getText('cp.delete.file');
        AJS.I18n.keys['cp.arrow.left.disabled'] = AJS.I18n.getText('cp.arrow.left.disabled');
        AJS.I18n.keys['cp.arrow.right.disabled'] = AJS.I18n.getText('cp.arrow.right.disabled');
        AJS.I18n.keys['cp.password.protected'] = AJS.I18n.getText('cp.password.protected');
        AJS.I18n.keys['cp.password.needed'] = AJS.I18n.getText('cp.password.needed');
        AJS.I18n.keys['cp.password.incorrect'] = AJS.I18n.getText('cp.password.incorrect');
        AJS.I18n.keys['cp.password.input.placeholder'] = AJS.I18n.getText('cp.password.input.placeholder');
        AJS.I18n.keys['cp.password.button.ok'] = AJS.I18n.getText('cp.password.button.ok');
        AJS.I18n.keys['cp.password.fullscreen.title'] = AJS.I18n.getText('cp.password.fullscreen.title');
        AJS.I18n.keys['cp.password.fullscreen.message'] = AJS.I18n.getText('cp.password.fullscreen.message');
        AJS.I18n.keys['cp.error.button.download'] = AJS.I18n.getText('cp.error.button.download');
        AJS.I18n.keys['cp.error.button.browser'] = AJS.I18n.getText('cp.error.button.browser');
        AJS.I18n.keys['cp.error.image.missing.header'] = AJS.I18n.getText('cp.error.image.missing.header');
        AJS.I18n.keys['cp.error.pdf.missing.header'] = AJS.I18n.getText('cp.error.pdf.missing.header');
        AJS.I18n.keys['cp.error.media.default.header'] = AJS.I18n.getText('cp.error.media.default.header');
        AJS.I18n.keys['cp.error.pdf.password.header'] = AJS.I18n.getText('cp.error.pdf.password.header');
        AJS.I18n.keys['cp.error.pdf.password.message'] = AJS.I18n.getText('cp.error.pdf.password.message');
        AJS.I18n.keys['cp.error.pdf.invalid.header'] = AJS.I18n.getText('cp.error.pdf.invalid.header');
        AJS.I18n.keys['cp.error.pdf.invalid.message'] = AJS.I18n.getText('cp.error.pdf.invalid.message');
        AJS.I18n.keys['cp.error.pdf.default.header'] = AJS.I18n.getText('cp.error.pdf.default.header');
        AJS.I18n.keys['cp.error.pdf.default.message'] = AJS.I18n.getText('cp.error.pdf.default.message');
        AJS.I18n.keys['cp.error.default.header'] = AJS.I18n.getText('cp.error.default.header');
        AJS.I18n.keys['cp.error.file.not.found'] = AJS.I18n.getText('cp.error.file.not.found');
        AJS.I18n.keys['cp.error.file.no.viewer'] = AJS.I18n.getText('cp.error.file.no.viewer');
        AJS.I18n.keys['cp.file.converting.message.header'] = AJS.I18n.getText('cp.file.converting.message.header');
        AJS.I18n.keys['cp.file.converting.message.text'] = AJS.I18n.getText('cp.file.converting.message.text');
        AJS.I18n.keys['cp.unknown.file.type.header'] = AJS.I18n.getText('cp.unknown.file.type.header');
        AJS.I18n.keys['cp.unknown.file.type.download.to.view'] = AJS.I18n.getText('cp.unknown.file.type.download.to.view');
        AJS.I18n.keys['cp.unknown.file.type.downloadbutton'] = AJS.I18n.getText('cp.unknown.file.type.downloadbutton');
        AJS.I18n.keys['cp.unsupported.browser.header'] = AJS.I18n.getText('cp.unsupported.browser.header');
        AJS.I18n.keys['cp.unsupported.browser.download.to.view'] = AJS.I18n.getText('cp.unsupported.browser.download.to.view');
        AJS.I18n.keys['cp.3d.file.type.toggle.grid'] = AJS.I18n.getText('cp.3d.file.type.toggle.grid');
        AJS.I18n.keys['cp.3d.file.type.toggle.camera.type'] = AJS.I18n.getText('cp.3d.file.type.toggle.camera.type');
        AJS.I18n.keys['cp.3d.file.type.toggle.light.type'] = AJS.I18n.getText('cp.3d.file.type.toggle.light.type');
        AJS.I18n.keys['cp.3d.file.type.toggle.axis'] = AJS.I18n.getText('cp.3d.file.type.toggle.axis');

        AJS.I18n.keys['cp.companion.inline.pre.download.title'] = AJS.I18n.getText('cp.companion.inline.pre.download.title');
        AJS.I18n.keys['cp.companion.inline.pre.download.body'] = AJS.I18n.getText('cp.companion.inline.pre.download.body');
        AJS.I18n.keys['cp.companion.inline.post.download.title'] = AJS.I18n.getText('cp.companion.inline.post.download.title');
        AJS.I18n.keys['cp.companion.inline.post.download.body'] = AJS.I18n.getText('cp.companion.inline.post.download.body');
        AJS.I18n.keys['cp.companion.inline.post.download.body.problems'] = AJS.I18n.getText('cp.companion.inline.post.download.body.problems');
        AJS.I18n.keys['cp.companion.inline.post.download.body.try.again'] = AJS.I18n.getText('cp.companion.inline.post.download.body.try.again');
        AJS.I18n.keys['cp.companion.inline.security.title'] = AJS.I18n.getText('cp.companion.inline.security.title');
        AJS.I18n.keys['cp.companion.inline.security.body'] = AJS.I18n.getText('cp.companion.inline.security.body');
        AJS.I18n.keys['cp.companion.download.mac'] = AJS.I18n.getText('cp.companion.download.mac');
        AJS.I18n.keys['cp.companion.download.win'] = AJS.I18n.getText('cp.companion.download.win');
        AJS.I18n.keys['cp.companion.download.tooltip'] = AJS.I18n.getText('cp.companion.download.tooltip');
        AJS.I18n.keys['cp.companion.edit.with.app'] = AJS.I18n.getText('cp.companion.edit.with.app');
        AJS.I18n.keys['cp.companion.downloading'] = AJS.I18n.getText('cp.companion.downloading');
        AJS.I18n.keys['cp.companion.editingwith'] = AJS.I18n.getText('cp.companion.editingwith');
        AJS.I18n.keys['cp.companion.openinapp'] = AJS.I18n.getText('cp.companion.openinapp');
        AJS.I18n.keys['cp.companion.tip'] = AJS.I18n.getText('cp.companion.tip');
        AJS.I18n.keys['cp.companion.uploadready'] = AJS.I18n.getText('cp.companion.uploadready');
        AJS.I18n.keys['cp.companion.savetime.before'] = AJS.I18n.getText('cp.companion.savetime.before');
        AJS.I18n.keys['cp.companion.savetime.after'] = AJS.I18n.getText('cp.companion.savetime.after');
        AJS.I18n.keys['cp.companion.savetip'] = AJS.I18n.getText('cp.companion.savetip');
        AJS.I18n.keys['cp.companion.newversion'] = AJS.I18n.getText('cp.companion.newversion');
        AJS.I18n.keys['cp.companion.waitforupload'] = AJS.I18n.getText('cp.companion.waitforupload');
        AJS.I18n.keys['cp.companion.uploading'] = AJS.I18n.getText('cp.companion.uploading');
        AJS.I18n.keys['cp.companion.uploaded.prefix'] = AJS.I18n.getText('cp.companion.uploaded.prefix');
        AJS.I18n.keys['cp.companion.uploading.progress'] = AJS.I18n.getText('cp.companion.uploading.progress');
        AJS.I18n.keys['cp.companion.uploading.progress.done'] = AJS.I18n.getText('cp.companion.uploading.progress.done');
        AJS.I18n.keys['cp.companion.button.discard'] = AJS.I18n.getText('cp.companion.button.discard');
        AJS.I18n.keys['cp.companion.button.cancel'] = AJS.I18n.getText('cp.companion.button.cancel');
        AJS.I18n.keys['cp.companion.button.update'] = AJS.I18n.getText('cp.companion.button.update');
        AJS.I18n.keys['cp.companion.buttontitle'] = AJS.I18n.getText('cp.companion.buttontitle');
        AJS.I18n.keys['cp.companion.stillwaiting'] = AJS.I18n.getText('cp.companion.stillwaiting');
        AJS.I18n.keys['cp.companion.notification.title'] = AJS.I18n.getText('cp.companion.notification.title');
        AJS.I18n.keys['cp.companion.notification.body'] = AJS.I18n.getText('cp.companion.notification.body');
        AJS.I18n.keys['cp.companion.launch.wait'] = AJS.I18n.getText('cp.companion.launch.wait');
        AJS.I18n.keys['cp.companion.error.opening.file.title'] = AJS.I18n.getText('cp.companion.error.opening.file.title');
        AJS.I18n.keys['cp.companion.error.opening.file.body'] = AJS.I18n.getText('cp.companion.error.opening.file.body');
        AJS.I18n.keys['cp.companion.error.opening.disconnected.body'] = AJS.I18n.getText('cp.companion.error.opening.disconnected.body');
        AJS.I18n.keys['cp.companion.error.uploading.file.title'] = AJS.I18n.getText('cp.companion.error.uploading.file.title');
        AJS.I18n.keys['cp.companion.error.uploading.file.body'] = AJS.I18n.getText('cp.companion.error.uploading.file.body');
        AJS.I18n.keys['cp.companion.error.uploading.disconnected.body'] = AJS.I18n.getText('cp.companion.error.uploading.disconnected.body');
        AJS.I18n.keys['cp.companion.error.no.compatible.app.start'] = AJS.I18n.getText('cp.companion.error.no.compatible.app.start');
        AJS.I18n.keys['cp.companion.error.no.compatible.app.end'] = AJS.I18n.getText('cp.companion.error.no.compatible.app.end');
        AJS.I18n.keys['cp.companion.error.no.compatible.app.generic'] = AJS.I18n.getText('cp.companion.error.no.compatible.app.generic');
        AJS.I18n.keys['cp.companion.error.read.only.mode.tooltip'] = AJS.I18n.getText('cp.companion.error.read.only.mode.tooltip');
        AJS.I18n.keys['cp.companion.error.read.only.mode.body'] = AJS.I18n.getText('cp.companion.error.read.only.mode.body');
        AJS.I18n.keys['cp.companion.error.file.size.body'] = AJS.I18n.getText('cp.companion.error.file.size.body');
        AJS.I18n.keys['cp.companion.upload.comment'] = AJS.I18n.getText('cp.companion.upload.comment');

        return window.MediaViewer;
    }

}());