define('cp/component/annotation/annotation-button-view', [
    'jquery',
    'backbone',
    'cp/component/utils/editor-utils',
    'core/template-store-singleton',
    'confluence-previews/is-ignored-keypress-event'
], function (
    $,
    Backbone,
    EditorUtils,
    templateStore,
    btnEvChecker
) {
    'use strict';
    var AnnotationButtonView = Backbone.View.extend({

        events: {
            'click': '_toggleAnnotations',
            'keydown': '_toggleAnnotations',
        },

        tagName: 'span',

        initialize: function (options) {
            this._mediaViewer = options.mediaViewer;
            this._model = this._mediaViewer.getCurrentFile();
            this._annotations = this._model.get("annotations");

            this.listenTo(this._annotations, "add reset sync change:resolved remove filterUpdated", this._updateAnnotationCount);
        },

        render: function () {
            this.$el.html(templateStore.get('Annotation.controlAnnotationButton')());

            this._updateAnnotationCount();

            if ($.fn.tooltip) { this.$('a').tooltip({ gravity: 'n' }); }

            return this;
        },

        _toggleAnnotations: function(event) {
            if (btnEvChecker(event)) {
                return;
            }
            event.preventDefault();

            if (this._mediaViewer.getView().fileSidebarView.isAnyPanelInitialized()) {
                if (EditorUtils.confirmProcess()) {
                    this._mediaViewer.trigger("cp.close-editor");
                    this._mediaViewer.getView().fileSidebarView.teardownPanel();
                }
            } else {
                this._annotations.getCurrentOrNext();
                this._mediaViewer.getView().fileSidebarView.initializePanel('annotations');
            }
        },

        _updateAnnotationCount: function() {
            var count = this._annotations.getCount();
            this.$(".counter").text(count > 9 ? "9+" : count);
        }

    });

    return AnnotationButtonView;
});