define("cp/component/annotation/comment",
    [
        "cp/component/annotation/replies",
        "cp/component/annotation/likes",
        "ajs",
        "backbone"
    ],
    function(
        Replies,
        Likes,
        AJS,
        Backbone
        ) {
        "use strict";

        var Comment = Backbone.Model.extend({
            defaults: {
                author: {
                    name: '',
                    avatar: '',
                    profile: ''
                },
                comment: '',
                date: new Date(),
                pageNumber: 1,
                position: [0.5, 0.5],
                resolved: false,
                selected: false,
                hasEditPermission: true,
                hasResolvePermission: true,
                hasDeletePermission: true,
                hasReplyPermission: true
            },
            initialize: function(attrs, opts) {
                // TODO: attrs undef?
                this.service = opts.service;

                if (this.service) {
                    this.replies = new Replies(undefined,
                        {
                            service: this.service,
                            parentModel: this
                        }
                    );
                } else {
                    this.replies = new Replies();
                }

                this.likes = new Likes([], {contentId: this.get('id'), replies: this.replies.models});

                this.on("change:id", this.createLikes);
                this.listenTo(this.replies, "reset sync", this.createLikes);
                this.createLikes();

                this.set("fileModel", attrs.fileModel);
            },

            createLikes: function() {
                if (!this.replies.isSynced()) {
                    return;
                }
                if (this.get('id') !== undefined) {
                    this.likes.setReplies(this.replies.models);
                    this.likes.fetch();
                }
            },

            setResolved: function(isResolved, successCallback, errorCallback) {
                this.save({resolved: isResolved},
                    {
                        success: successCallback,
                        error: errorCallback
                    }
                );
            },

            isNew: function() {
                return this.get('isNew');
            },

            sync: function(method, model, options) {
                if (!this.service) {
                    return;
                }
                if (method === "create" || method === "update") {
                    var promise = model.service.save(model);
                    promise.done(function(savedModel) {
                        model.set(savedModel);
                        options.success();
                    }).fail(function(xhr) {
                        options.error(xhr);
                    });
                    return promise;
                } else if (method === "delete") {
                    var promise = model.service.remove(model);
                    promise.done(function() {
                        options.success();
                    }).fail(function(xhr) {
                        options.error(xhr);
                    });
                    return promise;
                }
            }

        });

        return Comment;
    });