define(
    "cp/component/annotation/likes-view",
    [
        "backbone",
        "underscore",
        "ajs",
        "cp/component/annotation/likes",
        "core/template-store-singleton",
        "confluence/message-controller"
    ],
    function(
        Backbone,
        _,
        AJS,
        Likes,
        templateStore,
        MessageController
    ) {

        "use strict";
        var LikesView = Backbone.View.extend({
            collection: Likes,

            tagName: "span",

            className: "cp-annotation-like",

            events: {
                "click .cp-annotation-like": "like",
                "click .cp-annotation-unlike": "unlike"
            },

            initialize: function(props) {
                this.collection = props.collection;
                this.commentId = props.id;
                this._annotationView = props._annotationView;

                this.collection && this.listenTo(this.collection, 'reset add remove sync', this.render);

            },

            render: function() {
                this.$el.empty();

                if(this.collection === undefined) {
                    return;
                }

                //find the likes for this comment in our likes collection
                var commentLikes = _.find(this.collection.models, function(likes) {
                    return likes.attributes.content_id === this.commentId;
                }.bind(this));

                var isAnonymous = !(AJS.Meta.get('remote-user'));
                var canLike = AJS.Meta.get('render-mode') !== 'READ_ONLY';

                //check if this user has liked this comment
                var hasLiked = !isAnonymous && !!commentLikes && _.some(commentLikes.get('likes'), function(likedBy) {
                    return likedBy.user.name === AJS.Meta.get('remote-user');
                });

                var numberOfLikes = commentLikes ? commentLikes.get('likes').length : 0;

                this.$el.html(templateStore.get('Annotation.likes')({
                    likes: numberOfLikes,
                    hasLiked: hasLiked,
                    isAnonymous: isAnonymous,
                    canLike: canLike
                }));
                return this;
            },

            like: function() {
                AJS.trigger('analyticsEvent', {
                    name: 'confluence-spaces.previews.annotation.like',
                    data: {
                        fileType: this._annotationView._mediaViewer.getCurrentFile().get("type"),
                        commentId: this.commentId
                    }
                });
                this.collection.addLike(this.commentId, {error: this._handleError.bind(this)});
            },

            unlike: function() {
                this.collection.removeLike(this.commentId, {error: this._handleError.bind(this)});
            },

            _handleError: function(model, xhr) {
                this._annotationView._generateError(MessageController.parseError(xhr, AJS.I18n.getText('cp.annotations.like.fail')));
            },
        });

        return LikesView;

    });

