define('cp/component/companion/companion-plugin', [
    'cp/component/companion/companion-view',
    'underscore'
], function(
    CompanionMainView,
    _
) {
    'use strict';

    var companionPlugin = function(mediaViewer) {
        window._mediaViewer = mediaViewer;

        mediaViewer.getView().fileControlsView.addLayerView('companionMainView', CompanionMainView, {
            weight: 1,
            predicate: function(mediaViewer) {
                return true;
            }
        });

        mediaViewer.on('fv.changeFile', function(file) {
            CompanionMainView.lastChangedFile = file;
            if (mediaViewer.getView().fileControlsView.isLayerInitialized('companionMainView')) {
                var companionMainView = mediaViewer.getView().fileControlsView.getLayerForName('companionMainView');
                companionMainView.onFileChange(file);
            }
        });

        mediaViewer.on('fv.close', function(file) {
            CompanionMainView.lastChangedFile = undefined;
        });

        // When we upload new version of file, we need to refresh page to show new files
        var refreshIfFilesChanged = function() {
            mediaViewer._fileState.get('isNewFileUploaded') && document.location.reload(true);
        };

        mediaViewer.close = _.wrap(mediaViewer.close, function(close) {
            if (mediaViewer.getView().fileControlsView.isLayerInitialized('companionMainView')) {
                var companionMainView = mediaViewer.getView().fileControlsView.getLayerForName('companionMainView');
                companionMainView.disconnect();
            }
            close.apply(mediaViewer, Array.prototype.slice.call(arguments, 1));
            refreshIfFilesChanged();
        });
    };

    return companionPlugin;
});

(function() {
    try {
        var CompanionPlugin = require('cp/component/companion/companion-plugin');
        var MediaViewer = require('MediaViewer');
        MediaViewer.registerPlugin('companion', CompanionPlugin);
    } catch(error) {
        console.warn('Failed to register companion-plugin in this environment', error);
    }
}());
