define('cp/component/upload/upload-button-view', [
    'jquery',
    'backbone',
    'ajs',
    'cp/component/upload/upload-utils',
    'core/template-store-singleton'
], function (
    $,
    Backbone,
    AJS,
    UploadUtils,
    templateStore
) {
    'use strict';
    var UploadButtonView = Backbone.View.extend({

        tagName: 'span',
        events : {
            click: '_onClick'
        },

        initialize: function (options) {
            this._mediaViewer = options.mediaViewer;

            var controlsView = this._mediaViewer.getView().fileControlsView;
            this.listenTo(controlsView, 'renderLayers', this._initUploader);
        },

        render: function () {
            var model = this._mediaViewer.getCurrentFile();
            if (!model) {
                return this;
            }

            if (model.get('hasUploadAttachmentVersionPermission')) {
                this.$el.html(templateStore.get('controlUploadButton')());

                if ($.fn.tooltip) {
                    this.$('a').tooltip({ gravity: 'n' });
                }
            } else {
                this.stopListening().listenTo(model, 'change:hasUploadAttachmentVersionPermission', this._onUploadNewVersionPermissionChanged);
            }

            return this;
        },

        teardown: function () {
            this.stopListening();
            this._killExistingUploader();
        },

        _onClick: function () {
            AJS.trigger('analyticsEvent',{
                name: 'confluence-spaces.previews.upload.click'
            });
        },

        _onUploadNewVersionPermissionChanged: function (model) {
            if (model.get('hasUploadAttachmentVersionPermission')) {
                this.render();
                this._initUploader();
            }
        },

        _initUploader: function() {
            var model = this._mediaViewer.getCurrentFile();

            if (model && model.get('hasUploadAttachmentVersionPermission')) {
                this._killExistingUploader();
                this.uploader = UploadUtils.createUploader(this._mediaViewer, this.$('#cp-control-panel-upload')[0]);
            }
        },

        _killExistingUploader: function() {
            if (this.uploader) {
                this.uploader.off().destroy();
                this.uploader = null;
            }
        }
    });

    return UploadButtonView;
});
