define("cp/component/versions/file-version",
    [
        "backbone",
        "cp/component/versions/version-file-enricher"
    ],
    function(
        Backbone,
        VersionFileEnricher
        ) {
        "use strict";

        var Version = Backbone.Model.extend({
            initialize: function(attrs, opts) {
                this.versionsService = opts.versionsService;
                this.fileModel = opts.fileModel;
            },

            toJSON: function() {
                var json = Backbone.Model.prototype.toJSON.apply(this, arguments);
                json.cid = this.cid;
                return json;
            },

            getFileVersion: function() {
                if (+this.get("version") === +this.fileModel.get("version")) {
                    return $.Deferred().resolve(this.fileModel);
                }

                return this.versionsService.getFileVersion(this.fileModel.get("ownerId"), this.fileModel.get("id"), this.get("version"))
                    .then(function(version) {
                        var versionedFile = this.fileModel.clone();
                        versionedFile.set(_.omit(version, "id")); // override with version data; but ID shouldn't change.
                        return VersionFileEnricher.enrich(versionedFile, this);
                    }.bind(this));
            },

            getLatestVersion: function() {
                return this.fileModel;
            }
        });

        return Version;
    }
);