define("cp/component/versions/version-message-view",
    [
        "backbone",
        "ajs",
        "MediaViewer",
        "core/template-store-singleton"
    ],
    function(
        Backbone,
        AJS,
        MediaViewer,
        templateStore
        ) {
        "use strict";

        var File = MediaViewer.require("core/file");

        var VersionMessageView = Backbone.View.extend({
            events: {
                "click a.view-latest-version": "_onViewLatest",
                "click a.reload-latest-version": "_onReloadLatest",
                "click span.icon-close": "_onCloseWarning"
            },

            initialize: function (options) {
                this._mediaViewer = options.mediaViewer;
                this._filesService = this._mediaViewer.getConfig().filesService;
                this.$el.attr("id", "cp-version-message");
            },
            
            render: function() {
                var file = this._mediaViewer.getCurrentFile();
                if (file.getLatestVersion().get("stale")) {
                    this.$el.html(AJS.messages.generic({
                        title: AJS.I18n.getText("cp.version.new.uploaded.message"),
                        body: templateStore.get("Versions.reloadLatestVersion")(),
                        closeable: false
                    })).show();
                } else if (!file.isLatestVersion()) {
                    this.$el.html(AJS.messages.generic({
                        title: AJS.I18n.getText("cp.version.viewing.previous.message"),
                        body: templateStore.get("Versions.viewCurrentVersion")(),
                        closeable: true
                    })).show();
                }

                return this;
            },

            teardown: function() {
                this.$el.hide();
            },

            _onViewLatest: function() {
                var file = this._mediaViewer.getCurrentFile();
                this._mediaViewer.showFile(file.getLatestVersion());

                AJS.trigger("analyticsEvent", {
                    name: " confluence-spaces.previews.versions.warning-view-latest"
                });
            },

            _onReloadLatest: function() {
                var file = this._mediaViewer.getCurrentFile();
                var fileService = new this._filesService(file.get("ownerId"));
                fileService.getFileWithId(file.getLatestVersion().get("id")).done(function (latestFileVersion) {
                    latestFileVersion = new File(latestFileVersion);
                    this._mediaViewer._fileState.replaceCurrent(latestFileVersion);
                    this._mediaViewer._fileState.set("isNewFileUploaded", true);
                    this._mediaViewer.showFile(latestFileVersion);
                }.bind(this));

                AJS.trigger("analyticsEvent", {
                    name: " confluence-spaces.previews.versions.warning-reload-latest"
                });
            },

            _onCloseWarning: function() {
                AJS.trigger("analyticsEvent", {
                    name: "confluence-spaces.previews.versions.close-warning"
                });
            }
        });

        return VersionMessageView;
    }
);