define("cp/confluence/conversion-poller",
    [
        "cp/confluence/conversion-poller-backend",
        "jquery"
    ],
    function(
        ConversionPollerBackend,
        $
        ) {
        "use strict";


        var backends = {};
        var cache = {};

        function ConversionPoller(attachmentId, version, type, statusCallback) {
            if (!backends[type]) {
                backends[type] = new ConversionPollerBackend(type);
            }

            this.backend = backends[type];
            this._attachmentId = attachmentId;
            this._version = version;

            var key = JSON.stringify({a: attachmentId, v: version, t: type});
            var hit = cache[key];
            if (hit) {
                this._promise = hit.success ? $.when(hit.url, hit.type) : $.Deferred().reject(hit.reason);
            } else {
                this._promise = this.backend.add(this._attachmentId, this._version);
                this._promise.then(function (url, type) {
                    cache[key] = {success: true, url: url, type: type};
                    return $.Deferred().resolve(url, type);
                },
                function(reason) {
                    if (reason !== "cancelled") {
                        cache[key] = {success: false, reason: reason};
                    }
                },
                statusCallback
                );
            }
        }

        ConversionPoller.prototype.stop = function() {
            this.backend.remove(this._attachmentId);
        };

        ConversionPoller.prototype.promise = function() {
            return this._promise;
        };

        return ConversionPoller;
    });
