require(
    [
        "cp/confluence/preview",
        "jquery"
    ],
    function (
        preview,
        $
    ) {
    "use strict";

    $.fn.previewer = function (options) {
        if (!$(this).length) {
            return this;
        }

        var settings = $.extend({}, options);

        return this.each(function () {
            var $this = $(this);
            var $parent = $this.closest('li');
            var src = settings.src || $this.attr("data-image-src") || $this.attr("src");
            if (src) {
                $this.click(function (e) {
                    var file = {
                        src: src,
                        type: settings.type,
                        thumbnail: src,
                        title: settings.title || $parent.attr("data-file-name") || src,
                        id: $parent.attr("data-attachment-id"),
                        ownerId: $parent.attr("data-owner-id")
                    };
                    var deferred = preview.loadConfluencePreviews([file],
                        settings.viewMode || "simple",
                        settings.from || "custom"
                    );
                    settings.zindex && deferred.done(function() {
                        $(".cp-container").css({"z-index": settings.zindex});
                    });
                });
            }
        });
    };
});