define("cp/confluence/preview-support",
    [
        "ajs"
    ],
    function(
        AJS
        ) {

        "use strict";

        var getFileSelectorStringImageAndPdf = function() {
            var selector = PreviewSupport.SELECTOR_STRINGS.IMAGE + ", " + PreviewSupport.SELECTOR_STRINGS.LINK_IMAGE
                    + ", " + PreviewSupport.SELECTOR_STRINGS.EXTERNAL_IMAGE;
            if (PreviewSupport.isPDFSupported()) {
                selector += ", " + PreviewSupport.SELECTOR_STRINGS.PDF + ", " + PreviewSupport.SELECTOR_STRINGS.LINK_PDF;
            }
            return selector;
        };

        var getFileSelectorStringAllFileTypes = function() {
            return PreviewSupport.SELECTOR_STRINGS.IMAGE + ", " + PreviewSupport.SELECTOR_STRINGS.EXTERNAL_IMAGE
                + ", " + PreviewSupport.SELECTOR_STRINGS.FILE + ", " + PreviewSupport.SELECTOR_STRINGS.LINK_FILE
                    + ", " + PreviewSupport.SELECTOR_STRINGS.ATTACHMENT_MACRO;
        };

        var PreviewSupport = {
            SELECTOR_STRINGS: {
                IMAGE: "img.confluence-embedded-image[data-linked-resource-id]",
                EXTERNAL_IMAGE: "img.confluence-embedded-image.confluence-external-resource",
                PDF: "a.confluence-embedded-file[data-nice-type='PDF Document']",
                LINK_IMAGE: "a[data-linked-resource-type='attachment'][data-nice-type='Image']",
                LINK_PDF: "a[data-linked-resource-type='attachment'][data-nice-type='PDF Document']",
                FILE: "a.confluence-embedded-file",
                LINK_FILE: "a[data-linked-resource-type='attachment']",
                FILE_OVERLAY: "span.confluence-embedded-file-wrapper .overlay",
                ATTACHMENT_MACRO: ".plugin_attachments_container a.previewAttachmentLink"
            },

            VIEW_MODE: {
                FULL: "full", // full support features.
                COMMENT: "comment", // does not support mini mode but supports annotation.
                SIMPLE: "simple" // does not support both mini mode and annotation.
            },

            isPDFSupported: function() {
                return AJS.DarkFeatures.isEnabled('pdf-preview');
            },

            getFileSelectorString: function() {
                if (AJS.DarkFeatures.isEnabled('previews.trigger-all-file-types')) {
                    return getFileSelectorStringAllFileTypes();
                } else {
                    return getFileSelectorStringImageAndPdf();
                }
            }
        };

        return PreviewSupport;
    });