define("cp/service/files-service",
    [
        "ajs",
        "jquery",
        "underscore",
        "cp/service/service-helpers"
    ],
    function(
        AJS,
        $,
        _,
        serviceHelpers
        ) {
        'use strict';

        var contextPath = AJS.contextPath();

        function FilesService(contentID) {
            this.url = contextPath + "/rest/files/1.0/files/content/" + contentID;
        }

        FilesService.prototype.getFiles = function(params) {
            var dfd = $.Deferred();
            var opts = _.extend({}, params);
            $.ajax({
                url: this.url,
                type: "GET",
                data: {
                    'limit': opts.limit,
                    'start': opts.start
                },
                dataType: "json"
            }).then(function(data) {
                var files = _.map(data.results, serviceHelpers.responseToFile);
                dfd.resolve(files);
            }).fail(function (jqXHR, textStatus, errorThrown) {
                dfd.reject(jqXHR, textStatus, errorThrown);
            });
            return dfd.promise();
        };

        FilesService.prototype.getFilesWithId = function(attachmentIds) {
            var dfd = $.Deferred();
            $.ajax({
                url: this.url + "/byAttachmentIds",
                type: "POST",
                data: JSON.stringify({'attachmentIds': attachmentIds}),
                dataType: "json",
                contentType: "application/json; charset=utf-8"
            }).then(function(data) {
                var files = _.map(data.results, serviceHelpers.responseToFile);
                dfd.resolve(files);
            }).fail(function (jqXHR, textStatus, errorThrown) {
                dfd.reject(jqXHR, textStatus, errorThrown);
            });
            return dfd.promise();
        };

        FilesService.prototype.getFileWithId = function(attachmentId) {
            return this.getFilesWithId([attachmentId])
                .then(function(files) {
                    return files[0];
                });
        };

        FilesService.prototype.getFilesWithoutId = function(attachmentIds) {
            var dfd = $.Deferred();
            $.ajax({
                url: this.url + "/minusAttachmentIds",
                type: "POST",
                data: JSON.stringify({
                    'attachmentIds': attachmentIds
                }),
                dataType: "json",
                contentType: "application/json; charset=utf-8"
            }).then(function(data) {
                var files = _.map(data.results, serviceHelpers.responseToFile);
                dfd.resolve(files);
            }).fail(function (jqXHR, textStatus, errorThrown) {
                dfd.reject(jqXHR, textStatus, errorThrown);
            });
            return dfd.promise();
        };

        return FilesService;
    }
);
