define("cp/service/versions-service",
    [
        "ajs",
        "jquery",
        "underscore",
        "cp/service/service-helpers"
    ],
    function(
        AJS,
        $,
        _,
        serviceHelpers
        ) {
        'use strict';

        var contextPath = AJS.contextPath();

        var getAttachmentByIdAndVersion = function(contentId, attachmentId, attachmentVersion) {
            return $.ajax({
                url: contextPath + "/rest/files/1.0/files/content/" +  contentId + "/byAttachmentId",
                type: "GET",
                dataType: "json",
                contentType: "application/json; charset=utf-8",
                data: {attachmentId: attachmentId, attachmentVersion: attachmentVersion}
            }).then(function (data) {
                return serviceHelpers.responseToFile(data);
            });
        };

        function VersionsService() {}

        VersionsService.prototype.getAllFileVersions = function(fileId) {
            var url = contextPath + "/rest/files/1.0/files/" + fileId + "/versions";
            return $.ajax(url).then(function (response) {
                var versions = response.results;
                return _.sortBy(_.map(versions, function (version) {
                    return {
                        id: version.id,
                        version: version.version.number,
                        message: version.version.message,
                        countComments: version.countComments,
                        ownerId: version.ownerId
                    };
                }), function (version) {
                    return 0 - version.version; // descending order by version number
                });
            });
        };

        // TODO: use attachment service instead
        VersionsService.prototype.getFileVersion = function(contentId, attachmentId, attachmentVersion) {
            return getAttachmentByIdAndVersion(contentId, attachmentId, attachmentVersion);
        };

        return VersionsService;
    }
);

