(function($) {
    $(document).ready(function () {

        var ACCEPTED_MIME_TYPES = ["image/vnd.microsoft.icon", "image/x-icon", "image/x-png", "image/png", "image/jpeg", "image/gif"];
        var THUMBNAIL_HEIGHT = 100;
        var THUMBNAIL_WIDTH = 100;
        var MAX_FILE_SIZE = 2097152;

        $("#faviconFile").change(function (e) {
            var input = e.target;
            var showError = false;
            if (input.files && input.files[0]) {
                var file = input.files[0];
                $("#favicon-action-messages").empty();
                $("#favicon-preview").hide();

                // Check that the file type is supported before enabling uploads
                if ($.inArray(file.type, ACCEPTED_MIME_TYPES) >= 0) {
                    $("#favicon-upload").prop("disabled", false).removeAttr("aria-disabled");

                    if (file.size <= MAX_FILE_SIZE) {
                        // If HTML5 file API is supported, display a thumbnail of the uploaded image.
                        if (window.File && window.FileReader) {
                            var reader = new FileReader();
                            reader.onload = function (ev) {
                                $("#favicon-preview").attr("src", ev.target.result)
                                    .width(THUMBNAIL_WIDTH)
                                    .height(THUMBNAIL_HEIGHT);
                                $("#favicon-preview").show();
                            };
                            reader.readAsDataURL(file);
                        }
                    } else {
                        AJS.messages.error("#favicon-action-messages", {
                            body: AJS.I18n.getText("custom.favicon.file.too.large")
                        });
                        showError = true;
                    }
                } else {
                    AJS.messages.error("#favicon-action-messages", {
                        body: AJS.I18n.getText("custom.favicon.unsupported.image.type")
                    });
                    showError = true;
                }

                if (showError) {
                    $("#favicon-upload").prop("disabled", true).attr("aria-disabled", true);
                }

            }
        });
    });
})(AJS.$);