(function ($) {
    function convertToUserKeys($container, pageData, dataKey) {
        var usersList = $container.find('#daci-' + dataKey).select2('data');
        var usersByUserKey = usersList
            .map(function (user) {
                return user.userKey;
            })
            .join(',');

        pageData[dataKey] = usersByUserKey;
    }

    function pageSubmit(e, state) {
        convertToUserKeys(state.$container, state.pageData, 'driver');
        convertToUserKeys(state.$container, state.pageData, 'approver');
    }

    function bindFields(e, state) {
        AJS.trigger('analyticsEvent', { name: 'confluence-spaces.playbook.daci.clicked' });

        $('#daci-due-date').datePicker({
            overrideBrowserDefault: true,
            dateFormat: 'yy-mm-dd',
        });

        $('#daci-status').on('change', function () {
            var $finalDecision = $('#daci-outcome');
            var $decisionLabel = $('label[for=daci-outcome]');
            if ($(this).find(':selected').val() == 'GREEN') {
                $finalDecision.css({ display: 'inline' });
                $decisionLabel.css({ display: 'inline' });
            } else {
                $finalDecision.css({ display: 'none' });
                $decisionLabel.css({ display: 'none' });
            }
        });
    }

    Confluence.Blueprint.setWizard(
        'com.atlassian.confluence.plugins.atlassian-playbook-blueprints:dacidecision-blueprint-item',
        function (wizard) {
            wizard.on('post-render.daciDecisionWizard-form', bindFields);
            wizard.on('submit.daciDecisionWizard-form', pageSubmit);
        }
    );
})(AJS.$);
