define('diagnostics/date-format',
    [
        'exports'
    ],
    function(exports) {
        'use strict';

        function datePad(text) {
            text = "" + text;
            while(text.length < 2) {
                text = "0" + text;
            }
            return text;
        }

        function toFormattedDate(timestamp) {
            var date = new Date(timestamp);
            var hours = date.getHours();
            var postfix = "AM";
            if (hours >= 12) {
                postfix = "PM";

                if(hours !== 12) {
                    hours -= 12;
                }
            }

            return datePad(date.getDate()) + "-" + datePad(date.getMonth() + 1) + "-" +
                date.getFullYear() + " " + datePad(hours) + ":" + datePad(date.getMinutes()) + " " + postfix;
        }

        exports.toFormattedDate = toFormattedDate;
    }
);
