define('diagnostics/paging', ['exports'],
    function(exports) {
        'use strict';

        var callback;

        function getLink(start, limit) {
            return "#start=" + start + "&limit=" + limit
        }

        function getHashValue(key) {
            var matches = location.hash.match(new RegExp(key+'=([^&]*)'));
            return matches && matches[1];
        }

        function getPageData() {
            return {
                start: parseInt(getHashValue("start") || 0),
                limit: parseInt(getHashValue("limit") || 25)
            };
        }

        function setPageData(start, limit) {
            window.location.hash = getLink(start, limit);
        }

        function setChangeCallback(cb) {
            callback = cb;
        }

        function renderHtmlContainer($container, data) {
            var hasPrev = !!data.links.filter(function(x){return x.rel === "prev"})[0];
            var hasNext = !!data.links.filter(function(x){return x.rel === "next"})[0];
            var pageData = getPageData();

            if (hasPrev || hasNext) {
                $container.html(diagnostics.paging.page({
                    prev: hasPrev ? getLink(pageData.start - pageData.limit, pageData.limit) : undefined,
                    next: hasNext ? getLink(pageData.start + pageData.limit, pageData.limit) : undefined
                }));
            }
        }

        window.addEventListener("hashchange", function() {
            if(callback && typeof callback === "function") {
                callback();
            }
        });

        exports.getPageData = getPageData;
        exports.setPageData = setPageData;
        exports.getLink = getLink;
        exports.setChangeCallback = setChangeCallback;
        exports.renderHtmlContainer = renderHtmlContainer;
    }
);
