/**
 * @module confluence/easyusersignupsettings
 */
define('confluence/easyusersignupsettings', [
    'jquery',
    'ajs',
    'confluence/form-state-control'
], function(
    $,
    AJS,
    FormStateControl
) {
    'use strict';

    function EasyUserSignupSettings() {
        var $formsContainer = $('#easyuser-forms-container');
        var $signupMessageContainer = $('#signup-user-errors');
        var $saveButton = $('#save');
        var $modeSelect = $('input[name="signupMode"]');
        var $domainsSignupContainer = $('#domains-signup-container');
        var $domains = $('#domains-signup');
        var $signupEnabledCheckbox = $('#isSignupEnabled');
        var $publicOptionsContainer = $('#restrictedModesBorder-container');
        var $smtpMessage = $('#configure-smtp-msg-signup');
        var $signupModeRestricted = $('#signupMode-restricted');

        if ($smtpMessage.length) {
            AJS.MessageHandler.message($signupMessageContainer, $smtpMessage.html(), 'warning');
        }

        var checkDomains = function() {
            var val = $domains.val();
            if (!val || /^\s*$/.test(val)) {
                $saveButton.prop('disabled', true);
            } else {
                $saveButton.prop('disabled', false);
            }
        };

        $('#easyuser-signup-domains-form').submit(function() {
            var mode = $('input:radio[name=signupMode]:checked').val();
            var notifyAdmin = $('#notifyAdmin').prop('checked');

            if (!$('#isSignupEnabled').prop('checked')) {
                mode = 'private';
            }

            if (mode != 'restricted') {
                $domains.val('');
            }
            var domains = $domains.val();
            var dataObj = { enabled: mode === 'public', domains: domains, notifyAdmin: notifyAdmin };

            $saveButton.prop('disabled', true);

            $.ajax({
                url: AJS.contextPath() + '/rest/easyuser/latest/signup/setSignupSettings',
                type: 'POST',
                dataType: 'json',
                contentType: 'application/json',
                processData: false,
                data: $.toJSON(dataObj),
                success: function(data) {
                    $saveButton.prop('disabled', false);
                    AJS.MessageHandler.message($signupMessageContainer, AJS.I18n.getText('easyuser.signup.settings.success'));

                    $formsContainer.toggleClass('private-signup', mode === 'private' || mode === 'restricted');
                    $formsContainer.toggleClass('public-signup', mode === 'public');
                    // $formsContainer.toggleClass('disabled-signup', mode === 'disabled');
                },
                error: function(xhr, statusText, error) {
                    $saveButton.removeProp('disabled');
                    AJS.log('Saving sign up settings errors: [statusText = \'' + statusText + '\'], [error = \'' + error + '\']');
                    AJS.MessageHandler.message($signupMessageContainer, AJS.I18n.getText('easyuser.signup.settings.error'), 'error');
                },
                statusCode: {
                    401: function() {
                        AJS.MessageHandler.message($messageContainer, AJS.I18n.getText('easyuser.authentication.error'), 'error');
                    }
                }
            });
            return false;
        });

        $modeSelect.change(function() {
            var mode = this.value;

            $('input:radio[name=signupMode]').prop('checked', false);
            $(this).prop('checked', true);

            if (mode === 'restricted') {
                checkDomains();
                $domainsSignupContainer.show();
                $domains.focus();
            } else {
                $domainsSignupContainer.hide();
                $saveButton.prop('disabled', false);
            }
        });

        $domains.keyup(function() {
            checkDomains();
        });

        $signupEnabledCheckbox.change(function() {
            var isChecked = this.checked;

            if (isChecked === true) { // public/domain restricted signup
                $publicOptionsContainer.css({ opacity: 1 });
                FormStateControl.enableElement($modeSelect);
                if (!$signupModeRestricted.data('ajs-capable')) {
                    FormStateControl.disableElement($signupModeRestricted);
                }
            } else { // private signup
                $modeSelect.change();
                FormStateControl.disableElement($modeSelect);
                $saveButton.prop('disabled', false);
                $publicOptionsContainer.css({ opacity: 0.5 });
            }
        });
    }

    return EasyUserSignupSettings;
});

require('confluence/module-exporter').safeRequire('confluence/easyusersignupsettings', function(EasyUserSignupSettings) {
    'use strict';

    var AJS = require('ajs');

    AJS.toInit(EasyUserSignupSettings);
});
