/**
 * @module confluence-editor-loader/block-and-buffer-keys
 */
define('confluence-editor-loader/block-and-buffer-keys', [
], function(
) {
    'use strict';

    // TODO Move this to core Confluence and modify it to also take a TinyMCE Editor as a block object
    // This could then also be used by the find and replace plugin (which is currently duplicating
    // most of this).

    function _cancelKeyboardFunction(e) {
        e.preventDefault();
        e.stopPropagation();
    }

    /* Handle UTF-16 surrogate pair character codes */
    function _surrogatePairFixedFromCharCode(code) {
        if (code > 0xFFFF) {
            code -= 0x10000;
            return String.fromCharCode(0xD800 + (code >> 10), 0xDC00 + (code & 0x3FF));
        }

        return String.fromCharCode(code);
    }

    /*
     * Buffer any character codes being typed and also prevent
     * the event that is instigating them.
     */
    function _bufferTextFunction(e, buffer) {
        _cancelKeyboardFunction(e);

        var keyCode = e.which;
        // IE8 doesn't have charCode for keypress event
        if (!keyCode) {
            keyCode = e.charCode ? e.charCode : e.keyCode;
        }

        // Firefox and Opera wrongly raise keypress for control characters
        if (keyCode !== 13 && keyCode < 48) {
            return;
        }

        buffer.push(keyCode);
    }

    /**
     * @return String the buffered text the user may have entered
     */
    function _unblock($jq, keycodeBuffer, blockFunc) {
        $jq.unbind('keypress', blockFunc);

        var bufferedText = '';
        for (var i = 0; i < keycodeBuffer.length; i++) {
            bufferedText += _surrogatePairFixedFromCharCode(keycodeBuffer[i]);
        }

        return bufferedText;
    }

    /* -------------------------- Public API -------------------------- */
    var BlockAndBuffer = {};

    /**
     * Block keys on the supplied jQuery DOM object.
     *
     * @param $jq jQuery wrapped Element.
     * @return the zero argument unblock function you should run when you want to cancel the block. This will return
     * the buffer as a String.
     */
    BlockAndBuffer.block = function($jq) {
        var keycodeBuffer = [];

        var bufferText = function(e) {
            _bufferTextFunction(e, keycodeBuffer);
            e.preventDefault();
        };

        $jq.keypress(bufferText);

        return function() {
            return _unblock($jq, keycodeBuffer, bufferText);
        };
    };

    return BlockAndBuffer;
});

require('confluence/module-exporter').exportModuleAsGlobal('confluence-editor-loader/block-and-buffer-keys', 'AJS.Confluence.BlockAndBuffer');
