define('applinks/common/oauth2/rest-client', [
    'applinks/lib/aui',
    'applinks/common/rest-request',
    'applinks/common/preconditions'
], function(
    AJS,
    ApplinksRestRequest,
    Preconditions
) {
    function ApplinksOAuth2ClientRestModule(version) {
        Preconditions.hasValue(version, 'version');
        this._version = version;
    }

    ApplinksOAuth2ClientRestModule.prototype.baseUrl = function() {
        return AJS.contextPath() + '/rest/oauth2-client/' + this._version + '/';
    }
    
    ApplinksOAuth2ClientRestModule.prototype._withPath = function(path) {
        return this.baseUrl() + path;
    };

    function ApplinksOAuthV1RestModule() {
        this.module = new ApplinksOAuth2ClientRestModule('1.0');
    }
    
    ApplinksOAuthV1RestModule.prototype.config = function(configId) {
        Preconditions.hasValue(configId, 'config');
        return new ApplinksRestRequest(this.module._withPath('config/' + configId));
    };

    return {
        V1: new ApplinksOAuthV1RestModule()
    }
});
