import { Field } from '@atlaskit/form';
import { I18n } from '@atlassian/wrm-react-i18n';
import React from 'react';
import TextField from '@atlaskit/textfield';

interface ApplicationUrlFieldProps {
    applicationUrl: string;
}

export function ApplicationUrlField(props: ApplicationUrlFieldProps) {
    const { applicationUrl } = props;

    return (
        <Field
            aria-required={true}
            name="applicationUrl"
            label={I18n.getText('applinks-atlassian-oauth2-ui.application-url')}
            isDisabled={true}
            defaultValue={applicationUrl}
        >
            {({ fieldProps }) => <TextField {...fieldProps} />}
        </Field>
    );
}
