import React from 'react';
import { PermissionsContext } from './permissions/PermissionsContext';
import { PermissionsSelect } from './permissions/PermissionsSelect';

export function IncomingScopeField({ substate, providerData }) {
    const { incomingApplicationLinkDetails, enteredIncomingScope } = substate;
    const incomingScopes =
        enteredIncomingScope ||
        (incomingApplicationLinkDetails && incomingApplicationLinkDetails.incomingScopes);
    const availableIncomingScopes =
        incomingApplicationLinkDetails && incomingApplicationLinkDetails.availableIncomingScopes;

    return (
        <PermissionsContext.Provider value={providerData}>
            <PermissionsSelect
                scope={incomingScopes}
                availableIncomingScopes={availableIncomingScopes}
            />
        </PermissionsContext.Provider>
    );
}
