import {
    getCreateIncomingLinkIntermediateDetails,
    getUpdateIncomingLinkIntermediateDetails,
    postCreateIncomingLink,
    putUpdateIncomingLink,
} from '../AtlassianOauth2UiRest';
import { dispatchIncomingApplinkCreatedEvent } from '../atlassianOauth2UiEvents';

export async function performGetCreateIncomingLinkIntermediateDetails(correctedUrl, dispatch) {
    try {
        const intermediateIncomingApplicationLinkDetails =
            await getCreateIncomingLinkIntermediateDetails(correctedUrl);
        dispatch({
            type: 'cil:intermediateGetSuccessful',
            incomingApplicationLinkDetails: intermediateIncomingApplicationLinkDetails,
        });
    } catch (error) {
        console.error('error in performGetCreateIncomingLinkIntermediateDetails', error);
        dispatch({
            type: 'cil:intermediateGetFailed',
            error,
        });
    }
}

export async function performGetUpdateIncomingLinkIntermediateDetails(applinkId, dispatch) {
    try {
        const intermediateIncomingApplicationLinkDetails =
            await getUpdateIncomingLinkIntermediateDetails(applinkId);
        dispatch({
            type: 'cil:intermediateGetSuccessful',
            incomingApplicationLinkDetails: intermediateIncomingApplicationLinkDetails,
        });
    } catch (error) {
        console.error('error in performGetUpdateIncomingLinkIntermediateDetails', error);
        dispatch({
            type: 'cil:intermediateGetFailed',
            error,
        });
    }
}

export async function performPostCreateIncomingLink(
    substate,
    redirectUri,
    incomingScopesString,
    dispatch
) {
    const { rpcUrl, displayUrl } = substate.incomingApplicationLinkDetails;

    dispatch({
        type: 'cil:postStarted',
        enteredRedirectUriValue: redirectUri,
        enteredIncomingScope: incomingScopesString,
    });
    try {
        const finalIncomingApplicationLinkDetails = await postCreateIncomingLink(
            rpcUrl,
            displayUrl,
            redirectUri,
            incomingScopesString
        );
        dispatch({
            type: 'cil:postSuccessful',
        });

        dispatchIncomingApplinkCreatedEvent(finalIncomingApplicationLinkDetails.id);
        dispatch({
            type: 'ild:openWithDetails',
            incomingApplicationLinkDetails: finalIncomingApplicationLinkDetails,
        });
    } catch (error) {
        console.error('error in performPostCreateIncomingLink', error);
        dispatch({
            type: 'cil:postFailed',
            error,        
        });
    }
}

export async function performPutUpdateIncomingLink(
    applinkId,
    redirectUri,
    incomingScopesString,
    dispatch
) {
    dispatch({
        type: 'cil:postStarted',
        enteredRedirectUriValue: redirectUri,
        enteredIncomingScope: incomingScopesString,
    });
    try {
        await putUpdateIncomingLink(applinkId, redirectUri, incomingScopesString);
        const finalIncomingApplicationLinkDetails =
            await getUpdateIncomingLinkIntermediateDetails(applinkId);
        dispatch({
            type: 'cil:postSuccessful',
        });

        dispatchIncomingApplinkCreatedEvent(applinkId);
        dispatch({
            type: 'ild:openWithDetails',
            incomingApplicationLinkDetails: finalIncomingApplicationLinkDetails,
        });
    } catch (error) {
        console.error('error in performPutUpdateIncomingLink', error);
        dispatch({
            type: 'cil:postFailed',
            error,        
        });
    }
}

export function isValidHttpUrl(string) {
    let url;

    try {
        url = new URL(string);
    } catch (e) {
        return false;
    }

    return url.protocol === 'http:' || url.protocol === 'https:';
}
