import * as React from 'react';

const defaultConstants = {
    product: '',
    descriptions: {
        scopes: undefined,
        consent: undefined,
    },
};

type ScopeDescription = {
    title: string;
    descriptions: string[];
};

export type ScopeDescriptions = Record<string, ScopeDescription>;

type PermissionsContextType = {
    product: string;
    descriptions: {
        scopes?: ScopeDescriptions;
        consent?: ScopeDescriptions;
    };
};

export const PermissionsContext = React.createContext<PermissionsContextType>(defaultConstants);
