import React from 'react';

import { DropdownPermissions } from '../DropdownPermissions';
import { BambooPermission } from '../permissions';

const bambooSelectOptions = [
    { label: 'Read', value: 'READ' },
    { label: 'Trigger', value: 'TRIGGER' },
    { label: 'User', value: 'USER' },
];

function bambooScopeToSelectOption(scope) {
    switch (scope) {
        case 'READ':
            return bambooSelectOptions[0];
        case 'TRIGGER':
            return bambooSelectOptions[1];
        case 'USER':
            return bambooSelectOptions[2];
        default:
            return bambooSelectOptions[0];
    }
}

export function bambooPermissionRank(permission) {
    switch (permission) {
        case BambooPermission.READ:
            return 0;
        case BambooPermission.TRIGGER:
            return 1;
        case BambooPermission.USER:
            return 2;
    }
}

export function handleInheritedBambooScopes(scopes) {
    if (scopes.includes(BambooPermission.USER)) {
        scopes = scopes.concat(BambooPermission.TRIGGER, BambooPermission.READ);
    } else if (scopes.includes(BambooPermission.TRIGGER)) {
        scopes = scopes.concat(BambooPermission.READ);
    }

    return scopes;
}

export function PermissionsBamboo({ scope }) {
    return (
        <DropdownPermissions
            scope={scope}
            getPermissionRank={bambooPermissionRank}
            scopeToSelectOption={bambooScopeToSelectOption}
            selectOptions={bambooSelectOptions}
            handleInheritedScopes={handleInheritedBambooScopes}
        />
    );
}
