import { BitbucketPermission } from '../permissions';

function getBitbucketScope(formInput) {
    return Object.entries(formInput)
        .reduce((acc, entry) => {
            if (Object.values(BitbucketPermission).includes(entry[0]) && entry[1][0] === 'true') {
                return [...acc, entry[0]];
            }
            return acc;
        }, [])
        .toString()
        .replace(/,/g, ' ');
}

export function getScopeFromForm(product, formInput) {
    if ('scope' in formInput) {
        return formInput.scope ? formInput.scope.value : undefined;
    } else {
        return getBitbucketScope(formInput);
    }
}
