import React from 'react';
import { CopyableField } from './CopyableField';
import { I18n } from '@atlassian/wrm-react-i18n';

export function ClientIdField(props) {
    const { incomingApplicationLinkDetails } = props;

    const value = incomingApplicationLinkDetails
        ? incomingApplicationLinkDetails.incomingClientId
        : null;

    return (
        <CopyableField
            name="clientId"
            label={I18n.getText('applinks-atlassian-oauth2-ui.client-id')}
            value={value}
            type="password"
        />
    );
}
