import { CopyableField } from './CopyableField';
import { I18n } from '@atlassian/wrm-react-i18n';
import React from 'react';

export function ClientSecretField(props) {
    const { incomingApplicationLinkDetails } = props;

    const value = incomingApplicationLinkDetails
        ? incomingApplicationLinkDetails.incomingClientSecret
        : null;

    return (
        <CopyableField
            name="clientSecret"
            value={value}
            label={I18n.getText('applinks-atlassian-oauth2-ui.client-secret')}
            type="password"
        />
    );
}
